/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.IOException;
import java.util.List;
import opennlp.tools.ml.maxent.io.GISModelWriter;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.ComparablePredicate;

public abstract class QNModelWriter
extends GISModelWriter {
    public QNModelWriter(AbstractModel model) {
        super(model);
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("QN");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String outcomeLabel : this.OUTCOME_LABELS) {
            this.writeUTF(outcomeLabel);
        }
        ComparablePredicate[] sorted2 = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.compressOutcomes(sorted2);
        this.writeInt(compressed.size());
        for (List<ComparablePredicate> a : compressed) {
            this.writeUTF(a.size() + a.get(0).toString());
        }
        this.writeInt(this.PARAMS.length);
        for (ComparablePredicate predicate : sorted2) {
            this.writeUTF(predicate.name);
        }
        for (ComparablePredicate comparablePredicate : sorted2) {
            for (int j = 0; j < comparablePredicate.params.length; ++j) {
                this.writeDouble(comparablePredicate.params[j]);
            }
        }
        this.close();
    }
}

