/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DominoAttr
implements NodeInfo {
    private DominoTree tree;
    private DominoNode parent;
    private final Attr domAttr;

    public DominoAttr(DominoTree tree, DominoNode parent, Attr domAttr) {
        this.tree = tree;
        this.parent = parent;
        this.domAttr = domAttr;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.tree;
    }

    @Override
    public int getNodeKind() {
        return 2;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DominoAttr && this.parent.equals(((DominoAttr)other).parent) && this.getLocalPart().equals(((DominoAttr)other).getLocalPart()) && this.getURI().equals(((DominoAttr)other).getURI());
    }

    @Override
    public String getSystemId() {
        return this.tree.getSystemId();
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareOrder(NodeInfo other) {
        Node otherDomNode;
        if (other instanceof DominoAttr) {
            otherDomNode = ((DominoAttr)other).domAttr;
        } else if (other instanceof DominoNode) {
            otherDomNode = ((DominoNode)other).getDomNode();
        } else {
            return -other.compareOrder(this);
        }
        if (this.equals(other)) {
            return 0;
        }
        Attr attr = this.domAttr;
        synchronized (attr) {
            short relationship = this.domAttr.compareDocumentPosition(otherDomNode);
            if ((relationship & 0xA) != 0) {
                return 1;
            }
            if ((relationship & 0x14) != 0) {
                return -1;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean hasFingerprint() {
        return false;
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String getLocalPart() {
        return this.domAttr.getLocalName();
    }

    @Override
    public String getURI() {
        String uri = this.domAttr.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    @Override
    public String getDisplayName() {
        return this.domAttr.getNodeName();
    }

    @Override
    public String getPrefix() {
        String name = this.domAttr.getNodeName();
        int colon = name.indexOf(58);
        if (colon < 0) {
            return "";
        }
        return name.substring(0, colon);
    }

    @Override
    public SchemaType getSchemaType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public NodeInfo getParent() {
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return this.parent.iterateAxis((byte)1, nodeTest);
            }
            case 1: {
                if (nodeTest.matchesNode(this)) {
                    return new PrependAxisIterator(this, this.parent.iterateAxis((byte)1, nodeTest));
                }
                return this.parent.iterateAxis((byte)1, nodeTest);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.parent, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.getParent().getRoot();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append("a");
        buffer.append(Integer.toString(this.tree.getNamePool().allocateFingerprint(this.getURI(), this.getLocalPart())));
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    @Override
    public String getStringValue() {
        return this.domAttr.getValue();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.domAttr.getValue();
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValue());
    }

    @Override
    public Location saveLocation() {
        return null;
    }

    @Override
    public void setSystemId(String systemId) {
    }
}

