/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanWithinQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithinSpans
extends Spans {
    private final Logger log = LoggerFactory.getLogger(WithinSpans.class);
    public static final boolean DEBUG = false;
    private boolean more = false;
    boolean nextSpanB = true;
    private int wrapStart = -1;
    private int wrapEnd = -1;
    private int embeddedStart = -1;
    private int embeddedEnd = -1;
    private int wrapDoc = -1;
    private int embeddedDoc = -1;
    private int matchDoc = -1;
    private int matchStart = -1;
    private int matchEnd = -1;
    private Collection<byte[]> matchPayload = new LinkedList<byte[]>();
    private Collection<byte[]> embeddedPayload;
    private boolean inSameDoc = false;
    public static final byte OVERLAP = 0;
    public static final byte REAL_OVERLAP = 2;
    public static final byte WITHIN = 4;
    public static final byte REAL_WITHIN = 6;
    public static final byte ENDSWITH = 8;
    public static final byte STARTSWITH = 10;
    public static final byte MATCH = 12;
    private byte flag;
    private SpanWithinQuery query;
    private final Spans wrapSpans;
    private final Spans embeddedSpans;
    private boolean tryMatch = true;
    private LinkedList<WithinSpan> spanStore1;
    private LinkedList<WithinSpan> spanStore2;

    public WithinSpans(SpanWithinQuery spanWithinQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts, byte flag) throws IOException {
        this.wrapSpans = spanWithinQuery.wrap().getSpans(context, acceptDocs, termContexts);
        this.embeddedSpans = spanWithinQuery.embedded().getSpans(context, acceptDocs, termContexts);
        this.flag = flag;
        this.spanStore1 = new LinkedList();
        this.spanStore2 = new LinkedList();
        this.query = spanWithinQuery;
    }

    @Override
    public boolean next() throws IOException {
        if (!this.init()) {
            this.more = false;
            this.inSameDoc = false;
            this.wrapDoc = Integer.MAX_VALUE;
            this.embeddedDoc = Integer.MAX_VALUE;
            this.matchDoc = Integer.MAX_VALUE;
            return false;
        }
        while (this.more && (this.wrapDoc == this.embeddedDoc || this.toSameDoc())) {
            if (this.tryMatch && this.doesMatch()) {
                if (this.wrapEnd == -1) {
                    this.wrapEnd = this.wrapSpans.end();
                }
                this.matchStart = this.embeddedStart < this.wrapStart ? this.embeddedStart : this.wrapStart;
                this.matchEnd = this.embeddedEnd > this.wrapEnd ? this.embeddedEnd : this.wrapEnd;
                this.matchDoc = this.embeddedDoc;
                this.matchPayload.clear();
                if (this.embeddedPayload != null) {
                    this.matchPayload.addAll(this.embeddedPayload);
                }
                if (this.wrapSpans.isPayloadAvailable()) {
                    this.matchPayload.addAll(this.wrapSpans.getPayload());
                }
                this.tryMatch = false;
                return true;
            }
            if (this.nextSpanB) {
                this.tryMatch = true;
                WithinSpan current = null;
                while (!this.spanStore2.isEmpty()) {
                    current = this.spanStore2.removeFirst();
                    if (current.doc < this.wrapDoc) continue;
                }
                if (current == null) {
                    if (!this.embeddedSpans.next()) {
                        this.nextSpanA();
                        continue;
                    }
                    this.embeddedStart = this.embeddedSpans.start();
                    this.embeddedEnd = -1;
                    this.embeddedPayload = null;
                    this.embeddedDoc = this.embeddedSpans.doc();
                    if (this.embeddedDoc != this.wrapDoc) {
                        this.storeEmbedded();
                        this.inSameDoc = true;
                        this.embeddedDoc = this.wrapDoc;
                        this.nextSpanA();
                        continue;
                    }
                    if (this.embeddedDoc != this.wrapDoc) {
                        this.embeddedStart = -1;
                        this.embeddedEnd = -1;
                        this.embeddedPayload = null;
                        if (!this.toSameDoc()) {
                            this.more = false;
                            this.inSameDoc = false;
                            return false;
                        }
                    }
                    this.more = true;
                    this.inSameDoc = true;
                    this.tryMatch = true;
                    this.nextSpanB();
                    continue;
                }
                this.embeddedStart = current.start;
                this.embeddedEnd = current.end;
                this.embeddedDoc = current.doc;
                if (current.payload != null) {
                    this.embeddedPayload = new ArrayList<byte[]>(current.payload.size());
                    this.embeddedPayload.addAll(current.payload);
                } else {
                    this.embeddedPayload = null;
                }
                this.tryMatch = true;
                continue;
            }
            this.tryMatch = true;
            if (!this.spanStore1.isEmpty()) {
                this.spanStore2.addAll(0, (LinkedList)this.spanStore1.clone());
                this.spanStore1.clear();
            }
            if (this.wrapSpans.next()) {
                this.wrapStart = this.wrapSpans.start();
                this.wrapEnd = -1;
                this.wrapDoc = this.wrapSpans.doc();
                if (this.embeddedDoc != this.wrapDoc) {
                    this.spanStore1.clear();
                    this.spanStore2.clear();
                    this.embeddedStart = -1;
                    this.embeddedEnd = -1;
                    this.embeddedPayload = null;
                    if (!this.toSameDoc()) {
                        this.inSameDoc = false;
                        this.more = false;
                        return false;
                    }
                } else {
                    this.inSameDoc = true;
                    this.tryMatch = false;
                }
                this.nextSpanB();
                continue;
            }
            this.more = false;
            this.inSameDoc = false;
            this.spanStore1.clear();
            this.spanStore2.clear();
            return false;
        }
        return false;
    }

    private boolean toSameDoc() throws IOException {
        this.more = true;
        this.inSameDoc = true;
        this.wrapDoc = this.wrapSpans.doc();
        if (this.wrapDoc == Integer.MAX_VALUE) {
            this.more = false;
            this.matchDoc = Integer.MAX_VALUE;
            this.inSameDoc = false;
            return false;
        }
        try {
            this.embeddedDoc = this.embeddedSpans.doc();
        }
        catch (NullPointerException e) {
            this.more = false;
            this.matchDoc = Integer.MAX_VALUE;
            this.inSameDoc = false;
            return false;
        }
        if (this.wrapDoc == this.embeddedDoc) {
            this.matchDoc = this.embeddedDoc;
            return true;
        }
        while (this.wrapDoc != this.embeddedDoc) {
            if (this.wrapDoc < this.embeddedDoc) {
                if (!this.wrapSpans.skipTo(this.embeddedDoc)) {
                    this.more = false;
                    this.inSameDoc = false;
                    this.matchDoc = Integer.MAX_VALUE;
                    return false;
                }
                this.wrapDoc = this.wrapSpans.doc();
                if (this.wrapDoc == Integer.MAX_VALUE) {
                    this.more = false;
                    this.inSameDoc = false;
                    this.embeddedDoc = Integer.MAX_VALUE;
                    this.matchDoc = Integer.MAX_VALUE;
                    return false;
                }
                this.spanStore1.clear();
                this.spanStore2.clear();
                if (this.wrapDoc == this.embeddedDoc) {
                    this.wrapStart = this.wrapSpans.start();
                    this.embeddedStart = this.embeddedSpans.start();
                    this.matchDoc = this.embeddedDoc;
                    return true;
                }
                this.wrapStart = -1;
                this.embeddedStart = -1;
                continue;
            }
            if (this.wrapDoc > this.embeddedDoc) {
                if (!this.embeddedSpans.skipTo(this.wrapDoc)) {
                    this.more = false;
                    this.inSameDoc = false;
                    this.matchDoc = Integer.MAX_VALUE;
                    return false;
                }
                this.embeddedDoc = this.embeddedSpans.doc();
                if (this.embeddedDoc == Integer.MAX_VALUE) {
                    this.more = false;
                    this.inSameDoc = false;
                    this.wrapDoc = Integer.MAX_VALUE;
                    this.matchDoc = Integer.MAX_VALUE;
                    return false;
                }
                this.embeddedStart = this.embeddedSpans.start();
                this.embeddedEnd = -1;
                this.embeddedPayload = null;
                if (this.wrapDoc != this.embeddedDoc) continue;
                this.matchDoc = this.embeddedDoc;
                return true;
            }
            this.matchDoc = Integer.MAX_VALUE;
            return false;
        }
        this.matchDoc = this.wrapDoc;
        return true;
    }

    private boolean init() throws IOException {
        if (this.embeddedDoc >= 0) {
            return true;
        }
        if (!this.embeddedSpans.next() || !this.wrapSpans.next()) {
            this.embeddedDoc = -1;
            this.more = false;
            return false;
        }
        this.more = true;
        this.wrapDoc = this.wrapSpans.doc();
        this.embeddedDoc = this.embeddedSpans.doc();
        if (this.embeddedDoc == this.wrapDoc) {
            this.inSameDoc = true;
        }
        return true;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (!this.init()) {
            return false;
        }
        assert (target > this.embeddedDoc);
        if (this.more && this.embeddedDoc < target) {
            if (this.embeddedSpans.skipTo(target)) {
                this.inSameDoc = false;
                this.embeddedStart = -1;
                this.embeddedEnd = -1;
                this.embeddedPayload = null;
                this.embeddedDoc = this.embeddedSpans.doc();
            } else {
                this.inSameDoc = false;
                this.more = false;
                return false;
            }
        }
        return this.toSameDoc();
    }

    private void nextSpanA() {
        this.tryMatch = false;
        this.nextSpanB = false;
    }

    private void nextSpanB() {
        this.nextSpanB = true;
    }

    private boolean doesMatch() throws IOException {
        if (this.wrapStart == -1) {
            this.wrapStart = this.wrapSpans.start();
        }
        if (this.embeddedStart == -1) {
            this.embeddedStart = this.embeddedSpans.start();
        }
        this.wrapEnd = -1;
        if (this.wrapStart > this.embeddedStart) {
            if (this.flag >= 4) {
                this.nextSpanB();
                return false;
            }
        } else if (this.wrapStart < this.embeddedStart && this.flag >= 10) {
            this.storeEmbedded();
            this.nextSpanA();
            return false;
        }
        if (this.embeddedEnd == -1) {
            this.embeddedEnd = this.embeddedSpans.end();
        }
        byte currentCase = this.withinCase();
        boolean match = false;
        if (currentCase >= 3 && currentCase <= 11) {
            switch (this.flag) {
                case 4: {
                    if (currentCase < 6 || currentCase > 10 || currentCase == 8) break;
                    match = true;
                    break;
                }
                case 6: {
                    if (currentCase != 6 && currentCase != 9 && currentCase != 10) break;
                    match = true;
                    break;
                }
                case 12: {
                    if (currentCase != 7) break;
                    match = true;
                    break;
                }
                case 10: {
                    if (currentCase != 7 && currentCase != 6) break;
                    match = true;
                    break;
                }
                case 8: {
                    if (currentCase != 7 && currentCase != 10) break;
                    match = true;
                    break;
                }
                case 0: {
                    match = true;
                    break;
                }
                case 2: {
                    if (currentCase != 3 && currentCase != 11) break;
                    match = true;
                }
            }
        }
        try {
            this.todo(currentCase);
        }
        catch (IOException e) {
            return false;
        }
        return match;
    }

    private void _logCurrentCase(byte currentCase) {
        this.log.trace("Current Case is {}", (Object)currentCase);
        String _e = this._currentEmbedded().toString();
        this.log.trace("    |---|    {}", (Object)this._currentWrap().toString());
        switch (currentCase) {
            case 1: {
                this.log.trace("|-|          {}", (Object)_e);
                break;
            }
            case 2: {
                this.log.trace("|---|        {}", (Object)_e);
                break;
            }
            case 3: {
                this.log.trace("  |---|      {}", (Object)_e);
                break;
            }
            case 4: {
                this.log.trace("  |-----|    {}", (Object)_e);
                break;
            }
            case 5: {
                this.log.trace("  |-------|  {}", (Object)_e);
                break;
            }
            case 6: {
                this.log.trace("    |-|      {}", (Object)_e);
                break;
            }
            case 7: {
                this.log.trace("    |---|    {}", (Object)_e);
                break;
            }
            case 8: {
                this.log.trace("    |-----|  {}", (Object)_e);
                break;
            }
            case 9: {
                this.log.trace("     |-|     {}", (Object)_e);
                break;
            }
            case 10: {
                this.log.trace("      |-|    {}", (Object)_e);
                break;
            }
            case 11: {
                this.log.trace("      |---|  {}", (Object)_e);
                break;
            }
            case 12: {
                this.log.trace("        |-|  {}", (Object)_e);
                break;
            }
            case 13: {
                this.log.trace("         |-| {}", (Object)_e);
                break;
            }
            case 15: {
                this.log.trace("      |---?  {}", (Object)_e);
                break;
            }
            case 16: {
                this.log.trace("  |---?      {}", (Object)_e);
            }
        }
    }

    private WithinSpan _currentWrap() {
        WithinSpan _wrap = new WithinSpan();
        _wrap.start = this.wrapStart != -1 ? this.wrapStart : this.wrapSpans.start();
        _wrap.end = this.wrapEnd != -1 ? this.wrapEnd : this.wrapSpans.end();
        _wrap.doc = this.wrapDoc != -1 ? this.wrapDoc : this.wrapSpans.doc();
        return _wrap;
    }

    private WithinSpan _currentEmbedded() {
        WithinSpan _embedded = new WithinSpan();
        _embedded.start = this.embeddedStart != -1 ? this.embeddedStart : this.embeddedSpans.start();
        _embedded.end = this.embeddedEnd != -1 ? this.embeddedEnd : this.embeddedSpans.end();
        _embedded.doc = this.embeddedDoc != -1 ? this.embeddedDoc : this.embeddedSpans.doc();
        return _embedded;
    }

    private void todo(byte currentCase) throws IOException {
        if (currentCase <= 2) {
            this.nextSpanB();
        } else if (currentCase >= 12) {
            this.storeEmbedded();
            this.nextSpanA();
        } else if (currentCase <= 5 || currentCase == 8) {
            if (this.flag <= 2) {
                this.storeEmbedded();
            }
            this.nextSpanB();
        } else if (currentCase == 11) {
            if (this.flag == 6) {
                this.nextSpanB();
            } else if (this.flag >= 10) {
                this.nextSpanA();
            } else {
                this.storeEmbedded();
                this.nextSpanB();
            }
        } else if (currentCase == 6 && this.flag == 12 || currentCase == 7 && this.flag == 6 || currentCase >= 9 && this.flag >= 10) {
            this.nextSpanA();
        } else {
            this.storeEmbedded();
            this.nextSpanB();
        }
    }

    private void storeEmbedded() throws IOException {
        WithinSpan embedded = new WithinSpan();
        embedded.start = this.embeddedStart != -1 ? this.embeddedStart : this.embeddedSpans.start();
        embedded.end = this.embeddedEnd != -1 ? this.embeddedEnd : this.embeddedSpans.end();
        embedded.doc = this.embeddedDoc;
        if (this.embeddedPayload != null) {
            embedded.payload = new ArrayList<byte[]>(this.embeddedPayload.size());
            embedded.payload.addAll(this.embeddedPayload);
        } else if (this.embeddedSpans.isPayloadAvailable()) {
            embedded.payload = new ArrayList<byte[]>(3);
            Collection<byte[]> payload = this.embeddedSpans.getPayload();
            this.embeddedPayload = new ArrayList<byte[]>(payload.size());
            this.embeddedPayload.addAll(payload);
            embedded.payload.addAll(payload);
        }
        this.spanStore1.add(embedded);
    }

    private byte withinCase() {
        if (this.wrapStart > this.embeddedStart) {
            if (this.wrapStart > this.embeddedEnd) {
                return 1;
            }
            if (this.wrapStart == this.embeddedEnd) {
                return 2;
            }
            this.wrapEnd = this.wrapSpans.end();
            if (this.wrapEnd > this.embeddedEnd) {
                return 3;
            }
            if (this.wrapEnd == this.embeddedEnd) {
                return 4;
            }
            return 5;
        }
        if (this.wrapStart == this.embeddedStart) {
            this.wrapEnd = this.wrapSpans.end();
            if (this.wrapEnd > this.embeddedEnd) {
                return 6;
            }
            if (this.wrapEnd == this.embeddedEnd) {
                return 7;
            }
            return 8;
        }
        this.wrapEnd = this.wrapSpans.end();
        if (this.wrapEnd < this.embeddedStart) {
            return 13;
        }
        if (this.wrapEnd > this.embeddedEnd) {
            return 9;
        }
        if (this.wrapEnd == this.embeddedEnd) {
            return 10;
        }
        if (this.wrapEnd > this.embeddedStart) {
            return 11;
        }
        return 12;
    }

    @Override
    public int doc() {
        return this.matchDoc;
    }

    @Override
    public int start() {
        return this.matchStart;
    }

    @Override
    public int end() {
        return this.matchEnd;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.matchPayload;
    }

    @Override
    public boolean isPayloadAvailable() {
        return !this.matchPayload.isEmpty();
    }

    @Override
    public long cost() {
        return this.wrapSpans.cost() + this.embeddedSpans.cost();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + (String)(this.embeddedDoc <= 0 ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    private class WithinSpan
    implements Comparable<WithinSpan>,
    Cloneable {
        public int start = -1;
        public int end = -1;
        public int doc = -1;
        public Collection<byte[]> payload;
        public short elementRef = (short)-1;

        private WithinSpan() {
        }

        public void clear() {
            this.start = -1;
            this.end = -1;
            this.doc = -1;
            this.clearPayload();
        }

        @Override
        public int compareTo(WithinSpan o) {
            if (this.doc < o.doc) {
                return -1;
            }
            if (this.doc == o.doc) {
                if (this.start < o.start) {
                    return -1;
                }
                if (this.start == o.start && this.end < o.end) {
                    return -1;
                }
            }
            return 1;
        }

        public short getElementRef() {
            return this.elementRef;
        }

        public void setElementRef(short elementRef) {
            this.elementRef = elementRef;
        }

        public Object clone() {
            WithinSpan span = new WithinSpan();
            span.start = this.start;
            span.end = this.end;
            span.doc = this.doc;
            span.payload.addAll(this.payload);
            return span;
        }

        public WithinSpan copyFrom(WithinSpan o) {
            this.start = o.start;
            this.end = o.end;
            this.doc = o.doc;
            this.payload.addAll(o.payload);
            return this;
        }

        public void clearPayload() {
            if (this.payload != null) {
                this.payload.clear();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            return sb.append(this.start).append('-').append(this.end).append('(').append(this.doc).append(')').append(']').toString();
        }
    }
}

