/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.ZeroOrOne;

public class LocalVariableReferenceCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        LocalVariableReference varRef = (LocalVariableReference)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LocalVariableReferenceCompiler.visitAnnotation(compiler, "LocalVariableReference-Item - " + varRef.getDisplayName());
        LocalVariableReferenceCompiler.visitLineNumber(compiler, ga, expression);
        int localSlot = varRef.getSlotNumber();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getStackFrame", new Class[0]);
        ga.invokeInstanceMethod(StackFrame.class, "getStackFrameValues", new Class[0]);
        ga.push(localSlot);
        ga.arrayLoad(Type.getType(Sequence.class));
        ga.invokeInstanceMethod(Sequence.class, "head", new Class[0]);
        LocalVariableReferenceCompiler.visitAnnotation(compiler, "LocalVariableReferenceCompiler, localSlotNumber: " + localSlot);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        LocalVariableReference varRef = (LocalVariableReference)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LocalVariableReferenceCompiler.visitAnnotation(compiler, "LocalVariableReference-Push - " + varRef.getDisplayName());
        LocalVariableReferenceCompiler.visitLineNumber(compiler, ga, expression);
        int localSlot = varRef.getSlotNumber();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getStackFrame", new Class[0]);
        ga.invokeInstanceMethod(StackFrame.class, "getStackFrameValues", new Class[0]);
        ga.push(localSlot);
        ga.arrayLoad(Type.getType(Sequence.class));
        LabelInfo notInstance = methodInfo.newLabel("notInstance");
        int actualVar = methodInfo.allocateLocal(Sequence.class);
        ga.storeLocal(actualVar);
        ga.loadLocal(actualVar);
        ga.instanceOf(Type.getType(NodeInfo.class));
        ga.ifZCmp(153, notInstance.label());
        ga.newInstance(Type.getType(ZeroOrOne.class));
        ga.dup();
        ga.loadLocal(actualVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeConstructor(ZeroOrOne.class, Item.class);
        ga.storeLocal(actualVar);
        methodInfo.placeLabel(notInstance);
        ga.loadLocal(actualVar);
        ga.checkClass(Sequence.class);
        compiler.generateGetContext();
        LocalVariableReferenceCompiler.allocateStatic(compiler, varRef.getLocation());
        ga.invokeStaticMethod(SequenceTool.class, "process", Sequence.class, XPathContext.class, Location.class);
        methodInfo.releaseLocal(actualVar);
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        LocalVariableReference varRef = (LocalVariableReference)expression;
        Generator ga = compiler.getCurrentGenerator();
        LocalVariableReferenceCompiler.visitAnnotation(compiler, "LocalVariableReference-Itr - " + varRef.getDisplayName());
        LocalVariableReferenceCompiler.visitLineNumber(compiler, ga, expression);
        int localSlot = varRef.getSlotNumber();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getStackFrame", new Class[0]);
        ga.invokeInstanceMethod(StackFrame.class, "getStackFrameValues", new Class[0]);
        ga.push(localSlot);
        ga.arrayLoad(Type.getType(Sequence.class));
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
    }
}

