/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.SimpleNodeConstructorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.ProcessingInstruction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ProcessingInstructionCompiler
extends SimpleNodeConstructorCompiler {
    @Override
    protected boolean isNamedNodeKind() {
        return true;
    }

    @Override
    protected void compileNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ProcessingInstruction procInstr = (ProcessingInstruction)expression;
        if (((ProcessingInstruction)expression).isXSLT()) {
            compiler.compileToPrimitive(procInstr.getNameExp(), String.class, OnEmpty.RETURN_EMPTY_STRING);
        } else {
            compiler.compileToItem(procInstr.getNameExp());
            ga.checkClass(AtomicValue.class);
            LabelInfo isString = methodInfo.newLabel("isString");
            LabelInfo isNotString = methodInfo.newLabel("isNotString");
            ga.dup();
            ga.ifNotInstance(StringValue.class, isNotString);
            ga.dup();
            ga.ifInstance(AnyURIValue.class, isNotString);
            ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
            ga.goTo(isString);
            methodInfo.placeLabel(isNotString);
            compiler.generateDynamicError("Processing instruction name is not an xs:string or xs:untypedAtomic", "XPTY0004", expression.getLocation(), true);
            methodInfo.placeLabel(isString);
        }
        ga.invokeStaticMethod(Whitespace.class, "trim", CharSequence.class);
        LabelInfo validNCName = methodInfo.newLabel("validNCName");
        LabelInfo notEqualXML = methodInfo.newLabel("PINotEqualXML");
        ga.dup();
        ga.invokeStaticMethod(NameChecker.class, "isValidNCName", CharSequence.class);
        ga.ifTrue(validNCName);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Invalid processing instruction name: {$1}", -1), ((ProcessingInstruction)expression).isXSLT() ? "XTDE0890" : "XQDY0041", expression.getLocation(), false);
        methodInfo.placeLabel(validNCName);
        ga.dup();
        ga.push("xml");
        ga.invokeInstanceMethod(String.class, "equalsIgnoreCase", String.class);
        ga.ifFalse(notEqualXML);
        ga.pop();
        String errorCode = ((ProcessingInstruction)expression).isXSLT() ? "XTDE0890" : "XQDY0064";
        compiler.generateDynamicError("Processing instructions cannot be named 'xml' in any combination of upper/lower case", errorCode, expression.getLocation(), false);
        methodInfo.placeLabel(notEqualXML);
    }

    @Override
    public void checkContent(CompilerService compiler, Expression expression) {
        ProcessingInstruction procInstr = (ProcessingInstruction)expression;
        Generator ga = compiler.getCurrentGenerator();
        ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        if (procInstr.isXSLT()) {
            ga.invokeStaticMethod(ProcessingInstruction.class, "checkContentXSLT", String.class);
        } else {
            ga.invokeStaticMethod(ProcessingInstruction.class, "checkContentXQuery", String.class);
        }
    }

    @Override
    protected void pushNode(CompilerService compiler, Expression expression) {
        Generator ga = compiler.getCurrentGenerator();
        ProcessingInstructionCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "processingInstruction", String.class, CharSequence.class, Location.class, Integer.TYPE);
    }
}

