/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.MonotonicIntSet;

public class MultiIndex<T extends Item<?>> {
    private GroundedValue<T> indexedValue;
    private List<ValueIndex> indexList = new ArrayList<ValueIndex>(4);

    public MultiIndex(GroundedValue<T> indexedValue) {
        this.indexedValue = indexedValue;
    }

    private ValueIndex buildIndex(Expression use, BuiltInAtomicType untypedType, PrimitiveTypeTester tester, XPathContext context, StringCollator collator) throws XPathException {
        HashMap<AtomicMatchKey, MonotonicIntSet> index = new HashMap<AtomicMatchKey, MonotonicIntSet>(100);
        ValueIndex vi = new ValueIndex(untypedType, index);
        IntHashSet typesPresent = new IntHashSet(4);
        XPathContextMajor c2 = context.newContext();
        FocusIterator iter = c2.trackFocus(this.indexedValue.iterate());
        ConversionRules rules = context.getConfiguration().getConversionRules();
        StringConverter untypedConverter = untypedType.getStringConverter(rules);
        int implicitTimezone = context.getImplicitTimezone();
        int pos = 0;
        while (iter.next() != null) {
            AtomicValue val;
            SequenceIterator<?> vals = use.iterate(c2);
            while ((val = (AtomicValue)vals.next()) != null) {
                AtomicMatchKey x;
                MonotonicIntSet list;
                boolean added;
                AtomicValue val2 = val;
                if (val instanceof UntypedAtomicValue) {
                    ConversionResult result = untypedConverter.convert((UntypedAtomicValue)val);
                    if (result instanceof ValidationFailure) {
                        String msg = "Failure converting untypedAtomic value to " + untypedType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        XPathException de = new XPathException(msg);
                        de.setErrorCode("FORG0001");
                        de.setXPathContext(context);
                        throw de;
                    }
                    val2 = (AtomicValue)result;
                }
                if (added = typesPresent.add(val2.getPrimitiveType().getFingerprint())) {
                    tester.test(val.getPrimitiveType());
                }
                if ((list = index.get(x = val2.getXPathComparable(false, collator, implicitTimezone))) == null) {
                    list = new MonotonicIntSet();
                    index.put(x, list);
                }
                list.add(pos);
            }
            ++pos;
        }
        vi.typesPresent = new IntArraySet(typesPresent);
        return vi;
    }

    private ValueIndex findIndex(BuiltInAtomicType soughtType) {
        for (int i = this.indexList.size() - 1; i >= 0; --i) {
            ValueIndex vi = this.indexList.get(i);
            if (!vi.untypedType.equals(soughtType)) continue;
            return vi;
        }
        return null;
    }

    public SequenceIterator<T> findItems(Expression use, SequenceIterator<? extends AtomicValue> values, boolean convertUntypedToOther, boolean firstOnly, StringCollator collator, XPathContext context) throws XPathException {
        IntIterator it;
        AtomicValue value;
        IntSet selectedItems = null;
        ConversionRules rules = context.getConfiguration().getConversionRules();
        int implicitTimezone = context.getImplicitTimezone();
        while ((value = values.next()) != null) {
            IntIterator it2;
            int type2;
            IntIterator ii;
            BuiltInAtomicType prim;
            if (convertUntypedToOther) {
                prim = value.getPrimitiveType();
                if (prim.equals(BuiltInAtomicType.INTEGER)) {
                    prim = BuiltInAtomicType.DECIMAL;
                }
            } else {
                prim = BuiltInAtomicType.STRING;
            }
            BuiltInAtomicType soughtType = value.getPrimitiveType();
            ValueIndex vi = this.findIndex(prim);
            if (vi == null) {
                PrimitiveTypeTester tester = convertUntypedToOther ? type -> {
                    if (type == BuiltInAtomicType.UNTYPED_ATOMIC || soughtType == BuiltInAtomicType.UNTYPED_ATOMIC) {
                        return;
                    }
                    if (!Type.isGuaranteedComparable(type, soughtType, false)) {
                        String message = "General comparison: cannot compare " + type + " to " + soughtType;
                        XPathException err = new XPathException(message);
                        err.setErrorCode("XPTY0004");
                        err.setIsTypeError(true);
                        throw err;
                    }
                } : type -> {
                    BuiltInAtomicType t1;
                    BuiltInAtomicType t0 = type;
                    if (t0 == BuiltInAtomicType.UNTYPED_ATOMIC) {
                        t0 = BuiltInAtomicType.STRING;
                    }
                    if ((t1 = soughtType) == BuiltInAtomicType.UNTYPED_ATOMIC) {
                        t1 = BuiltInAtomicType.STRING;
                    }
                    if (!Type.isGuaranteedComparable(t0, t1, false)) {
                        String message = "Value comparison: cannot compare " + type + " to " + soughtType;
                        XPathException err = new XPathException(message);
                        err.setErrorCode("XPTY0004");
                        err.setIsTypeError(true);
                        throw err;
                    }
                };
                vi = this.buildIndex(use, prim, tester, context, collator);
                this.indexList.add(vi);
            } else if (soughtType != BuiltInAtomicType.UNTYPED_ATOMIC && !vi.typesChecked.contains(soughtType.getFingerprint())) {
                ii = vi.typesPresent.iterator();
                while (ii.hasNext()) {
                    type2 = ii.next();
                    BuiltInAtomicType indexedType = (BuiltInAtomicType)BuiltInType.getSchemaType(type2);
                    if (Type.isGuaranteedComparable(soughtType, indexedType, false)) continue;
                    String message = "Cannot compare " + indexedType + " to " + soughtType;
                    XPathException err = new XPathException(message);
                    err.setErrorCode("XPTY0004");
                    err.setIsTypeError(true);
                    throw err;
                }
                vi.typesChecked.add(soughtType.getFingerprint());
            }
            if (prim.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                ii = vi.typesPresent.iterator();
                while (ii.hasNext()) {
                    type2 = ii.next();
                    BuiltInAtomicType requiredType = (BuiltInAtomicType)BuiltInType.getSchemaType(type2);
                    AtomicValue result = Converter.convert(value, requiredType, rules);
                    if (result instanceof ValidationFailure) {
                        String msg = "Failure converting untypedAtomic value to " + requiredType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)((Object)result)).getMessage();
                        XPathException de = new XPathException(msg);
                        de.setErrorCode("FORG0001");
                        de.setXPathContext(context);
                        throw de;
                    }
                    AtomicValue conv = result;
                    IntSet list = vi.index.get(conv.getXPathComparable(false, collator, implicitTimezone));
                    if (list == null) continue;
                    if (selectedItems == null) {
                        selectedItems = list.copy();
                        continue;
                    }
                    selectedItems = selectedItems.union(list);
                }
            } else {
                IntSet list = vi.index.get(value.getXPathComparable(false, collator, implicitTimezone));
                if (list != null) {
                    selectedItems = selectedItems == null ? list.copy() : selectedItems.union(list);
                }
            }
            if (!firstOnly || selectedItems == null || selectedItems.isEmpty() || !(it2 = selectedItems.iterator()).hasNext()) continue;
            return this.singletonIterator(it2.next());
        }
        if (selectedItems == null) {
            return EmptyIterator.emptyIterator();
        }
        int size = selectedItems.size();
        if (size == 0) {
            return EmptyIterator.emptyIterator();
        }
        if (size == 1 && (it = selectedItems.iterator()).hasNext()) {
            return this.singletonIterator(it.next());
        }
        return new SelectedItemsIterator<T>(this.indexedValue, selectedItems);
    }

    private UnfailingIterator<T> singletonIterator(int pos) throws XPathException {
        T item;
        T gv = item = SequenceTool.itemAt(this.indexedValue, pos);
        return gv.iterate();
    }

    private static interface PrimitiveTypeTester {
        public void test(BuiltInAtomicType var1) throws XPathException;
    }

    private static class ValueIndex {
        public BuiltInAtomicType untypedType;
        public IntSet typesPresent;
        public IntSet typesChecked;
        public HashMap<AtomicMatchKey, MonotonicIntSet> index;

        public ValueIndex(BuiltInAtomicType untypedType, HashMap<AtomicMatchKey, MonotonicIntSet> index) {
            this.untypedType = untypedType;
            this.typesPresent = new IntArraySet();
            this.typesChecked = new IntArraySet();
            this.index = index;
        }
    }

    public static class SelectedItemsIterator<T extends Item<?>>
    implements SequenceIterator<T>,
    LastPositionFinder,
    LookaheadIterator<T> {
        IntSet selection;
        IntIterator iter;
        int current = 0;
        GroundedValue<T> indexedValue;

        public SelectedItemsIterator(GroundedValue<T> indexedValue, IntSet selection) {
            this.indexedValue = indexedValue;
            this.selection = selection;
            this.iter = selection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() throws XPathException {
            if (this.iter.hasNext()) {
                this.current = this.iter.next();
                return SequenceTool.itemAt(this.indexedValue, this.current);
            }
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public int getLength() throws XPathException {
            return this.selection.size();
        }

        @Override
        public int getProperties() {
            return 6;
        }
    }
}

