/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.s9api;

import com.saxonica.ee.validate.StatisticsReporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ValidationStatisticsRecipient;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;

public class ValidationStatistics {
    private final List<Map<SchemaComponent, Integer>> collectedStats = new ArrayList<Map<SchemaComponent, Integer>>();
    protected ValidationStatisticsRecipient recipient = new ValidationStatisticsRecipient(){

        @Override
        public void notifyValidationStatistics(Map<SchemaComponent, Integer> statistics) throws XPathException {
            ValidationStatistics.this.collectedStats.add(statistics);
        }
    };

    public void report(Processor processor, Destination destination) throws SaxonApiException {
        try {
            if (this.collectedStats.size() > 0) {
                Configuration config = processor.getUnderlyingConfiguration();
                Receiver receiver = destination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
                StatisticsReporter reporter = new StatisticsReporter();
                reporter.setReceiver(receiver);
                reporter.notifyValidationStatistics(this.collectedStats.get(this.collectedStats.size() - 1));
            }
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

