/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.ReplaceValueAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class ReplaceValueExpression
extends BasicUpdatingExpression {
    private Operand targetOp;
    private Operand replacementOp;

    public ReplaceValueExpression(Expression target, Expression replacement) {
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.replacementOp = new Operand(this, replacement, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getReplacementExp() {
        return this.replacementOp.getChildExpression();
    }

    public void setReplacementExp(Expression replacement) {
        this.replacementOp.setChildExpression(replacement);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.replacementOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression result1 = this.getReplacementExp();
        this.setReplacementExp(XQueryParser.stringify(result1, true, visitor.getStaticContext()));
        Expression result = this.getReplacementExp();
        this.setReplacementExp(new ValueOf(result, false, true));
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
        role0.setErrorCode("XUDY0027");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, role0, visitor));
        role0 = new RoleDiagnostic(10, "replace", 0);
        role0.setErrorCode("XUTY0008");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, role0, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression result = this.getReplacementExp();
        ReplaceValueExpression exp = new ReplaceValueExpression(this.getTargetExp().copy(rebindings), result.copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("replaceValue", this);
        this.getTargetExp().export(out);
        Expression result = this.getReplacementExp();
        result.export(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Expression result = this.getReplacementExp();
        Item<?> newText = result.evaluateItem(context);
        String newString = newText == null ? "" : newText.getStringValue();
        NodeInfo targetNode = (NodeInfo)this.getTargetExp().evaluateItem(context);
        XPathException err = null;
        switch (targetNode.getNodeKind()) {
            case 8: {
                if (newString.contains("--")) {
                    err = new XPathException("Replacement comment value cannot contain two adjacent hyphens", "XQDY0072");
                    break;
                }
                if (!newString.endsWith("-")) break;
                err = new XPathException("Replacement comment value cannot end with a hyphen", "XQDY0072");
                break;
            }
            case 7: {
                if (!newString.contains("?>")) break;
                err = new XPathException("Replacement processing instruction value cannot contain '?>'", "XQDY0026");
                break;
            }
            case 9: {
                err = new XPathException("Cannot replace the value of a document node", "XUTY0008");
                break;
            }
            case 13: {
                err = new XPathException("Cannot replace the value of a namespace node", "XUTY0008");
                break;
            }
        }
        if (err != null) {
            err.setLocation(this.getLocation());
            err.setXPathContext(context);
            throw err;
        }
        if (!(targetNode instanceof MutableNodeInfo)) {
            XPathException er = new XPathException("Target node of replace expression is not updateable", "SXUP0081");
            er.setLocation(this.getLocation());
            throw er;
        }
        try {
            ReplaceValueAction action = new ReplaceValueAction(newString, (MutableNodeInfo)targetNode);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    public String getExpressionName() {
        return "replaceValue";
    }
}

