/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.InsertExpression;
import com.saxonica.ee.xtupdate.SaxonUpdate;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonInsert
extends StyleElement {
    private Expression select;
    private String positionAtt;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        Object contentAtt = null;
        AttributeCollection atts = this.getAttributeList();
        block8: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "select": {
                    selectAtt = atts.getValue(a);
                    this.select = this.makeExpression(selectAtt, a);
                    continue block8;
                }
                case "position": {
                    String val = Whitespace.trim(atts.getValue(a));
                    if (!(val.equals("after") || val.equals("before") || val.equals("first") || val.equals("last"))) {
                        this.invalidAttribute("position", "after|before|first|last");
                    }
                    this.positionAtt = val;
                    continue block8;
                }
                default: {
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
        if (this.positionAtt == null) {
            this.positionAtt = "last";
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:insert", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
        SaxonUpdate.checkContainment(this);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, false);
        int pos = this.interpretPosition(this.positionAtt);
        return new InsertExpression(content, this.select, pos, 3, true, true);
    }

    private int interpretPosition(String p) {
        switch (p) {
            case "first": {
                return 116;
            }
            case "last": {
                return 117;
            }
            case "before": {
                return 119;
            }
            case "after": {
                return 118;
            }
        }
        return -1;
    }
}

