/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import marmot.core.FloatFeatureVector;
import marmot.core.FloatWeights;

public class ArrayFloatFeatureVector
implements FloatFeatureVector {
    private static final long serialVersionUID = 1L;
    private int[] features_;
    private double[] weights_;
    private int dim_;

    public ArrayFloatFeatureVector(int[] features, double[] weights, int dim) {
        this.features_ = features;
        this.weights_ = weights;
        this.dim_ = dim;
    }

    @Override
    public int getDim() {
        return this.dim_;
    }

    public void setDim(int dim) {
        this.dim_ = dim;
    }

    @Override
    public void updateFloatWeight(FloatWeights weights, int tag_index, int offset, double value) {
        for (int i = 0; i < this.features_.length; ++i) {
            int feature = this.features_[i];
            if (feature < 0) continue;
            double weight = this.weights_[i];
            int f_index = weights.getFloatIndex(feature + offset, tag_index);
            weights.updateFloatWeight(f_index, weight * value);
        }
    }

    @Override
    public double getDotProduct(FloatWeights weights, int tag_index, int offset) {
        double score = 0.0;
        for (int i = 0; i < this.features_.length; ++i) {
            int feature = this.features_[i];
            if (feature < 0) continue;
            double weight = this.weights_[i];
            int f_index = weights.getFloatIndex(feature + offset, tag_index);
            score += weight * weights.getFloatWeight(f_index);
        }
        return score;
    }

    public double[] getWeights() {
        return this.weights_;
    }

    public int[] getFeatures() {
        return this.features_;
    }
}

