/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class SaxonPreprocess
extends AnnotationParent {
    private Assertion action = null;
    private Assertion reverseAction = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        XPathExpression expression;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"action", "id", "reverse", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNamespace = atts.getValue("", "xpathDefaultNamespace");
        if (defaultNamespace == null) {
            defaultNamespace = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNamespace.equals("##defaultNamespace")) {
            defaultNamespace = this.getURIForPrefix("", true);
        } else if (defaultNamespace.equals("##targetNamespace")) {
            defaultNamespace = this.getXSDSchema().getTargetNamespace();
        } else if (defaultNamespace.equals("##local")) {
            defaultNamespace = "";
        }
        String xpath = atts.getValue("", "action");
        if (xpath == null) {
            this.missingAttribute("action");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this, this.getConfiguration());
        env.setDefaultElementNamespace(defaultNamespace);
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        XPathVariable valueVariable = env.declareVariable("", "value");
        XPathEvaluator xpe = new XPathEvaluator(this.getSchema().getConfiguration());
        try {
            xpe.setStaticContext(env);
            expression = xpe.createExpression(xpath);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            try {
                expression = xpe.createExpression("'*error*'");
            }
            catch (XPathException e2) {
                throw new AssertionError((Object)e2.getMessage());
            }
        }
        this.action = new Assertion(this.getSchema().getConfiguration(), expression, valueVariable, null, xpath);
        this.action.setStaticContext(env);
        xpath = atts.getValue("", "reverse");
        if (xpath != null) {
            try {
                expression = xpe.createExpression(xpath);
            }
            catch (XPathException err) {
                this.error(err.getMessage());
                try {
                    expression = xpe.createExpression("'*error*'");
                }
                catch (XPathException e2) {
                    throw new AssertionError((Object)e2.getMessage());
                }
            }
            this.reverseAction = new Assertion(this.getSchema().getConfiguration(), expression, valueVariable, null, xpath);
            this.reverseAction.setStaticContext(env);
        }
        this.processId();
    }

    public Assertion getAction() {
        return this.action;
    }

    public Assertion getReverseAction() {
        return this.reverseAction;
    }
}

