/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class MotionlessFeed
extends ItemFeed {
    private Expression expression;
    private boolean selected;

    public MotionlessFeed(Expression expression, Feed result, XPathContext context) {
        super(expression, result, context);
        this.expression = expression;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        Object item;
        SequenceIterator<?> iter = this.expression.iterate(this.getContext());
        while ((item = iter.next()) != null) {
            if (item instanceof FleetingParentNode) {
                this.selected = true;
                return this.getResult().startSelectedParentNode((FleetingParentNode)item, locationId);
            }
            this.getResult().processItem((Item<?>)item);
        }
        return null;
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        SequenceIterator<?> iter = this.expression.iterate(this.getContext());
        MotionlessFeed.processItems(iter, this.getResult());
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.selected) {
            this.getResult().endSelectedParentNode(locationId);
            this.selected = false;
        }
    }
}

