/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.FixedAttributeCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ComputedAttributeCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Expression select = ((ComputedAttribute)expression).getSelect();
        ComputedAttributeCompiler.visitAnnotation(compiler, "ComputedAttributeCompiler - push");
        ComputedAttributeCompiler.visitLineNumber(compiler, ga, expression);
        int opt = ((ComputedAttribute)expression).getOptions();
        Location locationId = expression.getLocation();
        LabelInfo notEqual = methodInfo.newLabel("notEqual");
        LabelInfo done = null;
        compiler.generateGetReceiver();
        this.pushNodeName(compiler, expression);
        int nodeNameVar = ga.newLocal(NodeName.class);
        ga.storeLocal(nodeNameVar);
        ga.loadLocal(nodeNameVar);
        SimpleType schemaType = ((ComputedAttribute)expression).getSchemaType();
        if (schemaType != null) {
            ComputedAttributeCompiler.allocateStatic(compiler, schemaType);
        } else {
            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
        }
        compiler.compileToPrimitive(select, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        FixedAttributeCompiler.generateAttributeValidationPushCode(compiler, (ComputedAttribute)expression, null, nodeNameVar);
        ga.loadLocal(nodeNameVar);
        ga.invokeInstanceMethod(NodeName.class, "getFingerprint", new Class[0]);
        ga.push(388);
        ga.ifICmp(154, notEqual.label());
        ga.invokeStaticMethod(Whitespace.class, "collapseWhitespace", CharSequence.class);
        methodInfo.placeLabel(notEqual);
        ComputedAttributeCompiler.allocateStatic(compiler, locationId);
        ga.push(opt);
        ga.invokeInstanceMethod(Receiver.class, "attribute", NodeName.class, SimpleType.class, CharSequence.class, Location.class, Integer.TYPE);
        if (done != null) {
            methodInfo.placeLabel(done);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ComputedAttributeCompiler.visitAnnotation(compiler, "ComputedAttributeCompiler - item");
        ComputedAttribute instr = (ComputedAttribute)expression;
        Expression select = instr.getSelect();
        compiler.compileToPrimitive(select, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        int contentVar = methodInfo.allocateLocal(CharSequence.class);
        ga.storeLocal(contentVar);
        LabelInfo done = null;
        ga.newInstance(Type.getType(Orphan.class));
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
        ga.invokeConstructor(Orphan.class, Configuration.class);
        int oVar = methodInfo.allocateLocal(Orphan.class);
        ga.storeLocal(oVar);
        ga.loadLocal(oVar);
        ga.push(2);
        ga.invokeInstanceMethod(Orphan.class, "setNodeKind", Short.TYPE);
        ga.loadLocal(oVar);
        ga.loadLocal(contentVar);
        ga.invokeInstanceMethod(Orphan.class, "setStringValue", CharSequence.class);
        ga.loadLocal(oVar);
        this.pushNodeName(compiler, expression);
        ga.invokeInstanceMethod(Orphan.class, "setNodeName", NodeName.class);
        ga.loadLocal(oVar);
        FixedAttributeCompiler.validateOrphanAttribute(compiler, instr);
        if (done != null) {
            methodInfo.placeLabel(done);
        }
        methodInfo.releaseLocal(contentVar);
        methodInfo.releaseLocal(oVar);
    }

    private void pushNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        ComputedAttribute compAttr = (ComputedAttribute)expression;
        Expression nameExpr = compAttr.getNameExp();
        Expression namespace = compAttr.getNamespaceExp();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo notNull2 = methodInfo.newLabel("notNull2");
        LabelInfo notNull3 = methodInfo.newLabel("notNull3");
        LabelInfo uriNotNull = methodInfo.newLabel("uriNotNull");
        LabelInfo notStrInstance = methodInfo.newLabel("notStrInstance");
        LabelInfo notQNameInstance = methodInfo.newLabel("notQNameInstance");
        LabelInfo end = methodInfo.newLabel("endCompAttr");
        LabelInfo doneAtt = methodInfo.newLabel("doneAtt");
        LabelInfo done1 = methodInfo.newLabel("done1");
        LabelInfo qnameOK = methodInfo.newLabel("qnameOK");
        LabelInfo uriGTZero = methodInfo.newLabel("uriGTZero");
        LabelInfo prefixOK = methodInfo.newLabel("prefixOK");
        LabelInfo test1 = methodInfo.newLabel("test1");
        LabelInfo test2 = methodInfo.newLabel("test2");
        LabelInfo notEqual = methodInfo.newLabel("notEqual");
        LabelInfo notEqual2 = methodInfo.newLabel("notEqual2");
        LabelInfo notEqual_rawName = methodInfo.newLabel("notEqual_rawName");
        LabelInfo notEqual_prefix = methodInfo.newLabel("notEqual_prefix");
        int localNameVar = methodInfo.allocateLocal(String.class);
        int uriVar = methodInfo.allocateLocal(String.class);
        ga.pushNull();
        ga.storeLocal(uriVar);
        int prefixVar = methodInfo.allocateLocal(String.class);
        ga.pushNull();
        ga.storeLocal(prefixVar);
        compiler.compileToItem(nameExpr);
        ga.dup();
        ga.ifNotInstance(StringValue.class, notStrInstance);
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        ga.invokeStaticMethod(Whitespace.class, "trimWhitespace", CharSequence.class);
        int rawNameVar = methodInfo.allocateLocal(String.class);
        ga.storeLocal(rawNameVar);
        ga.loadLocal(rawNameVar);
        if (namespace == null) {
            ga.dup();
            ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
            ga.push("xmlns");
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifFalse(notEqual_rawName);
            ga.pop();
            compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Invalid attribute name: {$1}", rawNameVar), compAttr.isXSLT() ? "XTDE0855" : "XQDY0044", compAttr.getLocation(), false);
            ga.goTo(end);
            methodInfo.placeLabel(notEqual_rawName);
        }
        LabelInfo tryBegin = methodInfo.newLabel("tryBegin");
        LabelInfo tryEnd = methodInfo.newLabel("tryEnd");
        LabelInfo catchBegin = methodInfo.newLabel("catchBegin");
        ga.visitTryCatchBlock(tryBegin, tryEnd, catchBegin, "net/sf/saxon/om/QNameException");
        methodInfo.placeLabel(tryBegin);
        ga.invokeStaticMethod(NameChecker.class, "getQNameParts", CharSequence.class);
        methodInfo.placeLabel(tryEnd);
        ga.dup();
        ga.push(0);
        ga.arrayLoad(Type.getType(String.class));
        ga.storeLocal(prefixVar);
        ga.push(1);
        ga.arrayLoad(Type.getType(String.class));
        ga.storeLocal(localNameVar);
        ga.loadLocal(prefixVar);
        ga.push("xmlns");
        ga.invokeInstanceMethod(String.class, "equals", Object.class);
        ga.ifFalse(notEqual_prefix);
        if (namespace == null) {
            compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Invalid attribute name: {$1}", rawNameVar), compAttr.isXSLT() ? "XTDE0860" : "XQDY0044", compAttr.getLocation(), false);
            ga.goTo(end);
        } else {
            ga.push("");
            ga.storeLocal(prefixVar);
        }
        methodInfo.placeLabel(notEqual_prefix);
        ga.goTo(test1);
        methodInfo.placeLabel(catchBegin);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Invalid attribute name: {$1}", rawNameVar), compAttr.isXSLT() ? "XTDE0850" : "XQDY0074", compAttr.getLocation(), false);
        methodInfo.placeLabel(notStrInstance);
        if (compAttr.isAllowNameAsQName()) {
            ga.dup();
            ga.ifNotInstance(QNameValue.class, notQNameInstance);
            ga.checkCast(Type.getType(QNameValue.class));
            ga.dup();
            ga.invokeInstanceMethod(QNameValue.class, "getLocalName", new Class[0]);
            ga.storeLocal(localNameVar);
            ga.dup();
            ga.invokeInstanceMethod(QNameValue.class, "getNamespaceURI", new Class[0]);
            ga.storeLocal(uriVar);
            ga.loadLocal(uriVar);
            ga.ifNonNull(notNull2.label());
            ga.push("");
            ga.storeLocal(uriVar);
            methodInfo.placeLabel(notNull2);
            ga.loadLocal(localNameVar);
            ga.push("xmlns");
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifFalse(qnameOK);
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifICmp(154, qnameOK.label());
            compiler.generateDynamicError("Invalid attribute name: xmlns", "XQDY0044", compAttr.getLocation(), false);
            ga.goTo(end);
            methodInfo.placeLabel(qnameOK);
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifICmp(154, uriGTZero.label());
            ga.pop();
            ga.push("");
            ga.storeLocal(prefixVar);
            ga.goTo(test2);
            methodInfo.placeLabel(uriGTZero);
            ga.checkCast(Type.getType(QNameValue.class));
            ga.invokeInstanceMethod(QNameValue.class, "getPrefix", new Class[0]);
            ga.storeLocal(prefixVar);
            ga.loadLocal(prefixVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifICmp(154, prefixOK.label());
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getNamePool", new Class[0]);
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(NamePool.class, "suggestPrefixForURI", String.class);
            ga.storeLocal(prefixVar);
            ga.loadLocal(prefixVar);
            ga.ifNonNull(prefixOK.label());
            ga.push("ns0");
            ga.storeLocal(prefixVar);
            methodInfo.placeLabel(prefixOK);
            ga.loadLocal(uriVar);
            ga.push("http://www.w3.org/XML/1998/namespace");
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.push("xml");
            ga.loadLocal(prefixVar);
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifCmp(Type.getType(Boolean.TYPE), 153, test2.label());
            ga.loadLocal(prefixVar);
            ga.loadLocal(uriVar);
            ga.push(compAttr.isXSLT());
            ga.push(compAttr.getLocation().getSystemId());
            ga.push(compAttr.getLocation().getLineNumber());
            ga.invokeStaticMethod(Callback.class, "makeXmlNamespaceException", String.class, String.class, Boolean.TYPE, String.class, Integer.TYPE);
            ga.throwException();
            methodInfo.placeLabel(test2);
            ga.push("xmlns");
            ga.loadLocal(prefixVar);
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifFalse(test1);
            compiler.generateDynamicError("Invalid attribute namespace: http://www.w3.org/2000/xmlns/", "XQDY0044", compAttr.getLocation(), false);
            ga.goTo(doneAtt);
            methodInfo.placeLabel(notQNameInstance);
            compiler.generateDynamicError("Attribute name must be either a string or a QName", "XQDY0004", compAttr.getLocation(), false);
            ga.goTo(end);
        } else {
            compiler.generateDynamicError("Attribute name must be either a string or a QName", "XQDY0004", compAttr.getLocation(), false);
            ga.goTo(end);
        }
        methodInfo.placeLabel(test1);
        if (namespace == null) {
            ga.loadLocal(uriVar);
            ga.ifNonNull(uriNotNull.label());
            ga.loadLocal(prefixVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifICmp(154, notEqual.label());
            ga.push("");
            ga.storeLocal(uriVar);
            methodInfo.placeLabel(notEqual);
            ExpressionCompiler.allocateStatic(compiler, compAttr.getNamespaceResolver());
            ga.loadLocal(prefixVar);
            ga.push(false);
            ga.invokeInstanceMethod(NamespaceResolver.class, "getURIForPrefix", String.class, Boolean.TYPE);
            ga.dup();
            ga.ifNonNull(notNull3.label());
            ga.pop();
            compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Undeclared prefix in attribute name: {$1}", prefixVar), compAttr.isXSLT() ? "XTDE0860" : "XQDY0074", compAttr.getLocation(), false);
            ga.goTo(end);
            methodInfo.placeLabel(notNull3);
            ga.storeLocal(uriVar);
            methodInfo.placeLabel(uriNotNull);
        } else {
            ga.loadLocal(uriVar);
            ga.ifNonNull(uriNotNull.label());
            if (namespace instanceof StringLiteral) {
                ga.push(((StringLiteral)namespace).getStringValue());
                ga.storeLocal(uriVar);
            } else {
                compiler.compileToPrimitive(namespace, String.class, OnEmpty.RETURN_NULL);
                ga.storeLocal(uriVar);
                ga.invokeStaticMethod(StandardURIChecker.class, "getInstance", new Class[0]);
                ga.loadLocal(uriVar);
                ga.invokeInstanceMethod(StandardURIChecker.class, "isValidURI", CharSequence.class);
                ga.ifTrue(uriNotNull);
                compiler.generateDynamicError("The value of the namespace attribute must be a valid URI", "XTDE0865", compAttr.getLocation(), false);
                ga.goTo(end);
            }
            methodInfo.placeLabel(uriNotNull);
            ga.loadLocal(uriVar);
            ga.checkCast(Type.getType(String.class));
            ga.storeLocal(uriVar);
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifCmp(Type.getType(Integer.TYPE), 154, notEqual2.label());
            ga.push("");
            ga.storeLocal(prefixVar);
            ga.goTo(doneAtt);
            methodInfo.placeLabel(notEqual2);
            ga.loadLocal(prefixVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.ifZCmp(154, doneAtt.label());
            ComputedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration().getNamePool());
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(NamePool.class, "suggestPrefixForURI", String.class);
            ga.storeLocal(prefixVar);
            ga.loadLocal(prefixVar);
            ga.ifNonNull(doneAtt.label());
            ga.push("ns0");
            ga.storeLocal(prefixVar);
        }
        methodInfo.placeLabel(doneAtt);
        ga.loadLocal(uriVar);
        ga.push("http://www.w3.org/2000/xmlns/");
        ga.invokeInstanceMethod(String.class, "equals", Object.class);
        ga.ifFalse(done1);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Cannot create attribute in namespace {$1}", uriVar), compAttr.isXSLT() ? "XTDE0865" : "XQDY0044", compAttr.getLocation(), false);
        ga.goTo(end);
        methodInfo.placeLabel(done1);
        ga.newInstance(FingerprintedQName.class);
        ga.dup();
        ga.loadLocal(prefixVar);
        ga.loadLocal(uriVar);
        ga.loadLocal(localNameVar);
        ga.invokeConstructor(FingerprintedQName.class, String.class, String.class, String.class);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(localNameVar);
        methodInfo.releaseLocal(uriVar);
        methodInfo.releaseLocal(prefixVar);
        methodInfo.releaseLocal(rawNameVar);
    }
}

