/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.NextIteration;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class NextIterationFeed
extends ItemFeed {
    private int streamedArgument;
    private List<Item<?>> inputValue = new ArrayList(4);
    Sequence[] newValues;

    public NextIterationFeed(Expression inst, Feed result, XPathContext context, int arg) throws XPathException {
        super(inst, result, context);
        WithParam[] actualParams = ((NextIteration)this.getExpression()).getParameters();
        this.newValues = SequenceTool.makeSequenceArray(actualParams.length);
        this.streamedArgument = arg;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.getResult().open(terminator);
        WithParam[] actualParams = ((NextIteration)this.getExpression()).getParameters();
        XPathContext context = this.getContext();
        if (actualParams.length > 1) {
            for (int i = 0; i < actualParams.length; ++i) {
                if (i == this.streamedArgument) continue;
                WithParam wp = actualParams[i];
                this.newValues[i] = wp.getSelectValue(context);
            }
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.inputValue.add(item);
    }

    @Override
    public void close() throws XPathException {
        WithParam[] actualParams = ((NextIteration)this.getExpression()).getParameters();
        WithParam wp = actualParams[this.streamedArgument];
        XPathContext context = this.getContext();
        context.setLocalVariable(wp.getSlotNumber(), SequenceExtent.makeSequenceExtent(this.inputValue));
        for (int i = 0; i < actualParams.length; ++i) {
            if (i == this.streamedArgument) continue;
            wp = actualParams[i];
            context.setLocalVariable(wp.getSlotNumber(), this.newValues[i]);
        }
        this.getResult().close();
    }
}

