/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.AnnotationToolBridgeFactory;
import de.ids_mannheim.korapxmltools.AnnotationWorkerPool;
import de.ids_mannheim.korapxmltools.ColoredFormatter;
import de.ids_mannheim.korapxmltools.KorapXmlToolKt;
import de.ids_mannheim.korapxmltools.NonBmpString;
import de.ids_mannheim.korapxmltools.OutputFormat;
import de.ids_mannheim.korapxmltools.ParserToolBridge;
import de.ids_mannheim.korapxmltools.TaggerToolBridge;
import de.ids_mannheim.korapxmltools.XMLCommentFilterReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import picocli.CommandLine;

@CommandLine.Command(name="KorapXmlTool", version={"KorapXmlTool 2.01"}, mixinStandardHelpOptions=true, description={"Converts KorAP-XML <https://github.com/KorAP/KorAP-XML-Krill#about-korap-xml> base or morpho zips to (annotated) CoNLL(-U) format with all information necessary for reconstruction in comment lines."})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u00ff\u0001\u0080\u0002\u0081\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0007J\u000e\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020\u0002J\u0010\u0010h\u001a\u0002022\u0006\u0010i\u001a\u00020\u0011H\u0007J\u0010\u0010l\u001a\u0002022\u0006\u0010m\u001a\u00020\u0011H\u0007J\r\u0010n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010SJ\u000b\u0010\u00b4\u0001\u001a\u00020\u0006*\u00020\u0011J\r\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u0011*\u00020\u0011J\u001b\u0010\u00b6\u0001\u001a\u0002022\r\u0010\u00b7\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0015J0\u0010\u00b8\u0001\u001a\u0002022\r\u0010\u00b9\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00bb\u0001\u001a\u00020\u0002H\u0002\u00a2\u0006\u0003\u0010\u00bc\u0001J\u0013\u0010\u00bd\u0001\u001a\u00030\u00be\u00012\u0007\u0010\u00bf\u0001\u001a\u00020\u0011H\u0002J+\u0010\u00c0\u0001\u001a\b\u0012\u0004\u0012\u00020{0\u00102\u0014\u0010\u007f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u0001H\u0002\u00a2\u0006\u0003\u0010\u00c1\u0001J\u0012\u0010\u00c2\u0001\u001a\u00020\u00112\u0007\u0010\u00c3\u0001\u001a\u00020\u0011H\u0002J\u001d\u0010\u00c4\u0001\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0003\u0010\u00c5\u0001J\u001d\u0010\u00c6\u0001\u001a\u0002022\u0007\u0010\u00c7\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ba\u0001\u001a\u00020\u0011H\u0002J\u001d\u0010\u00c8\u0001\u001a\u0002022\u0007\u0010\u00c7\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ba\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u00c9\u0001\u001a\u0002022\u0007\u0010\u00c7\u0001\u001a\u00020\u0011H\u0002J\u0013\u0010\u00ca\u0001\u001a\u00020\u00112\b\u0010\u00cb\u0001\u001a\u00030\u0093\u0001H\u0002J\u0013\u0010\u00cc\u0001\u001a\u00020\u00112\b\u0010\u00cd\u0001\u001a\u00030\u0093\u0001H\u0002J%\u0010\u00ce\u0001\u001a\u0002022\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00d1\u0001\u001a\u00020\u0006H\u0002J-\u0010\u00d2\u0001\u001a\u0002022\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u00012\u0007\u0010\u00d3\u0001\u001a\u00020\u00112\b\u0010\u00d4\u0001\u001a\u00030\u00d5\u00012\u0007\u0010\u00d6\u0001\u001a\u00020\u0006J\u001b\u0010\u00d7\u0001\u001a\u0002022\u0007\u0010\u00d8\u0001\u001a\u00020\u00112\u0007\u0010\u00ba\u0001\u001a\u00020\u0011H\u0002J\t\u0010\u00d9\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u00da\u0001\u001a\u0002022\u0007\u0010\u00db\u0001\u001a\u00020\u0002H\u0002J!\u0010\u00dc\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00df\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00e0\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00e1\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00112\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J\u0018\u0010\u00e2\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J\u0018\u0010\u00e3\u0001\u001a\b0\u00dd\u0001j\u0003`\u00de\u00012\u0007\u0010\u00d8\u0001\u001a\u00020\u0011H\u0002J}\u0010\u00e4\u0001\u001a\u00020\u00112\u0007\u0010\u00e5\u0001\u001a\u00020\u00022\u0007\u0010\u00e6\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00e7\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00e8\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00e9\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ea\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00eb\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ec\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ed\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ee\u0001\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u0002H\u0002JX\u0010\u00ef\u0001\u001a\u00020\u00112\u0018\u0010z\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020{0\u00100v2\u0007\u0010\u00d8\u0001\u001a\u00020\u00112\u0007\u0010\u00f0\u0001\u001a\u00020\u00022\u0007\u0010\u00e5\u0001\u001a\u00020\u00022\u0018\u0010}\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020{0\u00100vH\u0002J\u001f\u0010\u00f1\u0001\u001a\b\u0012\u0004\u0012\u00020{0\u00102\b\u0010\u00f2\u0001\u001a\u00030\u00f3\u0001H\u0002\u00a2\u0006\u0003\u0010\u00f4\u0001J!\u0010\u00f5\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00012\b\u0010\u00f6\u0001\u001a\u00030\u00f3\u0001H\u0002J!\u0010\u00f7\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00012\b\u0010\u00f8\u0001\u001a\u00030\u00f3\u0001H\u0002J\u001f\u0010\u00f9\u0001\u001a\b\u0012\u0004\u0012\u00020{0\u00102\b\u0010\u00f2\u0001\u001a\u00030\u00f3\u0001H\u0002\u00a2\u0006\u0003\u0010\u00f4\u0001J \u0010\u00fa\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0080\u00012\b\u0010\u00f2\u0001\u001a\u00030\u00f3\u0001H\u0002J\u001e\u0010\u00fb\u0001\u001a\u0002022\u0007\u0010\u00fc\u0001\u001a\u00020\u00112\n\u0010\u00fd\u0001\u001a\u0005\u0018\u00010\u00fe\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001e\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\b\"\u0004\b'\u0010(R\u001e\u0010)\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001f\"\u0004\b+\u0010!R\u001e\u0010,\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00104\u001a\b\u0012\u0004\u0012\u00020\u0011058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010:\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001f\"\u0004\b<\u0010!R\u001e\u0010=\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\b\"\u0004\b?\u0010(R\u001e\u0010@\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\b\"\u0004\bB\u0010(R$\u0010C\u001a\b\u0012\u0004\u0012\u00020\u0011058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00107\"\u0004\bE\u00109R\u001e\u0010F\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u001f\"\u0004\bH\u0010!R\u001e\u0010I\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\b\"\u0004\bK\u0010(R\u001e\u0010L\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010.\"\u0004\bN\u00100R\"\u0010Q\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010V\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001e\u0010W\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\b\"\u0004\bY\u0010(R\u001e\u0010Z\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\b\"\u0004\b\\\u0010(R\u001e\u0010]\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010.\"\u0004\b_\u00100R\u001e\u0010`\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010\b\"\u0004\bb\u0010(R\u001e\u0010c\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\b\"\u0004\be\u0010(R\u0010\u0010f\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010g\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010k\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020pX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010q\u001a\u0004\u0018\u00010rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010s\u001a\u0004\u0018\u00010tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020w0v\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010yR#\u0010z\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020{0\u00100v\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010yR#\u0010}\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020{0\u00100v\u00a2\u0006\b\n\u0000\u001a\u0004\b~\u0010yR,\u0010\u007f\u001a\u001c\u0012\u0004\u0012\u00020\u0011\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00010v\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0082\u0001\u0010yR\u001f\u0010\u0083\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110v\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0084\u0001\u0010yR%\u0010\u0085\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100v\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0086\u0001\u0010yR,\u0010\u0087\u0001\u001a\u001b\u0012\u0004\u0012\u00020\u0011\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0080\u00010v\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0088\u0001\u0010yR\u0010\u0010\u0089\u0001\u001a\u00030\u008a\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008b\u0001\u001a\u00030\u008a\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008c\u0001\u001a\u00030\u008a\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008d\u0001\u001a\u00030\u008a\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008e\u0001\u001a\u00030\u008f\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0092\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0093\u0001\u0012\u0005\u0012\u00030\u0094\u00010vX\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u0095\u0001\u0010y\"\u0006\b\u0096\u0001\u0010\u0097\u0001R,\u0010\u0098\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0093\u0001\u0012\u0005\u0012\u00030\u0099\u00010vX\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u009a\u0001\u0010y\"\u0006\b\u009b\u0001\u0010\u0097\u0001R\u001b\u0010\u009c\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020vX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009d\u0001\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u009e\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u0093\u00010vX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u009f\u0001\u001a\u00030\u008f\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u00a0\u0001\u001a\u00030\u0093\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u00a1\u0001\u001a\u00030\u0093\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u00a2\u0001\u001a\u0005\u0018\u00010\u00a3\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a4\u0001\u0010\u00a5\u0001\"\u0006\b\u00a6\u0001\u0010\u00a7\u0001R\"\u0010\u00a8\u0001\u001a\u0005\u0018\u00010\u00a9\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00aa\u0001\u0010\u00ab\u0001\"\u0006\b\u00ac\u0001\u0010\u00ad\u0001R\"\u0010\u00ae\u0001\u001a\u0005\u0018\u00010\u00af\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00b0\u0001\u0010\u00b1\u0001\"\u0006\b\u00b2\u0001\u0010\u00b3\u0001\u00a8\u0006\u0082\u0002"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "COMPATIBILITY_MODE", "", "getCOMPATIBILITY_MODE", "()Z", "spec", "Lpicocli/CommandLine$Model$CommandSpec;", "getSpec", "()Lpicocli/CommandLine$Model$CommandSpec;", "setSpec", "(Lpicocli/CommandLine$Model$CommandSpec;)V", "zipFileNames", "", "", "getZipFileNames", "()[Ljava/lang/String;", "setZipFileNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "outputFormat", "Lde/ids_mannheim/korapxmltools/OutputFormat;", "getOutputFormat", "()Lde/ids_mannheim/korapxmltools/OutputFormat;", "setOutputFormat", "(Lde/ids_mannheim/korapxmltools/OutputFormat;)V", "siglePattern", "getSiglePattern", "()Ljava/lang/String;", "setSiglePattern", "(Ljava/lang/String;)V", "extractAttributesRegex", "getExtractAttributesRegex", "setExtractAttributesRegex", "sBoundsFromMorpho", "getSBoundsFromMorpho", "setSBoundsFromMorpho", "(Z)V", "logLevel", "getLogLevel", "setLogLevel", "columns", "getColumns", "()I", "setColumns", "(I)V", "setWord2Vec", "", "word2vec", "excludeZipGlobs", "", "getExcludeZipGlobs", "()Ljava/util/List;", "setExcludeZipGlobs", "(Ljava/util/List;)V", "tokenSeparator", "getTokenSeparator", "setTokenSeparator", "offsets", "getOffsets", "setOffsets", "comments", "getComments", "setComments", "extractMetadataRegex", "getExtractMetadataRegex", "setExtractMetadataRegex", "annotateWith", "getAnnotateWith", "setAnnotateWith", "quiet", "getQuiet", "setQuiet", "maxThreads", "getMaxThreads", "setMaxThreads", "setThreads", "threads", "zipParallelism", "getZipParallelism", "()Ljava/lang/Integer;", "setZipParallelism", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "sequentialInZip", "getSequentialInZip", "setSequentialInZip", "overwrite", "getOverwrite", "setOverwrite", "memStatsInterval", "getMemStatsInterval", "setMemStatsInterval", "useLemma", "getUseLemma", "setUseLemma", "lemmaOnly", "getLemmaOnly", "setLemmaOnly", "taggerName", "taggerModel", "setTagWith", "tagWith", "parserName", "parserModel", "setParseWith", "parseWith", "call", "LOGGER", "Ljava/util/logging/Logger;", "annotationWorkerPool", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "entryExecutor", "Ljava/util/concurrent/ExecutorService;", "texts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/ids_mannheim/korapxmltools/NonBmpString;", "getTexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "sentences", "Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "getSentences", "tokens", "getTokens", "morpho", "", "Lde/ids_mannheim/korapxmltools/KorapXmlTool$MorphoSpan;", "getMorpho", "fnames", "getFnames", "metadata", "getMetadata", "extraFeatures", "getExtraFeatures", "processedDocs", "Ljava/util/concurrent/atomic/AtomicInteger;", "docsSentToAnnotation", "docsWrittenToZip", "totalDocsInInput", "annotationStartTime", "Ljava/util/concurrent/atomic/AtomicLong;", "progressBar", "Lme/tongfei/progressbar/ProgressBar;", "taggerToolBridges", "", "Lde/ids_mannheim/korapxmltools/TaggerToolBridge;", "getTaggerToolBridges", "setTaggerToolBridges", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "parserToolBridges", "Lde/ids_mannheim/korapxmltools/ParserToolBridge;", "getParserToolBridges", "setParserToolBridges", "zipOrdinals", "totalZips", "zipSizes", "processedZipBytes", "totalZipBytes", "startTimeMillis", "dbFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "getDbFactory", "()Ljavax/xml/parsers/DocumentBuilderFactory;", "setDbFactory", "(Ljavax/xml/parsers/DocumentBuilderFactory;)V", "dBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "setDBuilder", "(Ljavax/xml/parsers/DocumentBuilder;)V", "morphoZipOutputStream", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;", "getMorphoZipOutputStream", "()Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;", "setMorphoZipOutputStream", "(Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;)V", "hasCorrespondingBaseZip", "correspondingBaseZip", "korapxml2conllu", "args", "processZipsWithQueue", "zips", "foundry", "parallelism", "([Ljava/lang/String;Ljava/lang/String;I)V", "globToRegex", "Lkotlin/text/Regex;", "glob", "getTokenSpansFromMorho", "(Ljava/util/Map;)[Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "getFoundryFromZipFileName", "zipFileName", "getFoundryFromZipFileNames", "([Ljava/lang/String;)Ljava/lang/String;", "processZipFile", "zipFilePath", "processZipFileSequentially", "logZipProgress", "humanBytes", "bytes", "formatDuration", "seconds", "processZipEntriesWithPool", "zipFile", "Ljava/util/zip/ZipFile;", "waitForMorpho", "processZipEntry", "_foundry", "zipEntry", "Ljava/util/zip/ZipEntry;", "passedWaitForMorpho", "processText", "docId", "getMorphoFoundry", "logMemoryStats", "count", "korapXmlDependencyOutput", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "korapXmlOutput", "korapXmlMorphoOutput", "conlluOutput", "lmTrainingOutput", "nowOutput", "printConlluToken", "token_index", "token", "lemma", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "tokenOffsetsInSentence", "sentence_index", "extractSpans", "spans", "Lorg/w3c/dom/NodeList;", "(Lorg/w3c/dom/NodeList;)[Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "extractMorphoSpans", "fsSpans", "extractDependencySpans", "depSpans", "extractSentenceSpans", "extractMiscSpans", "parseAndWriteAnnotatedConllu", "annotatedConllu", "task", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool$AnnotationTask;", "OutputFormatConverter", "Span", "MorphoSpan", "app"})
@SourceDebugExtension(value={"SMAP\nKorapXmlTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KorapXmlTool.kt\nde/ids_mannheim/korapxmltools/KorapXmlTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1936:1\n1563#2:1937\n1634#2,3:1938\n2746#2,3:1943\n1563#2:1964\n1634#2,3:1965\n1056#2:1968\n1788#2,4:1975\n1788#2,4:1979\n1869#2,2:1983\n1869#2,2:1985\n1869#2,2:1996\n1056#2:2002\n1869#2,2:2003\n1617#2,9:2022\n1869#2:2031\n1870#2:2033\n1626#2:2034\n1617#2,9:2035\n1869#2:2044\n1870#2:2046\n1626#2:2047\n1761#2,3:2048\n1563#2:2051\n1634#2,3:2052\n1761#2,3:2055\n3919#3:1941\n4434#3:1942\n4435#3:1946\n13805#3,2:1949\n6680#3:1951\n13870#3,3:1954\n13870#3,3:1957\n13805#3,2:1960\n13805#3,2:1971\n13805#3,2:1973\n13805#3,2:2000\n13870#3,3:2007\n13805#3,2:2010\n13805#3,2:2012\n13805#3,2:2014\n13805#3,2:2016\n13805#3,2:2018\n37#4,2:1947\n37#4,2:1952\n37#4,2:1969\n37#4,2:1998\n37#4,2:2020\n1179#5,2:1962\n216#6,2:1987\n205#6,4:1989\n216#6,2:1993\n216#6,2:2005\n1#7:1995\n1#7:2032\n1#7:2045\n*S KotlinDebug\n*F\n+ 1 KorapXmlTool.kt\nde/ids_mannheim/korapxmltools/KorapXmlTool\n*L\n420#1:1937\n420#1:1938,3\n423#1:1943,3\n569#1:1964\n569#1:1965,3\n572#1:1968\n751#1:1975,4\n753#1:1979,4\n781#1:1983,2\n787#1:1985,2\n982#1:1996,2\n1189#1:2002\n1191#1:2003,2\n1784#1:2022,9\n1784#1:2031\n1784#1:2033\n1784#1:2034\n1790#1:2035,9\n1790#1:2044\n1790#1:2046\n1790#1:2047\n1844#1:2048,3\n1849#1:2051\n1849#1:2052,3\n1881#1:2055,3\n421#1:1941\n421#1:1942\n421#1:1946\n436#1:1949,2\n440#1:1951\n442#1:1954,3\n447#1:1957,3\n521#1:1960,2\n647#1:1971,2\n674#1:1973,2\n1130#1:2000,2\n1361#1:2007,3\n1375#1:2010,2\n1479#1:2012,2\n1487#1:2014,2\n1526#1:2016,2\n1539#1:2018,2\n424#1:1947,2\n440#1:1952,2\n574#1:1969,2\n989#1:1998,2\n1638#1:2020,2\n555#1:1962,2\n899#1:1987,2\n908#1:1989,4\n929#1:1993,2\n1271#1:2005,2\n1784#1:2032\n1790#1:2045\n*E\n"})
public final class KorapXmlTool
implements Callable<Integer> {
    private final boolean COMPATIBILITY_MODE = System.getenv("COMPATIBILITY_MODE") != null;
    @CommandLine.Spec
    public CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"At least one zip file name"}, arity="1..*")
    @Nullable
    private String[] zipFileNames;
    @CommandLine.Option(names={"-f", "--output-format"}, description={"Output format: conllu, word2vec, korapxml, now", "conllu: CoNLL-U format", "korapxml, xml, zip: KorAP-XML format zip", "word2vec, w2v: Print text in LM training format: tokens separated by space, sentences separated by newlines", "now, NOW: NOW corpus export format: w2v-like format with <p> tags for sentence ends and @@<text-sigle> prefix"}, converter={OutputFormatConverter.class})
    @NotNull
    private OutputFormat outputFormat = OutputFormat.CONLLU;
    @CommandLine.Option(names={"--sigle-pattern", "-p"}, description={"Extract only documents with sigle matching the pattern (regex)"}, paramLabel="PATTERN")
    @Nullable
    private String siglePattern;
    @CommandLine.Option(names={"--extract-attributes-regex", "-e"}, description={"Extract additional attribute values from structure.xml and writes them as comment line in front of the first covered token.", "Example: -e '(posting/id|div/id)'"}, paramLabel="REGEX")
    @NotNull
    private String extractAttributesRegex = "";
    @CommandLine.Option(names={"--s-bounds-from-morpho"}, description={"Not yet implemented: s bounds from morpho"})
    private boolean sBoundsFromMorpho;
    @CommandLine.Option(names={"--log", "-l"}, description={"Log level: one of SEVERE, WARNING, INFO, FINE, FINER, FINEST. Default: ${DEFAULT-VALUE}])"}, paramLabel="LEVEL")
    @NotNull
    private String logLevel = "WARNING";
    @CommandLine.Option(names={"--columns", "-c"}, description={"Number of columns. 1 means just the token. Default: ${DEFAULT-VALUE}", "Possible values: 1-10"}, paramLabel="NUMBER")
    private int columns = 10;
    @CommandLine.Option(names={"--exclude-zip-glob"}, description={"Exclude zip files whose basename matches the glob (e.g., 'w?d24.tree_tagger.zip').", "May be repeated. Applied to basenames, not full paths."}, paramLabel="GLOB")
    @NotNull
    private List<String> excludeZipGlobs = new ArrayList();
    @CommandLine.Option(names={"--token-separator", "-s"}, description={"Token separator. Default: new-line for CoNLL-U, space for word2vec format."}, paramLabel="STRING", defaultValue="\n")
    @NotNull
    private String tokenSeparator = this.outputFormat == OutputFormat.WORD2VEC || this.outputFormat == OutputFormat.NOW ? " " : "\n";
    @CommandLine.Option(names={"--offsets"}, description={"Not yet implemented: offsets"})
    private boolean offsets;
    @CommandLine.Option(names={"--comments", "-C"}, description={"Not yet implemented: comments"})
    private boolean comments;
    @CommandLine.Option(names={"--extract-metadata-regex", "-m"}, description={"Extract metadata regexes.\nExample: -m '<textSigle>([^<]+)' -m '<creatDate>([^<]+)'"}, paramLabel="REGEX")
    @NotNull
    private List<String> extractMetadataRegex = new ArrayList();
    @CommandLine.Option(names={"--annotate-with", "-A"}, description={"Pipe output through command"}, paramLabel="COMMAND")
    @NotNull
    private String annotateWith = "";
    @CommandLine.Option(names={"--quiet", "-q"}, description={"Suppress the visual progress bar (logging remains unchanged)"})
    private boolean quiet;
    @CommandLine.Option(names={"--threads", "-T"}, description={"Maximum number of threads to use. Default: ${DEFAULT-VALUE}"}, paramLabel="THREADS")
    private int maxThreads = Runtime.getRuntime().availableProcessors() / 2;
    @CommandLine.Option(names={"--zip-parallelism"}, description={"Maximum number of zip files to process concurrently. Defaults to --threads."}, paramLabel="N")
    @Nullable
    private Integer zipParallelism;
    @CommandLine.Option(names={"--sequential"}, description={"Process entries inside each zip sequentially; zips processed in parallel (only for word2vec/now)."})
    private boolean sequentialInZip;
    @CommandLine.Option(names={"--overwrite", "-o"}, description={"Overwrite existing files"})
    private boolean overwrite;
    @CommandLine.Option(names={"--mem-stats-interval"}, description={"Log memory and cache statistics every N processed documents (0 disables; default: 0)"}, paramLabel="N")
    private int memStatsInterval;
    @CommandLine.Option(names={"--lemma"}, description={"In word2vec/now output modes, output lemmas instead of surface tokens when lemma annotations are available (requires corresponding morpho annotation XML)"})
    private boolean useLemma;
    @CommandLine.Option(names={"--lemma-only"}, description={"Do not load texts from data.xml and output only lemmas (requires morpho.xml).", "Only valid with -f word2vec or -f now; implies --lemma."})
    private boolean lemmaOnly;
    @Nullable
    private String taggerName;
    @Nullable
    private String taggerModel;
    @Nullable
    private String parserName;
    @Nullable
    private String parserModel;
    @NotNull
    private final Logger LOGGER;
    @Nullable
    private AnnotationWorkerPool annotationWorkerPool;
    @Nullable
    private ExecutorService entryExecutor;
    @NotNull
    private final ConcurrentHashMap<String, NonBmpString> texts;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> sentences;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> tokens;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, MorphoSpan>> morpho;
    @NotNull
    private final ConcurrentHashMap<String, String> fnames;
    @NotNull
    private final ConcurrentHashMap<String, String[]> metadata;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, String>> extraFeatures;
    @NotNull
    private final AtomicInteger processedDocs;
    @NotNull
    private final AtomicInteger docsSentToAnnotation;
    @NotNull
    private final AtomicInteger docsWrittenToZip;
    @NotNull
    private final AtomicInteger totalDocsInInput;
    @NotNull
    private final AtomicLong annotationStartTime;
    @Nullable
    private ProgressBar progressBar;
    @NotNull
    private ConcurrentHashMap<Long, TaggerToolBridge> taggerToolBridges;
    @NotNull
    private ConcurrentHashMap<Long, ParserToolBridge> parserToolBridges;
    @NotNull
    private final ConcurrentHashMap<String, Integer> zipOrdinals;
    private int totalZips;
    @NotNull
    private final ConcurrentHashMap<String, Long> zipSizes;
    @NotNull
    private final AtomicLong processedZipBytes;
    private long totalZipBytes;
    private long startTimeMillis;
    @Nullable
    private DocumentBuilderFactory dbFactory;
    @Nullable
    private DocumentBuilder dBuilder;
    @Nullable
    private ZipArchiveOutputStream morphoZipOutputStream;

    public KorapXmlTool() {
        Logger logger = Logger.getLogger(KorapXmlTool.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.LOGGER = logger;
        this.texts = new ConcurrentHashMap();
        this.sentences = new ConcurrentHashMap();
        this.tokens = new ConcurrentHashMap();
        this.morpho = new ConcurrentHashMap();
        this.fnames = new ConcurrentHashMap();
        this.metadata = new ConcurrentHashMap();
        this.extraFeatures = new ConcurrentHashMap();
        this.processedDocs = new AtomicInteger(0);
        this.docsSentToAnnotation = new AtomicInteger(0);
        this.docsWrittenToZip = new AtomicInteger(0);
        this.totalDocsInInput = new AtomicInteger(0);
        this.annotationStartTime = new AtomicLong(0L);
        this.taggerToolBridges = new ConcurrentHashMap();
        this.parserToolBridges = new ConcurrentHashMap();
        this.zipOrdinals = new ConcurrentHashMap();
        this.zipSizes = new ConcurrentHashMap();
        this.processedZipBytes = new AtomicLong(0L);
    }

    public final boolean getCOMPATIBILITY_MODE() {
        return this.COMPATIBILITY_MODE;
    }

    @NotNull
    public final CommandLine.Model.CommandSpec getSpec() {
        CommandLine.Model.CommandSpec commandSpec = this.spec;
        if (commandSpec != null) {
            return commandSpec;
        }
        Intrinsics.throwUninitializedPropertyAccessException("spec");
        return null;
    }

    public final void setSpec(@NotNull CommandLine.Model.CommandSpec commandSpec) {
        Intrinsics.checkNotNullParameter(commandSpec, "<set-?>");
        this.spec = commandSpec;
    }

    @Nullable
    public final String[] getZipFileNames() {
        return this.zipFileNames;
    }

    public final void setZipFileNames(@Nullable String[] stringArray) {
        this.zipFileNames = stringArray;
    }

    @NotNull
    public final OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public final void setOutputFormat(@NotNull OutputFormat outputFormat) {
        Intrinsics.checkNotNullParameter((Object)outputFormat, "<set-?>");
        this.outputFormat = outputFormat;
    }

    @Nullable
    public final String getSiglePattern() {
        return this.siglePattern;
    }

    public final void setSiglePattern(@Nullable String string) {
        this.siglePattern = string;
    }

    @NotNull
    public final String getExtractAttributesRegex() {
        return this.extractAttributesRegex;
    }

    public final void setExtractAttributesRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.extractAttributesRegex = string;
    }

    public final boolean getSBoundsFromMorpho() {
        return this.sBoundsFromMorpho;
    }

    public final void setSBoundsFromMorpho(boolean bl) {
        this.sBoundsFromMorpho = bl;
    }

    @NotNull
    public final String getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.logLevel = string;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    @CommandLine.Option(names={"--word2vec", "-w"}, description={"Print text in LM training format: tokens separated by space, sentences separated by newline", "Deprecated: use -f word2vec"})
    public final void setWord2Vec(boolean word2vec) {
        if (word2vec) {
            this.outputFormat = OutputFormat.WORD2VEC;
        }
    }

    @NotNull
    public final List<String> getExcludeZipGlobs() {
        return this.excludeZipGlobs;
    }

    public final void setExcludeZipGlobs(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.excludeZipGlobs = list;
    }

    @NotNull
    public final String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public final void setTokenSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tokenSeparator = string;
    }

    public final boolean getOffsets() {
        return this.offsets;
    }

    public final void setOffsets(boolean bl) {
        this.offsets = bl;
    }

    public final boolean getComments() {
        return this.comments;
    }

    public final void setComments(boolean bl) {
        this.comments = bl;
    }

    @NotNull
    public final List<String> getExtractMetadataRegex() {
        return this.extractMetadataRegex;
    }

    public final void setExtractMetadataRegex(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.extractMetadataRegex = list;
    }

    @NotNull
    public final String getAnnotateWith() {
        return this.annotateWith;
    }

    public final void setAnnotateWith(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.annotateWith = string;
    }

    public final boolean getQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public final int getMaxThreads() {
        return this.maxThreads;
    }

    public final void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public final void setThreads(int threads) {
        if (threads < 1) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%d' for option '--threads': must be at least 1";
            Object[] objectArray = new Object[]{threads};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.maxThreads = threads;
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(threads));
    }

    @Nullable
    public final Integer getZipParallelism() {
        return this.zipParallelism;
    }

    public final void setZipParallelism(@Nullable Integer n) {
        this.zipParallelism = n;
    }

    public final boolean getSequentialInZip() {
        return this.sequentialInZip;
    }

    public final void setSequentialInZip(boolean bl) {
        this.sequentialInZip = bl;
    }

    public final boolean getOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public final int getMemStatsInterval() {
        return this.memStatsInterval;
    }

    public final void setMemStatsInterval(int n) {
        this.memStatsInterval = n;
    }

    public final boolean getUseLemma() {
        return this.useLemma;
    }

    public final void setUseLemma(boolean bl) {
        this.useLemma = bl;
    }

    public final boolean getLemmaOnly() {
        return this.lemmaOnly;
    }

    public final void setLemmaOnly(boolean bl) {
        this.lemmaOnly = bl;
    }

    @CommandLine.Option(names={"--tag-with", "-t"}, description={"Specify a tagger and a model: marmot|opennlp:<path/to/model>."}, paramLabel="TAGGER:MODEL")
    public final void setTagWith(@NotNull String tagWith) {
        Intrinsics.checkNotNullParameter(tagWith, "tagWith");
        Pattern pattern = Pattern.compile("(marmot|opennlp):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(tagWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--tag-with': value does not match the expected pattern marmot|opennlp:<path/to/model>";
            Object[] objectArray = new Object[]{tagWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.taggerName = matcher2.group(1);
        String string = this.taggerModel = matcher2.group(2);
        Intrinsics.checkNotNull(string);
        if (!new File(string).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string3 = "Invalid value for option '--tag-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.taggerModel, this.taggerModel};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string4);
        }
    }

    @CommandLine.Option(names={"--parse-with", "-P"}, description={"Specify a parser and a model: malt:<path/to/model>."}, paramLabel="parser:MODEL")
    public final void setParseWith(@NotNull String parseWith) {
        Intrinsics.checkNotNullParameter(parseWith, "parseWith");
        Pattern pattern = Pattern.compile("(malt):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(parseWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--parse-with': value does not match the expected pattern (malt):<path/to/model>";
            Object[] objectArray = new Object[]{parseWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.parserName = matcher2.group(1);
        String string = this.parserModel = matcher2.group(2);
        Intrinsics.checkNotNull(string);
        if (!new File(string).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string3 = "Invalid value for option '--parse-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.parserModel, this.parserModel};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Integer call() {
        void var2_6;
        Logger logger;
        ConsoleHandler handler = new ConsoleHandler();
        LogManager.getLogManager().reset();
        handler.setFormatter(new ColoredFormatter());
        Handler[] handlerArray = this.LOGGER.getHandlers();
        Intrinsics.checkNotNullExpressionValue(handlerArray, "getHandlers(...)");
        for (Handler handler2 : handlerArray) {
            this.LOGGER.removeHandler(handler2);
        }
        this.LOGGER.addHandler(handler);
        Logger logger2 = this.LOGGER;
        try {
            logger = logger2;
            String string = this.logLevel;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            Level level = Level.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger = logger2;
            this.LOGGER.warning("Invalid log level: " + this.logLevel + ". Defaulting to WARNING.");
            Level level = Level.WARNING;
        }
        logger.setLevel((Level)var2_6);
        if (this.lemmaOnly) {
            this.useLemma = true;
            if (this.outputFormat != OutputFormat.WORD2VEC && this.outputFormat != OutputFormat.NOW) {
                throw new CommandLine.ParameterException(this.getSpec().commandLine(), "--lemma-only is supported only with -f word2vec or -f now");
            }
        }
        Intrinsics.checkNotNull(this.zipFileNames);
        this.LOGGER.info("Processing zip files: " + ArraysKt.joinToString$default(this.zipFileNames, (CharSequence)", ", null, null, 0, null, null, 62, null));
        Intrinsics.checkNotNull(this.zipFileNames);
        this.korapxml2conllu(this.zipFileNames);
        return 0;
    }

    @NotNull
    public final ConcurrentHashMap<String, NonBmpString> getTexts() {
        return this.texts;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getSentences() {
        return this.sentences;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getTokens() {
        return this.tokens;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, MorphoSpan>> getMorpho() {
        return this.morpho;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getFnames() {
        return this.fnames;
    }

    @NotNull
    public final ConcurrentHashMap<String, String[]> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, String>> getExtraFeatures() {
        return this.extraFeatures;
    }

    @NotNull
    public final ConcurrentHashMap<Long, TaggerToolBridge> getTaggerToolBridges() {
        return this.taggerToolBridges;
    }

    public final void setTaggerToolBridges(@NotNull ConcurrentHashMap<Long, TaggerToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.taggerToolBridges = concurrentHashMap;
    }

    @NotNull
    public final ConcurrentHashMap<Long, ParserToolBridge> getParserToolBridges() {
        return this.parserToolBridges;
    }

    public final void setParserToolBridges(@NotNull ConcurrentHashMap<Long, ParserToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.parserToolBridges = concurrentHashMap;
    }

    @Nullable
    public final DocumentBuilderFactory getDbFactory() {
        return this.dbFactory;
    }

    public final void setDbFactory(@Nullable DocumentBuilderFactory documentBuilderFactory) {
        this.dbFactory = documentBuilderFactory;
    }

    @Nullable
    public final DocumentBuilder getDBuilder() {
        return this.dBuilder;
    }

    public final void setDBuilder(@Nullable DocumentBuilder documentBuilder) {
        this.dBuilder = documentBuilder;
    }

    @Nullable
    public final ZipArchiveOutputStream getMorphoZipOutputStream() {
        return this.morphoZipOutputStream;
    }

    public final void setMorphoZipOutputStream(@Nullable ZipArchiveOutputStream zipArchiveOutputStream) {
        this.morphoZipOutputStream = zipArchiveOutputStream;
    }

    public final boolean hasCorrespondingBaseZip(@NotNull String $this$hasCorrespondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$hasCorrespondingBaseZip, "<this>");
        CharSequence charSequence = $this$hasCorrespondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return false;
        }
        CharSequence charSequence2 = $this$hasCorrespondingBaseZip;
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists();
    }

    @Nullable
    public final String correspondingBaseZip(@NotNull String $this$correspondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$correspondingBaseZip, "<this>");
        CharSequence charSequence = $this$correspondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return null;
        }
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        CharSequence charSequence2 = $this$correspondingBaseZip;
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists() ? baseZip : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void korapxml2conllu(@NotNull String[] args) {
        block35: {
            Object[] $this$korapxml2conllu_u24lambda_u240;
            Object object;
            Intrinsics.checkNotNullParameter(args, "args");
            this.entryExecutor = Executors.newFixedThreadPool(this.maxThreads);
            if (((CharSequence)this.annotateWith).length() > 0) {
                if (this.outputFormat == OutputFormat.KORAPXML) {
                    String inputZipPath = args[0];
                    String targetFoundry = "base";
                    targetFoundry = StringsKt.contains$default((CharSequence)this.annotateWith, "spacy", false, 2, null) ? "spacy" : (StringsKt.contains$default((CharSequence)this.annotateWith, "stanza", false, 2, null) ? "stanza" : (StringsKt.contains$default((CharSequence)this.annotateWith, "udpipe", false, 2, null) ? "udpipe" : (StringsKt.contains$default((CharSequence)this.annotateWith, "tree", false, 2, null) ? "tree_tagger" : (StringsKt.contains$default((CharSequence)this.annotateWith, "marmot", false, 2, null) ? "marmot" : (StringsKt.contains$default((CharSequence)this.annotateWith, "opennlp", false, 2, null) ? "opennlp" : (StringsKt.contains$default((CharSequence)this.annotateWith, "corenlp", false, 2, null) ? "corenlp" : "annotated"))))));
                    CharSequence charSequence = inputZipPath;
                    Object object2 = new Regex("\\.zip$");
                    Object object3 = "." + targetFoundry + ".zip";
                    String outputMorphoZipFileName = ((Regex)object2).replace(charSequence, (String)object3);
                    this.LOGGER.info("Initializing output ZIP: " + outputMorphoZipFileName + " (from input: " + inputZipPath + ", foundry: " + targetFoundry + ")");
                    if (new File(outputMorphoZipFileName).exists() && !this.overwrite) {
                        this.LOGGER.severe("Output file " + outputMorphoZipFileName + " already exists. Use --overwrite to overwrite.");
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    if (new File(outputMorphoZipFileName).exists()) {
                        this.LOGGER.info("Deleting existing file: " + outputMorphoZipFileName);
                        new File(outputMorphoZipFileName).delete();
                    }
                    DocumentBuilderFactory documentBuilderFactory = this.dbFactory = DocumentBuilderFactory.newInstance();
                    Intrinsics.checkNotNull(documentBuilderFactory);
                    this.dBuilder = documentBuilderFactory.newDocumentBuilder();
                    FileOutputStream fileOutputStream = new FileOutputStream(outputMorphoZipFileName);
                    object3 = object2 = new ZipArchiveOutputStream(fileOutputStream);
                    object = this;
                    boolean bl = false;
                    $this$korapxml2conllu_u24lambda_u240.setUseZip64(Zip64Mode.Always);
                    ((KorapXmlTool)object).morphoZipOutputStream = object2;
                    this.LOGGER.info("Initialized morphoZipOutputStream for external annotation to: " + outputMorphoZipFileName);
                }
                this.annotationWorkerPool = this.outputFormat == OutputFormat.KORAPXML ? new AnnotationWorkerPool(this.annotateWith, this.maxThreads, this.LOGGER, (arg_0, arg_1) -> KorapXmlTool.korapxml2conllu$lambda$1(this, arg_0, arg_1)) : new AnnotationWorkerPool(this.annotateWith, this.maxThreads, this.LOGGER, null);
            }
            Ref.ObjectRef zips = new Ref.ObjectRef();
            zips.element = args;
            if (!((Collection)this.excludeZipGlobs).isEmpty()) {
                void $this$toTypedArray$iv;
                void $this$filterTo$iv$iv;
                Collection $this$filter$iv;
                void $this$mapTo$iv$iv;
                int before = ((Object[])zips.element).length;
                Object[] $this$map$iv = (Object[])this.excludeZipGlobs;
                boolean $i$f$map = false;
                $this$korapxml2conllu_u24lambda_u240 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(this.globToRegex((String)it));
                }
                List patterns = (List)destination$iv$iv;
                $this$map$iv = (Object[])zips.element;
                object = zips;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block34: {
                        String zipPath = (String)element$iv$iv;
                        boolean bl2 = false;
                        String base = new File(zipPath).getName();
                        Iterable $this$none$iv = patterns;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                Regex rx = (Regex)element$iv;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull(base);
                                if (!rx.matches(base)) continue;
                                bl = false;
                                break block34;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ((Ref.ObjectRef)object).element = thisCollection$iv.toArray(new String[0]);
                int excluded = before - ((Object[])zips.element).length;
                if (excluded > 0) {
                    this.LOGGER.info("Excluded " + excluded + " of " + before + " zip(s) by glob(s): " + CollectionsKt.joinToString$default(this.excludeZipGlobs, ", ", null, null, 0, null, null, 62, null));
                }
            }
            this.startTimeMillis = System.currentTimeMillis();
            this.processedZipBytes.set(0L);
            this.totalZips = ((Object[])zips.element).length;
            this.zipOrdinals.clear();
            this.zipSizes.clear();
            Object[] $this$forEach$iv = (Object[])zips.element;
            boolean $i$f$forEach = false;
            int $i$f$toTypedArray = $this$forEach$iv.length;
            for (int excluded = 0; excluded < $i$f$toTypedArray; ++excluded) {
                long item$iv$iv;
                Object element$iv = $this$forEach$iv[excluded];
                String zip2 = (String)element$iv;
                boolean bl = false;
                Map map2 = this.zipSizes;
                try {
                    item$iv$iv = new File(zip2).length();
                }
                catch (Exception exception) {
                    item$iv$iv = 0L;
                }
                Long l = item$iv$iv;
                map2.put(zip2, l);
            }
            Collection<Long> collection = this.zipSizes.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            this.totalZipBytes = CollectionsKt.sumOfLong((Iterable<Long>)collection);
            if (this.lemmaOnly) {
                Object[] $this$sortedByDescending$iv = (Object[])zips.element;
                boolean $i$f$sortedByDescending = false;
                Collection $this$toTypedArray$iv = ArraysKt.sortedWith($this$sortedByDescending$iv, new Comparator(this){
                    final /* synthetic */ KorapXmlTool this$0;
                    {
                        this.this$0 = korapXmlTool;
                    }

                    public final int compare(T a, T b) {
                        String it = (String)b;
                        boolean bl = false;
                        Long l = (Long)KorapXmlTool.access$getZipSizes$p(this.this$0).get(it);
                        it = (String)a;
                        Comparable comparable = Long.valueOf(l != null ? l : 0L);
                        bl = false;
                        Long l2 = (Long)KorapXmlTool.access$getZipSizes$p(this.this$0).get(it);
                        return ComparisonsKt.compareValues(comparable, l2 != null ? l2 : 0L);
                    }
                });
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                zips.element = thisCollection$iv.toArray(new String[0]);
            }
            Object[] $this$forEachIndexed$iv = (Object[])zips.element;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            int n = $this$forEachIndexed$iv.length;
            for ($i$f$toTypedArray = 0; $i$f$toTypedArray < n; ++$i$f$toTypedArray) {
                void zip3;
                Object item$iv = $this$forEachIndexed$iv[$i$f$toTypedArray];
                int n2 = index$iv++;
                String bl = (String)item$iv;
                int index = n2;
                boolean bl4 = false;
                ((Map)this.zipOrdinals).put(zip3, index + 1);
            }
            String totalHuman = this.humanBytes(this.totalZipBytes);
            this.LOGGER.info("Zip processing order (" + ((Object[])zips.element).length + " file(s), total " + totalHuman + "):");
            Object[] $this$forEachIndexed$iv2 = (Object[])zips.element;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv2) {
                void zip4;
                int n3 = index$iv2++;
                String index = (String)item$iv;
                int idx = n3;
                boolean bl = false;
                Long l = this.zipSizes.get(zip4);
                long size = l != null ? l : 0L;
                Locale locale = Locale.ROOT;
                String string = "%d/%d: %s (%s)";
                Object[] objectArray = new Object[]{idx + 1, ((Object[])zips.element).length, zip4, this.humanBytes(size)};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                this.LOGGER.info(string2);
            }
            if (this.sequentialInZip && this.outputFormat != OutputFormat.WORD2VEC && this.outputFormat != OutputFormat.NOW) {
                throw new CommandLine.ParameterException(this.getSpec().commandLine(), "--sequential is supported only with -f word2vec or -f now");
            }
            if (this.maxThreads > 1) {
                String foundry = this.getFoundryFromZipFileNames((String[])zips.element);
                Integer n4 = this.zipParallelism;
                int parallelism = RangesKt.coerceAtLeast(n4 != null ? n4 : this.maxThreads, 1);
                this.LOGGER.info("Processing zips with ordered queue; parallelism=" + parallelism + "; entries " + (this.sequentialInZip ? "sequential" : "parallel"));
                this.processZipsWithQueue((String[])zips.element, foundry, parallelism);
            } else {
                this.LOGGER.info("Processing zip files sequentially");
                Arrays.stream((Object[])zips.element).forEachOrdered(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$9(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$8(this, zips, arg_0), arg_0));
            }
            ExecutorService executorService = this.entryExecutor;
            if (executorService != null) {
                executorService.shutdown();
            }
            try {
                if (this.entryExecutor != null) {
                    ExecutorService executorService2 = this.entryExecutor;
                    Intrinsics.checkNotNull(executorService2);
                    boolean terminated = executorService2.awaitTermination(7L, TimeUnit.DAYS);
                    if (!terminated) {
                        this.LOGGER.warning("Entry executor did not terminate within timeout; proceeding to close worker pool.");
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.LOGGER.warning("Interrupted while awaiting entry executor termination; proceeding to close worker pool.");
            }
            if (this.annotationWorkerPool != null) {
                this.LOGGER.info("closing worker pool");
                this.LOGGER.info("Documents sent to annotation: " + this.docsSentToAnnotation.get());
                AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
                if (annotationWorkerPool != null) {
                    annotationWorkerPool.close();
                }
                this.LOGGER.info("Documents written to ZIP: " + this.docsWrittenToZip.get());
                if (this.outputFormat == OutputFormat.KORAPXML && this.morphoZipOutputStream != null) {
                    try {
                        ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
                        Intrinsics.checkNotNull(zipArchiveOutputStream);
                        zipArchiveOutputStream.flush();
                        ZipArchiveOutputStream zipArchiveOutputStream2 = this.morphoZipOutputStream;
                        Intrinsics.checkNotNull(zipArchiveOutputStream2);
                        zipArchiveOutputStream2.close();
                        this.LOGGER.info("Closed output ZIP file after annotation processing");
                    }
                    catch (Exception e) {
                        this.LOGGER.severe("ERROR closing ZIP file: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                ProgressBar progressBar = this.progressBar;
                if (progressBar != null) {
                    progressBar.close();
                }
                int sent = this.docsSentToAnnotation.get();
                int written = this.docsWrittenToZip.get();
                if (sent != written) {
                    this.LOGGER.warning("Document count mismatch! Sent to annotation: " + sent + ", Written to ZIP: " + written + " (missing: " + (sent - written) + ")");
                }
            } else {
                ProgressBar progressBar = this.progressBar;
                if (progressBar != null) {
                    progressBar.close();
                }
            }
            ExecutorService executorService3 = this.entryExecutor;
            if (executorService3 == null) break block35;
            executorService3.shutdown();
        }
    }

    private final void processZipsWithQueue(String[] zips, String foundry, int parallelism) {
        int n;
        BlockingQueue queue = new LinkedBlockingQueue();
        String[] $this$forEach$iv = zips;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            queue.put(it);
        }
        ExecutorService executor = Executors.newFixedThreadPool(parallelism);
        AtomicInteger active = new AtomicInteger(0);
        n = 0;
        while (n < parallelism) {
            int it = n++;
            boolean bl = false;
            executor.submit(() -> KorapXmlTool.processZipsWithQueue$lambda$1$0(active, queue, this, foundry));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private final Regex globToRegex(String glob) {
        StringBuilder sb = new StringBuilder("^");
        CharSequence $this$forEach$iv = glob;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            switch (ch) {
                case '*': {
                    StringBuilder stringBuilder = sb.append(".*");
                    break;
                }
                case '?': {
                    StringBuilder stringBuilder = sb.append('.');
                    break;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    StringBuilder stringBuilder = sb.append('\\').append(ch);
                    break;
                }
                default: {
                    StringBuilder stringBuilder = sb.append(ch);
                }
            }
        }
        sb.append('$');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new Regex(string);
    }

    /*
     * WARNING - void declaration
     */
    private final Span[] getTokenSpansFromMorho(Map<String, MorphoSpan> morpho) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = morpho.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-"};
            List fromTo = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
            collection.add(new Span(Integer.parseInt((String)fromTo.get(0)), Integer.parseInt((String)fromTo.get(1))));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Span it = (Span)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFrom());
                it = (Span)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getFrom());
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Span[0]);
    }

    private final String getFoundryFromZipFileName(String zipFileName) {
        CharSequence charSequence = zipFileName;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return "base";
        }
        charSequence = zipFileName;
        Regex regex = new Regex(".*\\.([^/.]+)\\.zip$");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private final String getFoundryFromZipFileNames(String[] zipFileNames) {
        for (String zipFileName : zipFileNames) {
            String foundry = this.getFoundryFromZipFileName(zipFileName);
            if (Intrinsics.areEqual(foundry, "base")) continue;
            return foundry;
        }
        return "base";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processZipFile(String zipFilePath, String foundry) {
        String[] labelParts;
        Integer n = this.zipOrdinals.get(zipFilePath);
        int ord = n != null ? n : 0;
        Long l = this.zipSizes.get(zipFilePath);
        long size = l != null ? l : 0L;
        this.LOGGER.info("Processing zip " + (ord > 0 ? Integer.valueOf(ord) : "?") + "/" + this.totalZips + ": " + zipFilePath + " (" + this.humanBytes(size) + ") in thread " + Thread.currentThread().threadId());
        this.LOGGER.info("Foundry: " + foundry + " " + this.dbFactory);
        if (this.outputFormat == OutputFormat.KORAPXML && this.dbFactory == null) {
            void $this$processZipFile_u24lambda_u240;
            String targetFoundry = "base";
            labelParts = (String[])new ArrayList();
            if (this.taggerName != null) {
                String string = this.taggerName;
                Intrinsics.checkNotNull(string);
                String string2 = this.taggerModel;
                Intrinsics.checkNotNull(string2);
                TaggerToolBridge tagger = (TaggerToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string2, this.LOGGER);
                if (tagger != null) {
                    labelParts.add(tagger.getFoundry());
                }
            }
            if (this.parserName != null) {
                String string = this.parserName;
                Intrinsics.checkNotNull(string);
                labelParts.add(string);
            }
            if (!((Collection)labelParts).isEmpty()) {
                targetFoundry = CollectionsKt.joinToString$default((Iterable)labelParts, "-", null, null, 0, null, null, 62, null);
            } else if (((CharSequence)this.annotateWith).length() > 0) {
                targetFoundry = StringsKt.contains$default((CharSequence)this.annotateWith, "spacy", false, 2, null) ? "spacy" : (StringsKt.contains$default((CharSequence)this.annotateWith, "stanza", false, 2, null) ? "stanza" : (StringsKt.contains$default((CharSequence)this.annotateWith, "udpipe", false, 2, null) ? "udpipe" : (StringsKt.contains$default((CharSequence)this.annotateWith, "tree", false, 2, null) ? "tree_tagger" : (StringsKt.contains$default((CharSequence)this.annotateWith, "marmot", false, 2, null) ? "marmot" : (StringsKt.contains$default((CharSequence)this.annotateWith, "opennlp", false, 2, null) ? "opennlp" : (StringsKt.contains$default((CharSequence)this.annotateWith, "corenlp", false, 2, null) ? "corenlp" : "annotated"))))));
                this.LOGGER.info("Detected foundry '" + targetFoundry + "' from annotation command: " + this.annotateWith);
            }
            DocumentBuilderFactory documentBuilderFactory = this.dbFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNull(documentBuilderFactory);
            this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            CharSequence charSequence = zipFilePath;
            Object object = new Regex("\\.zip$");
            Object object2 = "." + targetFoundry + ".zip";
            String outputMorphoZipFileName = ((Regex)object).replace(charSequence, (String)object2);
            this.LOGGER.info("Output ZIP file: " + outputMorphoZipFileName);
            if (new File(outputMorphoZipFileName).exists() && !this.overwrite) {
                this.LOGGER.severe("Output file " + outputMorphoZipFileName + " already exists. Use --overwrite to overwrite.");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(outputMorphoZipFileName);
            object2 = object = new ZipArchiveOutputStream(fileOutputStream);
            KorapXmlTool korapXmlTool = this;
            boolean bl = false;
            $this$processZipFile_u24lambda_u240.setUseZip64(Zip64Mode.Always);
            korapXmlTool.morphoZipOutputStream = object;
            this.LOGGER.info("Initialized morphoZipOutputStream for " + outputMorphoZipFileName);
        } else {
            this.LOGGER.info("Skipping ZIP initialization: dbFactory=" + (this.dbFactory != null) + ", outputFormat=" + this.outputFormat);
        }
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            String[] relatedZips;
            labelParts = new String[2];
            labelParts[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            String[] $this$forEach$iv = relatedZips = labelParts;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int fileOutputStream = 0; fileOutputStream < n2; ++fileOutputStream) {
                String element$iv;
                String zip2 = element$iv = $this$forEach$iv[fileOutputStream];
                boolean bl = false;
                Closeable closeable = new ZipFile(zip2);
                Throwable throwable = null;
                try {
                    ZipFile zipFile = (ZipFile)closeable;
                    boolean bl2 = false;
                    this.processZipEntriesWithPool(zipFile, foundry, true);
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                this.processZipEntriesWithPool(zipFile, foundry, false);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        if (this.outputFormat == OutputFormat.KORAPXML && this.annotationWorkerPool == null) {
            this.LOGGER.fine("Closing output ZIP file in processZipFile (no annotation worker pool)");
            ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
            Intrinsics.checkNotNull(zipArchiveOutputStream);
            zipArchiveOutputStream.close();
        } else if (this.outputFormat == OutputFormat.KORAPXML) {
            this.LOGGER.fine("NOT closing ZIP in processZipFile - will close after worker pool finishes");
        }
        this.logZipProgress(zipFilePath);
    }

    static /* synthetic */ void processZipFile$default(KorapXmlTool korapXmlTool, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXmlTool.processZipFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processZipFileSequentially(String zipFilePath, String foundry) {
        Integer n = this.zipOrdinals.get(zipFilePath);
        int ord = n != null ? n : 0;
        Long l = this.zipSizes.get(zipFilePath);
        long size = l != null ? l : 0L;
        this.LOGGER.info("Processing zip " + (ord > 0 ? Integer.valueOf(ord) : "?") + "/" + this.totalZips + ": " + zipFilePath + " (" + this.humanBytes(size) + ") in thread " + Thread.currentThread().threadId());
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            String[] zips;
            String[] stringArray = new String[2];
            stringArray[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            String[] $this$forEach$iv = zips = stringArray;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i = 0; i < n2; ++i) {
                String element$iv;
                String zip2 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Closeable closeable = new ZipFile(zip2);
                Throwable throwable = null;
                try {
                    ZipFile zipFile = (ZipFile)closeable;
                    boolean bl2 = false;
                    zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$0$0$1(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$0$0$0(this, arg_0), arg_0)).sorted(Comparator.comparing(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$0$0$3(KorapXmlTool::processZipFileSequentially$lambda$0$0$2, arg_0))).forEachOrdered(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$0$0$5(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$0$0$4(this, zipFile, foundry, arg_0), arg_0));
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$1$1(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$1$0(this, arg_0), arg_0)).sorted(Comparator.comparing(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$1$3(KorapXmlTool::processZipFileSequentially$lambda$1$2, arg_0))).forEachOrdered(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$1$5(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$1$4(this, zipFile, foundry, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        this.logZipProgress(zipFilePath);
    }

    static /* synthetic */ void processZipFileSequentially$default(KorapXmlTool korapXmlTool, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXmlTool.processZipFileSequentially(string, string2);
    }

    private final void logZipProgress(String zipFilePath) {
        try {
            Long l = this.zipSizes.get(zipFilePath);
            long size = l != null ? l : 0L;
            long done = this.processedZipBytes.addAndGet(size);
            long total = this.totalZipBytes > 0L ? this.totalZipBytes : 1L;
            long elapsedMs = RangesKt.coerceAtLeast(System.currentTimeMillis() - this.startTimeMillis, 1L);
            double speedBytesPerSec = (double)done * 1000.0 / (double)elapsedMs;
            long remaining = RangesKt.coerceAtLeast(total - done, 0L);
            long etaSeconds = speedBytesPerSec > 0.0 ? (long)((double)remaining / speedBytesPerSec) : -1L;
            Integer n = this.zipOrdinals.get(zipFilePath);
            int ord = n != null ? n : 0;
            double pct = RangesKt.coerceIn((double)done * 100.0 / (double)total, 0.0, 100.0);
            Locale locale = Locale.ROOT;
            Object object = "%.2f MB/s";
            Object object2 = new Object[]{speedBytesPerSec / 1048576.0};
            String string = String.format(locale, (String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            String humanSpeed = string;
            String etaStr = etaSeconds >= 0L ? this.formatDuration(etaSeconds) : "unknown";
            Object object3 = ord > 0 ? Integer.valueOf(ord) : "?";
            String string2 = this.humanBytes(size);
            object = Locale.ROOT;
            object2 = "%.1f";
            Object[] objectArray = new Object[]{pct};
            String string3 = String.format((Locale)object, (String)object2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            this.LOGGER.info("Finished zip " + object3 + "/" + this.totalZips + ": " + zipFilePath + " (" + string2 + "). Progress: " + string3 + "%%, ETA " + etaStr + " at " + humanSpeed);
        }
        catch (Exception e) {
            this.LOGGER.fine("Failed to log zip progress for " + zipFilePath + ": " + e.getMessage());
        }
    }

    private final String humanBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        double kb = (double)bytes / 1024.0;
        if (kb < 1024.0) {
            Locale locale = Locale.ROOT;
            String string = "%.1f KB";
            Object[] objectArray = new Object[]{kb};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            return string2;
        }
        double mb = kb / 1024.0;
        if (mb < 1024.0) {
            Locale locale = Locale.ROOT;
            String string = "%.1f MB";
            Object[] objectArray = new Object[]{mb};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            return string3;
        }
        double gb = mb / 1024.0;
        Locale locale = Locale.ROOT;
        String string = "%.1f GB";
        Object[] objectArray = new Object[]{gb};
        String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        return string4;
    }

    private final String formatDuration(long seconds) {
        long s = seconds;
        long h = s / (long)3600;
        long m = (s %= (long)3600) / (long)60;
        long sec = s % (long)60;
        Locale locale = Locale.ROOT;
        String string = "%02d:%02d:%02d";
        Object[] objectArray = new Object[]{h, m, sec};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private final void processZipEntriesWithPool(ZipFile zipFile, String foundry, boolean waitForMorpho) {
        ZipEntry it;
        int count$iv;
        List entries = new ArrayList();
        int documentCount = 0;
        Enumeration<? extends ZipEntry> enumEntries = zipFile.entries();
        while (enumEntries.hasMoreElements()) {
            ZipEntry e = enumEntries.nextElement();
            if (this.extractMetadataRegex.isEmpty()) {
                String string = e.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) continue;
            }
            Intrinsics.checkNotNull(e);
            entries.add(e);
        }
        if (entries.isEmpty()) {
            return;
        }
        Iterable $this$count$iv = entries;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (ZipEntry)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, "data.xml", false, 2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = documentCount = count$iv;
        }
        if (documentCount == 0) {
            $this$count$iv = entries;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v3 = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (ZipEntry)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, "tokens.xml", false, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v3 = documentCount = count$iv;
            }
        }
        if ((this.annotationWorkerPool != null || this.taggerName != null) && documentCount > 0) {
            int newTotal = this.totalDocsInInput.addAndGet(documentCount);
            if (this.annotationStartTime.get() == 0L) {
                this.annotationStartTime.set(System.currentTimeMillis());
                this.LOGGER.info("Starting annotation of " + newTotal + " document(s)");
                if (!this.quiet) {
                    this.progressBar = new ProgressBarBuilder().setTaskName("Annotating").setInitialMax(newTotal).setStyle(ProgressBarStyle.COLORFUL_UNICODE_BAR).setUpdateIntervalMillis(500).showSpeed().build();
                }
            } else if (!this.quiet) {
                ProgressBar progressBar = this.progressBar;
                if (progressBar != null) {
                    progressBar.maxHint(newTotal);
                }
            }
        }
        if (this.maxThreads <= 1) {
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl = false;
                this.processZipEntry(zipFile, foundry, entry, waitForMorpho);
            }
            return;
        }
        CountDownLatch latch = new CountDownLatch(entries.size());
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ZipEntry entry = (ZipEntry)element$iv;
            boolean bl = false;
            ExecutorService executorService = this.entryExecutor;
            if (executorService == null) continue;
            executorService.execute(() -> KorapXmlTool.processZipEntriesWithPool$lambda$3$0(this, zipFile, foundry, entry, waitForMorpho, latch));
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void processZipEntry(@NotNull ZipFile zipFile, @NotNull String _foundry, @NotNull ZipEntry zipEntry, boolean passedWaitForMorpho) {
        block79: {
            Object parser;
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            Intrinsics.checkNotNullParameter(_foundry, "_foundry");
            Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
            Object foundry = null;
            foundry = _foundry;
            boolean waitForMorpho = passedWaitForMorpho;
            this.LOGGER.finer("Processing " + zipEntry.getName() + " in thread " + Thread.currentThread().threadId());
            if (this.taggerName != null && !this.taggerToolBridges.containsKey(Thread.currentThread().threadId())) {
                String string = this.taggerName;
                Intrinsics.checkNotNull(string);
                String string2 = this.taggerModel;
                Intrinsics.checkNotNull(string2);
                TaggerToolBridge tagger = (TaggerToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string2, this.LOGGER);
                if (tagger != null) {
                    ((Map)this.taggerToolBridges).put(Thread.currentThread().threadId(), tagger);
                    foundry = tagger.getFoundry();
                }
            }
            if (this.parserName != null && !this.parserToolBridges.containsKey(Thread.currentThread().threadId())) {
                String string = this.parserName;
                Intrinsics.checkNotNull(string);
                String string3 = this.parserModel;
                Intrinsics.checkNotNull(string3);
                parser = (ParserToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string3, this.LOGGER);
                if (parser != null) {
                    ((Map)this.parserToolBridges).put(Thread.currentThread().threadId(), parser);
                    foundry = foundry + " dependency:" + parser.getFoundry();
                    this.LOGGER.fine("Initialized parser " + this.parserName + " with foundry " + foundry + " in thread " + Thread.currentThread().threadId());
                }
            }
            TaggerToolBridge taggerToolBridge = this.taggerToolBridges.get(Thread.currentThread().threadId());
            if (taggerToolBridge != null) {
                TaggerToolBridge activeTagger = taggerToolBridge;
                boolean bl = false;
                foundry = activeTagger.getFoundry();
                v5 = Unit.INSTANCE;
            } else {
                v5 = null;
            }
            ParserToolBridge parserToolBridge = this.parserToolBridges.get(Thread.currentThread().threadId());
            if (parserToolBridge != null) {
                ParserToolBridge activeParser = parserToolBridge;
                boolean bl = false;
                foundry = foundry + " dependency:" + activeParser.getFoundry();
                v7 = Unit.INSTANCE;
            } else {
                v7 = null;
            }
            try {
                String string;
                Object morphoRequired2;
                Object it;
                Object doc;
                Object dbFactory;
                block81: {
                    Object bl;
                    Iterator<Map.Entry<String, MorphoSpan>> reader;
                    Object object;
                    Object inputStream;
                    Object object2;
                    String string4 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    parser = string4;
                    if (!new Regex(".*(data|tokens|structure|morpho|dependency)\\.xml$").matches((CharSequence)parser)) break block81;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    Intrinsics.checkNotNullExpressionValue(documentBuilderFactory, "newInstance(...)");
                    dbFactory = documentBuilderFactory;
                    DocumentBuilder documentBuilder = ((DocumentBuilderFactory)dbFactory).newDocumentBuilder();
                    Intrinsics.checkNotNullExpressionValue(documentBuilder, "newDocumentBuilder(...)");
                    DocumentBuilder dBuilder = documentBuilder;
                    if (this.lemmaOnly) {
                        String string5 = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                        if (StringsKt.endsWith$default(string5, "data.xml", false, 2, null)) {
                            return;
                        }
                    }
                    try {
                        Closeable closeable = zipFile.getInputStream(zipEntry);
                        object2 = null;
                        try {
                            inputStream = (InputStream)closeable;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull(inputStream);
                            object = new XMLCommentFilterReader((InputStream)inputStream, "UTF-8");
                            Throwable throwable = null;
                            try {
                                reader = (XMLCommentFilterReader)object;
                                boolean bl3 = false;
                                reader = dBuilder.parse(new InputSource((Reader)((Object)reader)));
                            }
                            catch (Throwable bl3) {
                                throwable = bl3;
                                throw bl3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, throwable);
                            }
                            inputStream = reader;
                        }
                        catch (Throwable bl2) {
                            object2 = bl2;
                            throw bl2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, (Throwable)object2);
                        }
                        bl = inputStream;
                        Intrinsics.checkNotNull(bl);
                    }
                    catch (SAXParseException e) {
                        this.LOGGER.warning("Error parsing file: " + zipEntry.getName() + " " + e.getMessage());
                        return;
                    }
                    doc = bl;
                    doc.getDocumentElement().normalize();
                    String string6 = doc.getDocumentElement().getAttribute("docid");
                    Intrinsics.checkNotNullExpressionValue(string6, "getAttribute(...)");
                    String docId = string6;
                    if (this.siglePattern != null) {
                        String string7 = this.siglePattern;
                        Intrinsics.checkNotNull(string7);
                        if (!new Regex(string7).containsMatchIn(docId)) {
                            return;
                        }
                    }
                    String string8 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string8, "getName(...)");
                    object2 = string8;
                    inputStream = new Regex(".*?/([^/]+\\.xml)$");
                    Object bl2 = "$1";
                    String fileName = ((Regex)inputStream).replace((CharSequence)object2, (String)bl2);
                    switch (fileName) {
                        case "data.xml": {
                            if (this.lemmaOnly) break;
                            NodeList nodeList = doc.getElementsByTagName("text");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList textsList = nodeList;
                            if (textsList.getLength() <= 0) break;
                            bl2 = this.texts;
                            String string9 = textsList.item(0).getTextContent();
                            Intrinsics.checkNotNullExpressionValue(string9, "getTextContent(...)");
                            object = new NonBmpString(string9);
                            bl2.put(docId, object);
                            break;
                        }
                        case "structure.xml": {
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList spans = nodeList;
                            if (((CharSequence)this.extractAttributesRegex).length() > 0) {
                                ((Map)this.extraFeatures).put(docId, this.extractMiscSpans(spans));
                            }
                            ((Map)this.sentences).put(docId, this.extractSentenceSpans(spans));
                            break;
                        }
                        case "tokens.xml": {
                            if (!this.fnames.contains(docId)) {
                                ((Map)this.fnames).put(docId, zipEntry.getName());
                            }
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList tokenSpans = nodeList;
                            ((Map)this.tokens).put(docId, this.extractSpans(tokenSpans));
                            break;
                        }
                        case "morpho.xml": {
                            waitForMorpho = true;
                            ((Map)this.fnames).put(docId, zipEntry.getName());
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList fsSpans = nodeList;
                            Map<String, MorphoSpan> morphoSpans = this.extractMorphoSpans(fsSpans);
                            if (this.morpho.get(docId) == null) {
                                ((Map)this.morpho).put(docId, morphoSpans);
                            } else {
                                int n;
                                void $this$count$iv;
                                Map<String, MorphoSpan> $this$forEach$iv = morphoSpans;
                                boolean $i$f$forEach = false;
                                reader = $this$forEach$iv.entrySet().iterator();
                                while (reader.hasNext()) {
                                    MorphoSpan existing;
                                    Map.Entry<String, MorphoSpan> element$iv;
                                    Map.Entry<String, MorphoSpan> entry = element$iv = reader.next();
                                    boolean bl4 = false;
                                    String key = entry.getKey();
                                    MorphoSpan mfs = entry.getValue();
                                    Map<String, MorphoSpan> map2 = this.morpho.get(docId);
                                    MorphoSpan morphoSpan = existing = map2 != null ? map2.get(key) : null;
                                    if (existing != null) {
                                        mfs.setHead(existing.getHead());
                                        mfs.setDeprel(existing.getDeprel());
                                    }
                                    Map<String, MorphoSpan> map3 = this.morpho.get(docId);
                                    Intrinsics.checkNotNull(map3);
                                    map3.put(key, mfs);
                                }
                                Map<String, MorphoSpan> map4 = this.morpho.get(docId);
                                Intrinsics.checkNotNull(map4);
                                $this$forEach$iv = map4;
                                String string10 = docId;
                                Logger logger = this.LOGGER;
                                boolean $i$f$count = false;
                                if ($this$count$iv.isEmpty()) {
                                    n = 0;
                                } else {
                                    int count$iv = 0;
                                    Iterator element$iv = $this$count$iv.entrySet().iterator();
                                    while (element$iv.hasNext()) {
                                        Map.Entry element$iv2;
                                        Map.Entry it2 = element$iv2 = element$iv.next();
                                        boolean bl5 = false;
                                        if (!(!Intrinsics.areEqual(((MorphoSpan)it2.getValue()).getHead(), "_"))) continue;
                                        ++count$iv;
                                    }
                                    n = count$iv;
                                }
                                int n2 = n;
                                logger.fine("Merged morpho.xml with existing data for " + string10 + " (preserved " + n2 + " dependency relations)");
                            }
                            ((Map)this.tokens).put(docId, this.extractSpans(fsSpans));
                            break;
                        }
                        case "dependency.xml": {
                            this.LOGGER.info("Processing dependency.xml for " + docId + " from " + zipEntry.getName());
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList depSpans = nodeList;
                            this.LOGGER.info("Found " + depSpans.getLength() + " spans in dependency.xml");
                            Map<String, MorphoSpan> depMap = this.extractDependencySpans(depSpans);
                            this.LOGGER.info("Extracted " + depMap.size() + " dependency relations");
                            if (this.morpho.get(docId) == null) {
                                ((Map)this.morpho).put(docId, (Map)new LinkedHashMap());
                                this.LOGGER.info("Created new morpho map for " + docId);
                            }
                            int mergedCount = 0;
                            int newCount = 0;
                            Map<String, MorphoSpan> $this$forEach$iv = depMap;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<String, MorphoSpan>> iterator2 = $this$forEach$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                int n;
                                int n3;
                                MorphoSpan existing;
                                Map.Entry<String, MorphoSpan> element$iv;
                                Map.Entry<String, MorphoSpan> entry = element$iv = iterator2.next();
                                boolean bl6 = false;
                                String key = entry.getKey();
                                MorphoSpan depSpan = entry.getValue();
                                Map<String, MorphoSpan> map5 = this.morpho.get(docId);
                                MorphoSpan morphoSpan = existing = map5 != null ? map5.get(key) : null;
                                if (existing != null) {
                                    existing.setHead(depSpan.getHead());
                                    existing.setDeprel(depSpan.getDeprel());
                                    n3 = mergedCount;
                                    mergedCount = n3 + 1;
                                    n = n3;
                                    continue;
                                }
                                Map<String, MorphoSpan> map6 = this.morpho.get(docId);
                                Intrinsics.checkNotNull(map6);
                                map6.put(key, depSpan);
                                n3 = newCount;
                                newCount = n3 + 1;
                                n = n3;
                            }
                            this.LOGGER.info("Dependency merge complete: " + mergedCount + " merged, " + newCount + " new entries (heads will be resolved during output)");
                        }
                    }
                    boolean morphoRequired2 = this.taggerName != null || this.parserName != null ? false : (this.useLemma ? true : (waitForMorpho ? true : this.outputFormat == OutputFormat.KORAPXML && this.annotationWorkerPool == null));
                    boolean textRequired = switch (WhenMappings.$EnumSwitchMapping$0[this.outputFormat.ordinal()]) {
                        case 1, 2 -> {
                            if (!this.useLemma && !this.lemmaOnly) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> true;
                    };
                    this.LOGGER.fine("Checking if ready to process " + docId + ": texts=" + (this.texts.get(docId) != null) + ", sentences=" + (this.sentences.get(docId) != null) + ", tokens=" + (this.tokens.get(docId) != null) + ", morpho=" + (this.morpho.get(docId) != null) + ", morphoRequired=" + morphoRequired2 + ", textRequired=" + textRequired + ", annotationWorkerPool=" + (this.annotationWorkerPool != null));
                    if (!(this.texts.get(docId) == null && textRequired || this.sentences.get(docId) == null || this.tokens.get(docId) == null || morphoRequired2 && this.morpho.get(docId) == null || !this.extractMetadataRegex.isEmpty() && this.metadata.get(docId) == null)) {
                        this.LOGGER.fine("All data ready for " + docId + ", calling processText");
                        this.processText(docId, (String)foundry);
                    } else {
                        this.LOGGER.fine("NOT ready to process " + docId + " yet: textOK=" + (this.texts.get(docId) != null || !textRequired) + ", sentencesOK=" + (this.sentences.get(docId) != null) + ", tokensOK=" + (this.tokens.get(docId) != null) + ", morphoOK=" + (!morphoRequired2 || this.morpho.get(docId) != null));
                    }
                    break block79;
                }
                if (!(!((Collection)this.extractMetadataRegex).isEmpty())) break block79;
                String string11 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue(string11, "getName(...)");
                dbFactory = string11;
                if (!new Regex(".*/header\\.xml$").matches((CharSequence)dbFactory)) break block79;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                Closeable dBuilder = inputStream;
                doc = Charsets.UTF_8;
                Reader docId = new InputStreamReader((InputStream)dBuilder, (Charset)doc);
                int fileName = 8192;
                dBuilder = docId instanceof BufferedReader ? (BufferedReader)docId : new BufferedReader(docId, fileName);
                doc = null;
                try {
                    it = (BufferedReader)dBuilder;
                    boolean bl = false;
                    it = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable bl) {
                    doc = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally(dBuilder, (Throwable)doc);
                }
                Object text = it;
                doc = Regex.find$default(new Regex("<textSigle>([^<]+)</textSigle>"), (CharSequence)text, 0, 2, null);
                if (doc != null && (it = doc.getDestructured()) != null && (bl = ((MatchResult.Destructured)it).getMatch().getGroupValues().get(1)) != null) {
                    morphoRequired2 = bl;
                    Regex textRequired = new Regex("/");
                    String depMap = "_";
                    string = textRequired.replace((CharSequence)morphoRequired2, depMap);
                } else {
                    string = null;
                }
                String docId2 = string;
                this.LOGGER.fine("Processing header file: " + zipEntry.getName() + " docId: " + docId2);
                ArrayList<String> meta = new ArrayList<String>();
                Object $this$forEach$iv = this.extractMetadataRegex;
                boolean $i$f$forEach2 = false;
                morphoRequired2 = $this$forEach$iv.iterator();
                while (morphoRequired2.hasNext()) {
                    Object element$iv = morphoRequired2.next();
                    String regex = (String)element$iv;
                    boolean bl = false;
                    MatchResult match = Regex.find$default(new Regex(regex), (CharSequence)text, 0, 2, null);
                    if (match == null) continue;
                    meta.add(match.getDestructured().getMatch().getGroupValues().get(1));
                }
                if (!((Collection)meta).isEmpty() && docId2 != null) {
                    boolean textRequired;
                    $this$forEach$iv = this.metadata;
                    String $i$f$forEach2 = docId2;
                    Collection $this$toTypedArray$iv = meta;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    $this$forEach$iv.put($i$f$forEach2, stringArray);
                    boolean morphoRequired3 = this.taggerName != null || this.parserName != null ? false : (this.useLemma ? true : (waitForMorpho ? true : this.outputFormat == OutputFormat.KORAPXML && this.annotationWorkerPool == null));
                    switch (WhenMappings.$EnumSwitchMapping$0[this.outputFormat.ordinal()]) {
                        case 1: 
                        case 2: {
                            boolean bl;
                            if (!this.useLemma && !this.lemmaOnly) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            boolean bl = textRequired = true;
                        }
                    }
                    if (!(this.texts.get(docId2) == null && textRequired || this.sentences.get(docId2) == null || this.tokens.get(docId2) == null || morphoRequired3 && this.morpho.get(docId2) == null)) {
                        this.LOGGER.info("Processing text (meta-ready): " + docId2 + " in thread " + Thread.currentThread().threadId());
                        this.processText(docId2, (String)foundry);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processText(String docId, String foundry) {
        int count2;
        ConcurrentHashMap[] morphoDir;
        StringBuilder output;
        this.LOGGER.fine("Processing text: " + docId + " in thread " + Thread.currentThread().threadId());
        String morphoFoundry = this.getMorphoFoundry();
        if (this.outputFormat == OutputFormat.WORD2VEC) {
            v0 = this.lmTrainingOutput(docId);
        } else if (this.outputFormat == OutputFormat.NOW) {
            v0 = this.nowOutput(docId);
        } else {
            if (this.taggerToolBridges.get(Thread.currentThread().threadId()) != null) {
                Map map2 = this.morpho;
                TaggerToolBridge taggerToolBridge = this.taggerToolBridges.get(Thread.currentThread().threadId());
                Intrinsics.checkNotNull(taggerToolBridge);
                Span[] spanArray = this.tokens.get(docId);
                Intrinsics.checkNotNull(spanArray);
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                map2.put(docId, taggerToolBridge.tagText(spanArray, this.sentences.get(docId), nonBmpString));
            }
            if (this.parserToolBridges.get(Thread.currentThread().threadId()) != null) {
                if (this.morpho.get(docId) == null) {
                    this.LOGGER.severe("No morpho data for " + docId);
                }
                this.LOGGER.finer("Parsing text: " + docId + " in thread " + Thread.currentThread().threadId());
                Map map3 = this.morpho;
                ParserToolBridge parserToolBridge = this.parserToolBridges.get(Thread.currentThread().threadId());
                Intrinsics.checkNotNull(parserToolBridge);
                Span[] spanArray = this.tokens.get(docId);
                Intrinsics.checkNotNull(spanArray);
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                map3.put(docId, parserToolBridge.parseText(spanArray, this.morpho.get(docId), this.sentences.get(docId), nonBmpString));
                this.LOGGER.finer("Parsed text: " + docId + " in thread " + Thread.currentThread().threadId());
            }
            v0 = output = this.outputFormat == OutputFormat.KORAPXML && this.annotationWorkerPool == null ? this.korapXmlOutput(this.getMorphoFoundry(), docId) : this.conlluOutput(foundry, docId);
        }
        if (this.annotationWorkerPool != null) {
            if (this.outputFormat == OutputFormat.KORAPXML) {
                String string;
                if (this.parserName != null) {
                    var6_5 = docId;
                    var7_7 = new Regex("[_.]");
                    var8_12 = "/";
                    string = var7_7.replace((CharSequence)var6_5, var8_12) + "/" + this.parserName + "/dependency.xml";
                } else {
                    var6_5 = docId;
                    var7_7 = new Regex("[_.]");
                    var8_12 = "/";
                    string = var7_7.replace((CharSequence)var6_5, var8_12) + "/" + morphoFoundry + "/morpho.xml";
                }
                String entryPath = string;
                this.LOGGER.fine("Sending document " + docId + " (" + output.length() + " chars) to annotation worker pool for ZIP output");
                AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
                if (annotationWorkerPool != null) {
                    String string2 = output.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                    annotationWorkerPool.pushToQueue(string2, docId, entryPath + "|" + foundry);
                }
                v12 = this.docsSentToAnnotation.incrementAndGet();
            } else {
                this.LOGGER.fine("Sending document " + docId + " (" + output.length() + " chars) to annotation worker pool");
                AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
                if (annotationWorkerPool != null) {
                    String string = output.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    AnnotationWorkerPool.pushToQueue$default(annotationWorkerPool, string, null, null, 6, null);
                }
                v12 = this.docsSentToAnnotation.incrementAndGet();
            }
            output.setLength(0);
        } else if (this.outputFormat != OutputFormat.KORAPXML) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            var6_5 = printStream;
            synchronized (var6_5) {
                boolean $i$a$-synchronized-KorapXmlTool$processText$42 = false;
                System.out.println((Object)output.toString());
                Unit $i$a$-synchronized-KorapXmlTool$processText$42 = Unit.INSTANCE;
            }
            output.setLength(0);
        } else {
            int written;
            Object morphoEntry;
            Object object;
            Regex regex;
            Object object2;
            ConcurrentHashMap[] concurrentHashMapArray = this.taggerToolBridges.get(Thread.currentThread().threadId());
            if (concurrentHashMapArray == null || (concurrentHashMapArray = concurrentHashMapArray.getFoundry()) == null) {
                concurrentHashMapArray = morphoDir = morphoFoundry;
            }
            if ((object2 = this.parserName) == null) {
                object2 = morphoDir;
            }
            String depDir = object2;
            boolean wroteOne = false;
            if (this.morpho.get(docId) != null) {
                Map<String, MorphoSpan> map4 = this.morpho.get(docId);
                Intrinsics.checkNotNull(map4);
                if (!map4.isEmpty()) {
                    String string = this.korapXmlMorphoOutput((String)morphoDir, docId).toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String morphoXml = string;
                    CharSequence charSequence = docId;
                    regex = new Regex("[_.]");
                    object = "/";
                    String morphoPath = regex.replace(charSequence, (String)object) + "/" + (String)morphoDir + "/morpho.xml";
                    morphoEntry = new ZipArchiveEntry(morphoPath);
                    ((ZipArchiveEntry)morphoEntry).setUnixMode(KorapXmlToolKt.getZIP_ENTRY_UNIX_MODE());
                    ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream);
                    object = zipArchiveOutputStream;
                    synchronized (object) {
                        boolean $i$a$-synchronized-KorapXmlTool$processText$52 = false;
                        ZipArchiveOutputStream zipArchiveOutputStream2 = this.morphoZipOutputStream;
                        Intrinsics.checkNotNull(zipArchiveOutputStream2);
                        zipArchiveOutputStream2.putArchiveEntry((ZipArchiveEntry)morphoEntry);
                        ZipArchiveOutputStream zipArchiveOutputStream3 = this.morphoZipOutputStream;
                        Intrinsics.checkNotNull(zipArchiveOutputStream3);
                        byte[] byArray = morphoXml.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                        zipArchiveOutputStream3.write(byArray);
                        ZipArchiveOutputStream zipArchiveOutputStream4 = this.morphoZipOutputStream;
                        Intrinsics.checkNotNull(zipArchiveOutputStream4);
                        zipArchiveOutputStream4.closeArchiveEntry();
                        Unit $i$a$-synchronized-KorapXmlTool$processText$52 = Unit.INSTANCE;
                    }
                    wroteOne = true;
                }
            }
            if (this.parserToolBridges.get(Thread.currentThread().threadId()) != null) {
                String string = this.korapXmlDependencyOutput(depDir, docId).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String depXml = string;
                morphoEntry = docId;
                regex = new Regex("[_.]");
                object = "/";
                String depPath = regex.replace((CharSequence)morphoEntry, (String)object) + "/" + depDir + "/dependency.xml";
                ZipArchiveEntry depEntry = new ZipArchiveEntry(depPath);
                depEntry.setUnixMode(KorapXmlToolKt.getZIP_ENTRY_UNIX_MODE());
                ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream);
                object = zipArchiveOutputStream;
                synchronized (object) {
                    boolean bl = false;
                    ZipArchiveOutputStream zipArchiveOutputStream5 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream5);
                    zipArchiveOutputStream5.putArchiveEntry(depEntry);
                    ZipArchiveOutputStream zipArchiveOutputStream6 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream6);
                    byte[] byArray = depXml.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                    zipArchiveOutputStream6.write(byArray);
                    ZipArchiveOutputStream zipArchiveOutputStream7 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream7);
                    zipArchiveOutputStream7.closeArchiveEntry();
                    Unit unit = Unit.INSTANCE;
                }
                wroteOne = true;
            }
            StringsKt.clear(output);
            int n = written = wroteOne ? this.docsWrittenToZip.incrementAndGet() : this.docsWrittenToZip.get();
            if (!this.quiet) {
                ProgressBar progressBar = this.progressBar;
                if (progressBar != null) {
                    progressBar.step();
                }
            }
            if (this.totalDocsInInput.get() > 0) {
                double etaSec;
                int total = this.totalDocsInInput.get();
                double percent = (double)written * 100.0 / (double)total;
                double elapsed = (double)(System.currentTimeMillis() - this.annotationStartTime.get()) / 1000.0;
                double docsPerSec = elapsed > 0.0 ? (double)written / elapsed : 0.0;
                int remaining = total - written;
                double d = etaSec = docsPerSec > 0.0 ? (double)remaining / docsPerSec : 0.0;
                if (written % 10 == 0 || written == total) {
                    Locale locale = Locale.ROOT;
                    String string = "Progress: %d/%d (%.1f%%), %.1f docs/s, ETA %02d:%02d";
                    Object[] objectArray = new Object[]{written, total, percent, docsPerSec, (int)(etaSec / (double)60), (int)(etaSec % (double)60)};
                    String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    this.LOGGER.info(string3);
                }
            }
        }
        morphoDir = new ConcurrentHashMap[]{this.tokens, this.texts, this.sentences, this.morpho, this.fnames, this.metadata, this.extraFeatures};
        ConcurrentHashMap[] $this$forEach$iv = morphoDir;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConcurrentHashMap element$iv;
            ConcurrentHashMap map5 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (map5 == this.morpho) {
                Map<String, MorphoSpan> map6 = this.morpho.get(docId);
                if (map6 != null) {
                    map6.clear();
                }
            }
            map5.remove(docId);
        }
        if (this.annotationWorkerPool == null && this.outputFormat != OutputFormat.KORAPXML && !this.quiet) {
            ProgressBar progressBar = this.progressBar;
            if (progressBar != null) {
                progressBar.step();
            }
        }
        if (this.processedDocs.incrementAndGet() % 2000 == 0) {
            this.LOGGER.fine("Processed " + this.processedDocs.get() + " docs \u2013 requesting GC hint");
            System.gc();
        }
        if (this.memStatsInterval > 0 && (count2 = this.processedDocs.get()) % this.memStatsInterval == 0) {
            this.logMemoryStats(count2);
        }
    }

    private final String getMorphoFoundry() {
        Object object = this.taggerToolBridges.get(Thread.currentThread().threadId());
        if (object == null || (object = object.getFoundry()) == null) {
            object = "base";
        }
        return object;
    }

    private final void logMemoryStats(int count2) {
        try {
            Runtime rt = Runtime.getRuntime();
            long used = (rt.totalMemory() - rt.freeMemory()) / (long)0x100000;
            long total = rt.totalMemory() / (long)0x100000;
            long max = rt.maxMemory() / (long)0x100000;
            this.LOGGER.info("MEM-STATS docs=" + count2 + " usedMB=" + used + " totalMB=" + total + " maxMB=" + max + " maps{texts=" + this.texts.size() + ",tokens=" + this.tokens.size() + ",sentences=" + this.sentences.size() + ",morpho=" + this.morpho.size() + "}");
        }
        catch (Exception e) {
            this.LOGGER.warning("Failed to log memory stats: " + e.getMessage());
        }
    }

    private final StringBuilder korapXmlDependencyOutput(String foundry, String docId) {
        List sortedKeys;
        List list;
        DocumentBuilder documentBuilder = this.dBuilder;
        Intrinsics.checkNotNull(documentBuilder);
        Document document = documentBuilder.newDocument();
        Intrinsics.checkNotNullExpressionValue(document, "newDocument(...)");
        Document doc = document;
        Element layer = doc.createElement("layer");
        layer.setAttribute("xmlns", "http://ids-mannheim.de/ns/KorAP");
        layer.setAttribute("version", "KorAP-0.4");
        layer.setAttribute("docid", docId);
        doc.appendChild(layer);
        Element spanList = doc.createElement("spanList");
        layer.appendChild(spanList);
        int i = 0;
        int s = 0;
        int n = 0;
        Map<String, MorphoSpan> map2 = this.morpho.get(docId);
        if (map2 != null && (map2 = map2.keySet()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)((Object)map2);
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    String it = (String)a;
                    boolean bl = false;
                    String[] stringArray = new String[]{"-"};
                    Comparable comparable = Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(0)));
                    it = (String)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    stringArray = new String[]{"-"};
                    return ComparisonsKt.compareValues(comparable2, Integer.parseInt((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(0)));
                }
            });
        } else {
            list = null;
        }
        List list2 = sortedKeys = list;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int headInt;
                String spanString = (String)element$iv;
                boolean bl = false;
                Map<String, MorphoSpan> map3 = this.morpho.get(docId);
                MorphoSpan mfs = map3 != null ? map3.get(spanString) : null;
                String[] stringArray = new String[]{"-"};
                List offsets = StringsKt.split$default((CharSequence)spanString, stringArray, false, 0, 6, null);
                if (offsets.size() != 2) {
                    this.LOGGER.warning("Invalid span: " + spanString + " in " + docId);
                    continue;
                }
                int n2 = Integer.parseInt((String)offsets.get(0));
                Span[] spanArray = this.sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (n2 > ((Span)((Object[])spanArray)[s]).getTo()) {
                    ++s;
                    n = i;
                }
                ++i;
                MorphoSpan morphoSpan = mfs;
                Intrinsics.checkNotNull(morphoSpan);
                if (Intrinsics.areEqual(morphoSpan.getDeprel(), "_")) continue;
                Element spanNode = doc.createElement("span");
                spanNode.setAttribute("id", "s" + (s + 1) + "_n" + (i - n));
                spanNode.setAttribute("from", (String)offsets.get(0));
                spanNode.setAttribute("to", (String)offsets.get(1));
                Element rel = doc.createElement("rel");
                rel.setAttribute("label", mfs.getDeprel());
                Element innerSpan = doc.createElement("span");
                int n3 = headInt = Intrinsics.areEqual(mfs.getHead(), "_") ? 0 : Integer.parseInt(mfs.getHead()) - 1;
                if (headInt < 0) {
                    Span[] spanArray2 = this.sentences.get(docId);
                    Intrinsics.checkNotNull(spanArray2);
                    innerSpan.setAttribute("from", String.valueOf(((Span)((Object[])spanArray2)[s]).getFrom()));
                    Span[] spanArray3 = this.sentences.get(docId);
                    Intrinsics.checkNotNull(spanArray3);
                    innerSpan.setAttribute("to", String.valueOf(((Span)((Object[])spanArray3)[s]).getTo()));
                } else {
                    Map<String, MorphoSpan> map4 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map4);
                    if (headInt + n >= map4.size()) {
                        Map<String, MorphoSpan> map5 = this.morpho.get(docId);
                        Intrinsics.checkNotNull(map5);
                        this.LOGGER.warning("Head index out of bounds: " + (headInt + n) + " >= " + map5.size() + " in " + docId);
                        continue;
                    }
                    String destSpanString = (String)sortedKeys.get(headInt + n);
                    String[] stringArray2 = new String[]{"-"};
                    List destOffsets = StringsKt.split$default((CharSequence)destSpanString, stringArray2, false, 0, 6, null);
                    innerSpan.setAttribute("from", (String)destOffsets.get(0));
                    innerSpan.setAttribute("to", (String)destOffsets.get(1));
                }
                rel.appendChild(innerSpan);
                spanNode.appendChild(rel);
                spanList.appendChild(spanNode);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(domSource, streamResult);
        return new StringBuilder(streamResult.getWriter().toString());
    }

    private final StringBuilder korapXmlOutput(String foundry, String docId) {
        return this.parserName != null ? this.korapXmlDependencyOutput(foundry, docId) : this.korapXmlMorphoOutput(foundry, docId);
    }

    private final StringBuilder korapXmlMorphoOutput(String foundry, String docId) {
        DocumentBuilder documentBuilder = this.dBuilder;
        Intrinsics.checkNotNull(documentBuilder);
        Document document = documentBuilder.newDocument();
        Intrinsics.checkNotNullExpressionValue(document, "newDocument(...)");
        Document doc = document;
        Element layer = doc.createElement("layer");
        layer.setAttribute("xmlns", "http://ids-mannheim.de/ns/KorAP");
        layer.setAttribute("version", "KorAP-0.4");
        layer.setAttribute("docid", docId);
        doc.appendChild(layer);
        Element spanList = doc.createElement("spanList");
        layer.appendChild(spanList);
        int i = 0;
        Map<String, MorphoSpan> map2 = this.morpho.get(docId);
        if (map2 != null) {
            Map<String, MorphoSpan> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, MorphoSpan>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object innerF;
                Map.Entry<String, MorphoSpan> element$iv;
                Map.Entry<String, MorphoSpan> entry = element$iv = iterator2.next();
                boolean bl = false;
                String spanString = entry.getKey();
                MorphoSpan mfs = entry.getValue();
                String[] stringArray = new String[]{"-"};
                List offsets = StringsKt.split$default((CharSequence)spanString, stringArray, false, 0, 6, null);
                Element spanNode = doc.createElement("span");
                spanNode.setAttribute("id", "t_" + ++i);
                spanNode.setAttribute("from", (String)offsets.get(0));
                spanNode.setAttribute("to", (String)offsets.get(1));
                Element fs = doc.createElement("fs");
                fs.setAttribute("type", "lex");
                fs.setAttribute("xmlns", "http://www.tei-c.org/ns/1.0");
                spanNode.appendChild(fs);
                Element f = doc.createElement("f");
                f.setAttribute("name", "lex");
                fs.appendChild(f);
                Element innerFs = doc.createElement("fs");
                f.appendChild(innerFs);
                if (!Intrinsics.areEqual(mfs.getLemma(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "lemma");
                    innerF.setTextContent(mfs.getLemma());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getUpos(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "upos");
                    innerF.setTextContent(mfs.getUpos());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getXpos(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "pos");
                    innerF.setTextContent(mfs.getXpos());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getFeats(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "msd");
                    innerF.setTextContent(mfs.getFeats());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getMisc(), "_")) {
                    String string = mfs.getMisc();
                    Intrinsics.checkNotNull(string);
                    innerF = string;
                    if (new Regex("^[0-9.]+$").matches((CharSequence)innerF)) {
                        innerF = doc.createElement("f");
                        innerF.setAttribute("name", "certainty");
                        innerF.setTextContent(mfs.getMisc());
                        innerFs.appendChild((Node)innerF);
                    }
                }
                spanList.appendChild(spanNode);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(domSource, streamResult);
        return new StringBuilder(streamResult.getWriter().toString());
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder conlluOutput(String foundry, String docId) {
        int token_index = 0;
        int real_token_index = 0;
        int sentence_index = 0;
        StringBuilder output = null;
        Span[] sentencesArr = this.sentences.get(docId);
        Span[] tokensArr = this.tokens.get(docId);
        StringBuilder stringBuilder = new StringBuilder("# foundry = " + foundry + "\n# filename = " + this.fnames.get(docId) + "\n# text_id = " + docId + "\n").append(this.tokenOffsetsInSentence(this.sentences, docId, sentence_index, real_token_index, this.tokens));
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
        output = stringBuilder;
        if (!((Collection)this.extractMetadataRegex).isEmpty()) {
            Object object = this.metadata.get(docId);
            if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", (CharSequence)"# metadata=", (CharSequence)"\n", 0, null, null, 56, null)) == null) {
                object = "";
            }
            output.append((String)object);
        }
        int previousSpanStart = 0;
        if (tokensArr == null || tokensArr.length == 0) {
            return output;
        }
        Map offsetToIndex = new LinkedHashMap();
        Span[] $this$forEachIndexed$iv = tokensArr;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        int n = $this$forEachIndexed$iv.length;
        for (int i = 0; i < n; ++i) {
            void span;
            Span item$iv = $this$forEachIndexed$iv[i];
            int n2 = index$iv++;
            Span span2 = item$iv;
            int index = n2;
            boolean bl = false;
            offsetToIndex.put(span.getFrom() + "-" + span.getTo(), index + 1);
        }
        Map<String, MorphoSpan> map2 = this.morpho.get(docId);
        if (map2 == null || (map2 = MapsKt.toMap(map2)) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map<String, MorphoSpan> morphoSnapshot = map2;
        NonBmpString textVal = this.texts.get(docId);
        Span[] $this$forEach$iv = tokensArr;
        boolean $i$f$forEach = false;
        int n3 = $this$forEach$iv.length;
        for (n = 0; n < n3; ++n) {
            String tokenText;
            Span element$iv;
            Span span = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            ++token_index;
            if (sentencesArr != null && (sentence_index >= sentencesArr.length || span.getFrom() >= sentencesArr[sentence_index].getTo())) {
                output.append("\n");
                token_index = 1;
                output.append(this.tokenOffsetsInSentence(this.sentences, docId, ++sentence_index, real_token_index, this.tokens));
            }
            if (((CharSequence)this.extractAttributesRegex).length() > 0 && this.extraFeatures.get(docId) != null) {
                int n4 = span.getFrom() + 1;
                for (int i = previousSpanStart; i < n4; ++i) {
                    Map<String, String> map3 = this.extraFeatures.get(docId);
                    boolean bl2 = map3 != null ? map3.containsKey(String.valueOf(i)) : false;
                    if (!bl2) continue;
                    Map<String, String> map4 = this.extraFeatures.get(docId);
                    Intrinsics.checkNotNull(map4);
                    output.append(map4.get(String.valueOf(i)));
                    Map<String, String> map5 = this.extraFeatures.get(docId);
                    Intrinsics.checkNotNull(map5);
                    map5.remove(String.valueOf(i));
                }
                previousSpanStart = span.getFrom() + 1;
            }
            if (textVal != null) {
                int safeFrom = RangesKt.coerceIn(span.getFrom(), 0, textVal.length());
                int safeTo = RangesKt.coerceIn(span.getTo(), safeFrom, textVal.length());
                v8 = ((Object)((CharSequence)textVal).subSequence(safeFrom, safeTo)).toString();
            } else {
                v8 = tokenText = "_";
            }
            if (StringsKt.isBlank(tokenText)) {
                this.LOGGER.fine("Replacing empty/blank token at offset " + span.getFrom() + "-" + span.getTo() + " in document " + docId + " with underscore");
                tokenText = "_";
            }
            if (morphoSnapshot.containsKey(span.getFrom() + "-" + span.getTo())) {
                MorphoSpan mfs = morphoSnapshot.get(span.getFrom() + "-" + span.getTo());
                if (mfs != null) {
                    StringBuilder stringBuilder2;
                    Object object;
                    if (this.annotationWorkerPool != null && this.outputFormat == OutputFormat.KORAPXML) {
                        String existing;
                        String string = mfs.getMisc();
                        if (string == null) {
                            string = "_";
                        }
                        object = Intrinsics.areEqual(existing = string, "_") ? "Offset=" + span.getFrom() + "-" + span.getTo() : existing + "|Offset=" + span.getFrom() + "-" + span.getTo();
                    } else {
                        object = mfs.getMisc();
                        if (object == null) {
                            object = "_";
                        }
                    }
                    String miscWithOffset = object;
                    try {
                        String string;
                        String string2;
                        String string3;
                        String string4;
                        String string5 = mfs.getLemma();
                        if (string5 == null) {
                            string5 = "_";
                        }
                        if ((string4 = mfs.getUpos()) == null) {
                            string4 = "_";
                        }
                        if ((string3 = mfs.getXpos()) == null) {
                            string3 = "_";
                        }
                        if ((string2 = mfs.getFeats()) == null) {
                            string2 = "_";
                        }
                        String string6 = KorapXmlTool.conlluOutput$resolveHeadValue(offsetToIndex, mfs.getHead());
                        String string7 = mfs.getDeprel();
                        if (string7 == null) {
                            string7 = "_";
                        }
                        if ((string = mfs.getDeps()) == null) {
                            string = "_";
                        }
                        stringBuilder2 = output.append(this.printConlluToken(token_index, tokenText, string5, string4, string3, string2, string6, string7, string, miscWithOffset, this.columns));
                    }
                    catch (NullPointerException e) {
                        this.LOGGER.warning("NPE processing morpho for " + docId + " at " + span.getFrom() + "-" + span.getTo() + ": " + e.getMessage());
                        String miscWithOffset2 = this.annotationWorkerPool != null && this.outputFormat == OutputFormat.KORAPXML ? "Offset=" + span.getFrom() + "-" + span.getTo() : "_";
                        stringBuilder2 = output.append(KorapXmlTool.printConlluToken$default(this, token_index, tokenText, null, null, null, null, null, null, null, miscWithOffset2, this.columns, 508, null));
                    }
                    v18 = stringBuilder2;
                } else {
                    String miscWithOffset = this.annotationWorkerPool != null && this.outputFormat == OutputFormat.KORAPXML ? "Offset=" + span.getFrom() + "-" + span.getTo() : "_";
                    v18 = output.append(KorapXmlTool.printConlluToken$default(this, token_index, tokenText, null, null, null, null, null, null, null, miscWithOffset, this.columns, 508, null));
                }
            } else {
                String miscWithOffset = this.annotationWorkerPool != null && this.outputFormat == OutputFormat.KORAPXML ? "Offset=" + span.getFrom() + "-" + span.getTo() : "_";
                v18 = output.append(KorapXmlTool.printConlluToken$default(this, token_index, tokenText, null, null, null, null, null, null, null, miscWithOffset, this.columns, 508, null));
            }
            ++real_token_index;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder lmTrainingOutput(String docId) {
        StringBuilder output;
        block25: {
            int sentence_index;
            int real_token_index;
            int token_index;
            block21: {
                block22: {
                    token_index = 0;
                    real_token_index = 0;
                    sentence_index = 0;
                    output = new StringBuilder();
                    if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                        Object object = this.metadata.get(docId);
                        if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                            object = "";
                        }
                        output.append((String)object);
                    }
                    if (this.texts.get(docId) != null) break block21;
                    Span[] spanArray = this.tokens.get(docId);
                    if (spanArray == null) break block22;
                    Span[] $this$forEach$iv = spanArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        String[] stringArray;
                        StringBuilder stringBuilder;
                        block24: {
                            block23: {
                                void it;
                                String string2;
                                Span element$iv;
                                Span span = element$iv = $this$forEach$iv[i];
                                boolean bl = false;
                                String key = span.getFrom() + "-" + span.getTo();
                                Map<String, MorphoSpan> map2 = this.morpho.get(docId);
                                String lemmaVal = map2 != null && (map2 = map2.get(key)) != null ? ((MorphoSpan)((Object)map2)).getLemma() : null;
                                stringBuilder = output;
                                String[] stringArray2 = stringArray = new String[2];
                                int n2 = 0;
                                string = lemmaVal;
                                if (string == null) break block23;
                                String string3 = string2 = string;
                                int n3 = n2;
                                String[] stringArray3 = stringArray2;
                                StringBuilder stringBuilder2 = stringBuilder;
                                boolean bl2 = false;
                                boolean bl3 = !Intrinsics.areEqual(it, "_");
                                stringBuilder = stringBuilder2;
                                stringArray2 = stringArray3;
                                n2 = n3;
                                string = bl3 ? string2 : null;
                                if (string != null) break block24;
                            }
                            string = "_";
                        }
                        stringArray2[n2] = string;
                        stringArray[1] = " ";
                        StringsKt.append(stringBuilder, stringArray);
                    }
                }
                if (((CharSequence)output).length() > 0) {
                    output.deleteCharAt(output.length() - 1);
                }
                return output;
            }
            Span[] spanArray = this.tokens.get(docId);
            if (spanArray == null) break block25;
            Span[] $this$forEach$iv = spanArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Span span;
                block26: {
                    block27: {
                        Span element$iv;
                        span = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        ++token_index;
                        if (this.sentences.get(docId) == null) break block26;
                        Span[] spanArray2 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray2);
                        if (sentence_index >= ((Object[])spanArray2).length) break block27;
                        int n4 = span.getFrom();
                        Span[] spanArray3 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray3);
                        if (n4 < spanArray3[sentence_index].getTo()) break block26;
                    }
                    if (((CharSequence)output).length() > 0) {
                        output.setCharAt(output.length() - 1, '\n');
                    } else {
                        output.append("\n");
                    }
                    if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                        Span[] spanArray4 = this.tokens.get(docId);
                        Intrinsics.checkNotNull(spanArray4);
                        if (real_token_index < ((Object[])spanArray4).length - 1) {
                            Object object = this.metadata.get(docId);
                            if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                                object = "";
                            }
                            output.append((String)object);
                        }
                    }
                    ++sentence_index;
                }
                int n5 = span.getFrom();
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                int safeFrom = RangesKt.coerceIn(n5, 0, nonBmpString.length());
                int n6 = span.getTo();
                NonBmpString nonBmpString2 = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString2);
                int safeTo = RangesKt.coerceIn(n6, safeFrom, nonBmpString2.length());
                if (this.useLemma && this.morpho.get(docId) != null) {
                    String lemmaVal;
                    String key = span.getFrom() + "-" + span.getTo();
                    Map<String, MorphoSpan> map3 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map3);
                    MorphoSpan morphoSpan = map3.get(key);
                    String string = lemmaVal = morphoSpan != null ? morphoSpan.getLemma() : null;
                    if (lemmaVal != null && !Intrinsics.areEqual(lemmaVal, "_")) {
                        v20 = output.append(lemmaVal).append(' ');
                    } else {
                        NonBmpString nonBmpString3 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString3);
                        nonBmpString3.appendRangeTo(output, safeFrom, safeTo);
                        v20 = output.append(' ');
                    }
                } else {
                    NonBmpString nonBmpString4 = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString4);
                    nonBmpString4.appendRangeTo(output, safeFrom, safeTo);
                    v20 = output.append(' ');
                }
                ++real_token_index;
            }
        }
        if (((CharSequence)output).length() > 0) {
            output.deleteCharAt(output.length() - 1);
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder nowOutput(String docId) {
        StringBuilder output;
        block25: {
            int sentence_index;
            int real_token_index;
            int token_index;
            block19: {
                block20: {
                    token_index = 0;
                    real_token_index = 0;
                    sentence_index = 0;
                    output = new StringBuilder();
                    output.append("@@" + docId + " ");
                    if (this.texts.get(docId) != null) break block19;
                    Span[] spanArray = this.tokens.get(docId);
                    if (spanArray == null) break block20;
                    Span[] $this$forEach$iv = spanArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        String[] stringArray;
                        StringBuilder stringBuilder;
                        block24: {
                            block23: {
                                void it;
                                String string2;
                                Span span;
                                block21: {
                                    block22: {
                                        Span element$iv;
                                        span = element$iv = $this$forEach$iv[i];
                                        boolean bl = false;
                                        if (this.sentences.get(docId) == null) break block21;
                                        Span[] spanArray2 = this.sentences.get(docId);
                                        Intrinsics.checkNotNull(spanArray2);
                                        if (sentence_index >= ((Object[])spanArray2).length) break block22;
                                        int n2 = span.getFrom();
                                        Span[] spanArray3 = this.sentences.get(docId);
                                        Intrinsics.checkNotNull(spanArray3);
                                        if (n2 < spanArray3[sentence_index].getTo()) break block21;
                                    }
                                    if (((CharSequence)output).length() > 0 && !StringsKt.endsWith$default((CharSequence)output, (CharSequence)("@@" + docId + " "), false, 2, null)) {
                                        output.append(" <p> ");
                                    }
                                    ++sentence_index;
                                }
                                String key = span.getFrom() + "-" + span.getTo();
                                Map<String, MorphoSpan> map2 = this.morpho.get(docId);
                                String lemmaVal = map2 != null && (map2 = map2.get(key)) != null ? ((MorphoSpan)((Object)map2)).getLemma() : null;
                                stringBuilder = output;
                                String[] stringArray2 = stringArray = new String[2];
                                int n3 = 0;
                                string = lemmaVal;
                                if (string == null) break block23;
                                String string3 = string2 = string;
                                int n4 = n3;
                                String[] stringArray3 = stringArray2;
                                StringBuilder stringBuilder2 = stringBuilder;
                                boolean bl = false;
                                boolean bl2 = !Intrinsics.areEqual(it, "_");
                                stringBuilder = stringBuilder2;
                                stringArray2 = stringArray3;
                                n3 = n4;
                                string = bl2 ? string2 : null;
                                if (string != null) break block24;
                            }
                            string = "_";
                        }
                        stringArray2[n3] = string;
                        stringArray[1] = " ";
                        StringsKt.append(stringBuilder, stringArray);
                    }
                }
                if (((CharSequence)output).length() > 0 && StringsKt.endsWith$default((CharSequence)output, (CharSequence)" ", false, 2, null)) {
                    output.deleteCharAt(output.length() - 1);
                }
                return output;
            }
            Span[] spanArray = this.tokens.get(docId);
            if (spanArray == null) break block25;
            Span[] $this$forEach$iv = spanArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Span span;
                block26: {
                    block27: {
                        Span element$iv;
                        span = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        ++token_index;
                        if (this.sentences.get(docId) == null) break block26;
                        Span[] spanArray4 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray4);
                        if (sentence_index >= ((Object[])spanArray4).length) break block27;
                        int n5 = span.getFrom();
                        Span[] spanArray5 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray5);
                        if (n5 < spanArray5[sentence_index].getTo()) break block26;
                    }
                    if (((CharSequence)output).length() > 0 && !StringsKt.endsWith$default((CharSequence)output, (CharSequence)("@@" + docId + " "), false, 2, null)) {
                        output.append(" <p> ");
                    }
                    ++sentence_index;
                }
                int n6 = span.getFrom();
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                int safeFrom = RangesKt.coerceIn(n6, 0, nonBmpString.length());
                int n7 = span.getTo();
                NonBmpString nonBmpString2 = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString2);
                int safeTo = RangesKt.coerceIn(n7, safeFrom, nonBmpString2.length());
                if (this.useLemma && this.morpho.get(docId) != null) {
                    String lemmaVal;
                    String key = span.getFrom() + "-" + span.getTo();
                    Map<String, MorphoSpan> map3 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map3);
                    MorphoSpan morphoSpan = map3.get(key);
                    String string = lemmaVal = morphoSpan != null ? morphoSpan.getLemma() : null;
                    if (lemmaVal != null && !Intrinsics.areEqual(lemmaVal, "_")) {
                        v20 = output.append(lemmaVal).append(' ');
                    } else {
                        NonBmpString nonBmpString3 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString3);
                        nonBmpString3.appendRangeTo(output, safeFrom, safeTo);
                        v20 = output.append(' ');
                    }
                } else {
                    NonBmpString nonBmpString4 = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString4);
                    nonBmpString4.appendRangeTo(output, safeFrom, safeTo);
                    v20 = output.append(' ');
                }
                ++real_token_index;
            }
        }
        if (((CharSequence)output).length() > 0 && StringsKt.endsWith$default((CharSequence)output, (CharSequence)" ", false, 2, null)) {
            output.deleteCharAt(output.length() - 1);
        }
        return output;
    }

    private final String printConlluToken(int token_index, String token, String lemma, String upos, String xpos, String feats, String head, String deprel, String deps, String misc, int columns) {
        String myUpos = this.COMPATIBILITY_MODE && Intrinsics.areEqual(upos, "_") ? xpos : upos;
        return switch (columns) {
            case 1 -> token + "\n";
            case 10 -> token_index + "\t" + token + "\t" + lemma + "\t" + myUpos + "\t" + xpos + "\t" + feats + "\t" + head + "\t" + deprel + "\t" + deps + "\t" + misc + this.tokenSeparator;
            default -> {
                String[] var14_13 = new String[]{String.valueOf(token_index), token, lemma, myUpos, xpos, feats, head, deprel, deps, misc};
                List<String> fields = CollectionsKt.listOf(var14_13);
                yield CollectionsKt.joinToString$default(fields.subList(0, Math.min(columns, 10)), "\t", null, this.tokenSeparator, 0, null, null, 58, null);
            }
        };
    }

    static /* synthetic */ String printConlluToken$default(KorapXmlTool korapXmlTool, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = "_";
        }
        if ((n3 & 8) != 0) {
            string3 = "_";
        }
        if ((n3 & 0x10) != 0) {
            string4 = "_";
        }
        if ((n3 & 0x20) != 0) {
            string5 = "_";
        }
        if ((n3 & 0x40) != 0) {
            string6 = "_";
        }
        if ((n3 & 0x80) != 0) {
            string7 = "_";
        }
        if ((n3 & 0x100) != 0) {
            string8 = "_";
        }
        if ((n3 & 0x200) != 0) {
            string9 = "_";
        }
        if ((n3 & 0x400) != 0) {
            n2 = 10;
        }
        return korapXmlTool.printConlluToken(n, string, string2, string3, string4, string5, string6, string7, string8, string9, n2);
    }

    private final String tokenOffsetsInSentence(ConcurrentHashMap<String, Span[]> sentences, String docId, int sentence_index, int token_index, ConcurrentHashMap<String, Span[]> tokens) {
        Span[] toks;
        Span[] sentArr;
        block8: {
            block7: {
                Span[] spanArray = sentences.get(docId);
                if (spanArray == null) {
                    return "";
                }
                sentArr = spanArray;
                if (!(0 <= sentence_index ? sentence_index < sentArr.length : false)) {
                    return "";
                }
                Span[] spanArray2 = tokens.get(docId);
                if (spanArray2 == null) {
                    return "";
                }
                toks = spanArray2;
                if (toks.length == 0) break block7;
                if (0 <= token_index ? token_index < toks.length : false) break block8;
            }
            return "";
        }
        int sentenceEndOffset = sentArr[sentence_index].getTo();
        StringBuilder start_offsets_string = new StringBuilder();
        StringBuilder end_offsets_string = new StringBuilder();
        for (int i = token_index; i < toks.length && toks[i].getTo() <= sentenceEndOffset; ++i) {
            start_offsets_string.append(" ").append(toks[i].getFrom());
            end_offsets_string.append(" ").append(toks[i].getTo());
        }
        String string = "# start_offsets = " + toks[token_index].getFrom() + (CharSequence)start_offsets_string + "\n" + "# end_offsets = " + sentenceEndOffset + (CharSequence)end_offsets_string + "\n";
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Span[] extractSpans(NodeList spans) {
        ArrayList list = new ArrayList();
        IntStream.range(0, spans.getLength()).forEach(arg_0 -> KorapXmlTool.extractSpans$lambda$0(spans, this, list, arg_0));
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Span[0]);
    }

    private final Map<String, MorphoSpan> extractMorphoSpans(NodeList fsSpans) {
        Regex UNKNOWN = new Regex("(UNKNOWN|<unknown>)");
        Map res = new HashMap();
        IntStream.range(0, fsSpans.getLength()).mapToObj(fsSpans::item).filter(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$1(KorapXmlTool::extractMorphoSpans$lambda$0, arg_0)).forEach(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$3(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$2(res, UNKNOWN, arg_0), arg_0));
        return res;
    }

    private final Map<String, MorphoSpan> extractDependencySpans(NodeList depSpans) {
        Map res = new HashMap();
        IntStream.range(0, depSpans.getLength()).mapToObj(depSpans::item).filter(arg_0 -> KorapXmlTool.extractDependencySpans$lambda$1(KorapXmlTool::extractDependencySpans$lambda$0, arg_0)).forEach(arg_0 -> KorapXmlTool.extractDependencySpans$lambda$3(arg_0 -> KorapXmlTool.extractDependencySpans$lambda$2(res, arg_0), arg_0));
        return res;
    }

    private final Span[] extractSentenceSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXmlTool.extractSentenceSpans$lambda$1(KorapXmlTool::extractSentenceSpans$lambda$0, arg_0)).map(arg_0 -> KorapXmlTool.extractSentenceSpans$lambda$3(KorapXmlTool::extractSentenceSpans$lambda$2, arg_0)).toArray(KorapXmlTool::extractSentenceSpans$lambda$4);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, String> extractMiscSpans(NodeList spans) {
        Map miscLocal = new HashMap();
        IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$1(KorapXmlTool::extractMiscSpans$lambda$0, arg_0)).forEach(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$3(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$2(miscLocal, this, arg_0), arg_0));
        return miscLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseAndWriteAnnotatedConllu(String annotatedConllu, AnnotationWorkerPool.AnnotationTask task) {
        boolean bl;
        Object object;
        Span[] destination$iv$iv;
        boolean hasDependencies;
        String tempDocId;
        Map morphoSpans;
        String foundry;
        String docId;
        block40: {
            Object[] objectArray;
            this.LOGGER.fine("parseAndWriteAnnotatedConllu called with " + annotatedConllu.length() + " chars, task=" + task);
            AnnotationWorkerPool.AnnotationTask annotationTask = task;
            docId = annotationTask != null ? annotationTask.getDocId() : null;
            Object object2 = task;
            if (object2 == null || (object2 = ((AnnotationWorkerPool.AnnotationTask)object2).getEntryPath()) == null || (object2 = StringsKt.split$default((CharSequence)object2, (String[])(objectArray = new String[]{"|"}), false, 0, 6, null)) == null) {
                objectArray = new Void[]{null, null};
                object2 = CollectionsKt.listOf(objectArray);
            }
            List entryPathAndFoundry = object2;
            String entryPath = (String)CollectionsKt.getOrNull(entryPathAndFoundry, 0);
            String string = (String)CollectionsKt.getOrNull(entryPathAndFoundry, 1);
            if (string == null) {
                string = foundry = "base";
            }
            if (docId == null || entryPath == null) {
                this.LOGGER.fine("Missing metadata from task! docId=" + docId + ", entryPath=" + entryPath + ", task=" + task);
                return;
            }
            morphoSpans = new LinkedHashMap();
            List<String> lines = StringsKt.lines(annotatedConllu);
            Object currentStartOffsets = null;
            List currentEndOffsets = null;
            int tokenIndexInSentence = 0;
            for (String line : lines) {
                String misc;
                List fields;
                Object allOffsets;
                Integer it$iv$iv;
                boolean bl2;
                String it;
                boolean bl3;
                Object element$iv$iv;
                Object $this$forEach$iv$iv$iv;
                Object $this$mapNotNullTo$iv$iv22;
                Collection destination$iv$iv2;
                Object $this$mapNotNull$iv;
                String offsetsStr;
                if (StringsKt.startsWith$default(line, "# start_offsets =", false, 2, null)) {
                    String string2 = line.substring(17);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    offsetsStr = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    Object object3 = offsetsStr;
                    Regex regex = new Regex("\\s+");
                    int n = 0;
                    object3 = regex.split((CharSequence)object3, n);
                    boolean $i$f$mapNotNull = false;
                    CharSequence charSequence = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = iterator2.next();
                        bl3 = false;
                        it = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (StringsKt.toIntOrNull(it) == null) continue;
                        bl2 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    allOffsets = (List)destination$iv$iv2;
                    currentStartOffsets = allOffsets.size() > 1 ? CollectionsKt.drop((Iterable)allOffsets, 1) : allOffsets;
                    tokenIndexInSentence = 0;
                    continue;
                }
                if (StringsKt.startsWith$default(line, "# end_offsets =", false, 2, null)) {
                    String string3 = line.substring(15);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    offsetsStr = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    $this$mapNotNull$iv = offsetsStr;
                    Regex $i$f$mapNotNull = new Regex("\\s+");
                    int $this$mapNotNullTo$iv$iv22 = 0;
                    $this$mapNotNull$iv = $i$f$mapNotNull.split((CharSequence)$this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
                    boolean $i$f$mapNotNull2 = false;
                    $this$mapNotNullTo$iv$iv22 = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = iterator3.next();
                        bl3 = false;
                        it = (String)element$iv$iv;
                        boolean bl5 = false;
                        if (StringsKt.toIntOrNull(it) == null) continue;
                        bl2 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    allOffsets = (List)destination$iv$iv2;
                    currentEndOffsets = allOffsets.size() > 1 ? CollectionsKt.drop((Iterable)allOffsets, 1) : CollectionsKt.emptyList();
                    continue;
                }
                if (((CharSequence)line).length() == 0) {
                    currentStartOffsets = null;
                    currentEndOffsets = null;
                    tokenIndexInSentence = 0;
                    continue;
                }
                if (StringsKt.startsWith$default(line, "#", false, 2, null) || (fields = StringsKt.split$default((CharSequence)line, (String[])(allOffsets = new String[]{"\t"}), false, 0, 6, null)).size() < 10) continue;
                String lemma = fields.size() > 2 ? (String)fields.get(2) : "_";
                String upos = fields.size() > 3 ? (String)fields.get(3) : "_";
                String xpos = fields.size() > 4 ? (String)fields.get(4) : "_";
                String feats = fields.size() > 5 ? (String)fields.get(5) : "_";
                String head = fields.size() > 6 ? (String)fields.get(6) : "_";
                String deprel = fields.size() > 7 ? (String)fields.get(7) : "_";
                String deps = fields.size() > 8 ? (String)fields.get(8) : "_";
                String string4 = misc = fields.size() > 9 ? (String)fields.get(9) : "_";
                if (currentStartOffsets == null || currentEndOffsets == null || tokenIndexInSentence >= currentStartOffsets.size() || tokenIndexInSentence >= currentEndOffsets.size()) continue;
                int spanFrom = ((Number)currentStartOffsets.get(tokenIndexInSentence)).intValue();
                int spanTo = ((Number)currentEndOffsets.get(tokenIndexInSentence)).intValue();
                String spanKey = spanFrom + "-" + spanTo;
                morphoSpans.put(spanKey, new MorphoSpan(lemma, upos, xpos, feats, head, deprel, deps, misc));
                ++tokenIndexInSentence;
            }
            if (morphoSpans.isEmpty()) {
                this.LOGGER.warning("No morpho spans found in annotated output for " + docId + ", skipping");
                return;
            }
            if (this.morphoZipOutputStream == null) {
                this.LOGGER.severe("morphoZipOutputStream is null! Cannot write to ZIP. This should have been initialized in processZipFile.");
                return;
            }
            if (this.dBuilder == null) {
                DocumentBuilderFactory documentBuilderFactory = this.dbFactory = DocumentBuilderFactory.newInstance();
                Intrinsics.checkNotNull(documentBuilderFactory);
                this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            tempDocId = "_temp_annotated_" + docId;
            ((Map)this.morpho).put(tempDocId, morphoSpans);
            Iterable $this$any$iv = morphoSpans.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v7 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MorphoSpan span = (MorphoSpan)element$iv;
                    boolean bl6 = false;
                    if (!(span.getHead() != null && !Intrinsics.areEqual(span.getHead(), "_") && span.getDeprel() != null && !Intrinsics.areEqual(span.getDeprel(), "_"))) continue;
                    v7 = true;
                    break block40;
                }
                v7 = hasDependencies = false;
            }
        }
        if (hasDependencies && !morphoSpans.isEmpty()) {
            Object object4;
            Object object5;
            Map $this$mapTo$iv$iv;
            Iterable $this$map$iv = morphoSpans.keySet();
            boolean $i$f$map = false;
            Iterable element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator deprel = $this$mapTo$iv$iv.iterator();
            while (deprel.hasNext()) {
                void key;
                Object item$iv$iv = deprel.next();
                String misc = (String)item$iv$iv;
                Span[] spanArray = destination$iv$iv;
                boolean bl7 = false;
                String[] stringArray = new String[]{"-"};
                List parts = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
                spanArray.add(new Pair<Integer, Integer>(Integer.parseInt((String)parts.get(0)), Integer.parseInt((String)parts.get(1))));
            }
            List allOffsets = (List)destination$iv$iv;
            if (!(destination$iv$iv = ((Iterable)allOffsets).iterator()).hasNext()) {
                object5 = null;
            } else {
                Object it = (Pair)destination$iv$iv.next();
                boolean bl8 = false;
                it = ((Number)((Pair)it).getFirst()).intValue();
                while (destination$iv$iv.hasNext()) {
                    Object it2 = (Pair)destination$iv$iv.next();
                    $i$a$-minOfOrNull-KorapXmlTool$parseAndWriteAnnotatedConllu$minOffset$1 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((Number)((Pair)it2).getFirst()).intValue())) <= 0) continue;
                    it = it2;
                }
                object5 = it;
            }
            Integer n = (Integer)object5;
            int minOffset = n != null ? n : 0;
            Iterator it = ((Iterable)allOffsets).iterator();
            if (!it.hasNext()) {
                object4 = null;
            } else {
                Object it3 = (Pair)it.next();
                boolean bl9 = false;
                it3 = ((Number)((Pair)it3).getSecond()).intValue();
                while (it.hasNext()) {
                    Object it4 = (Pair)it.next();
                    $i$a$-maxOfOrNull-KorapXmlTool$parseAndWriteAnnotatedConllu$maxOffset$1 = false;
                    if (it3.compareTo(it4 = (Comparable)Integer.valueOf(((Number)((Pair)it4).getSecond()).intValue())) >= 0) continue;
                    it3 = it4;
                }
                object4 = it3;
            }
            Integer n2 = (Integer)object4;
            int maxOffset = n2 != null ? n2 : 0;
            $this$mapTo$iv$iv = this.sentences;
            destination$iv$iv = new Span[]{new Span(minOffset, maxOffset)};
            $this$mapTo$iv$iv.put(tempDocId, destination$iv$iv);
        }
        try {
            StringBuilder morphoXmlOutput = this.korapXmlMorphoOutput(foundry, tempDocId);
            String string = morphoXmlOutput.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String fixedMorphoXml = StringsKt.replace$default(string, "docid=\"" + tempDocId + "\"", "docid=\"" + docId + "\"", false, 4, null);
            CharSequence $this$mapTo$iv$iv = docId;
            destination$iv$iv = new Regex("[_.]");
            Object it = "/";
            String morphoEntryPath = destination$iv$iv.replace($this$mapTo$iv$iv, (String)it) + "/" + foundry + "/morpho.xml";
            ZipArchiveEntry morphoZipEntry = new ZipArchiveEntry(morphoEntryPath);
            morphoZipEntry.setUnixMode(KorapXmlToolKt.getZIP_ENTRY_UNIX_MODE());
            ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
            Intrinsics.checkNotNull(zipArchiveOutputStream);
            it = zipArchiveOutputStream;
            synchronized (it) {
                boolean $i$a$-synchronized-KorapXmlTool$parseAndWriteAnnotatedConllu$22 = false;
                ZipArchiveOutputStream zipArchiveOutputStream2 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream2);
                zipArchiveOutputStream2.putArchiveEntry(morphoZipEntry);
                ZipArchiveOutputStream zipArchiveOutputStream3 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream3);
                byte[] byArray = fixedMorphoXml.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                zipArchiveOutputStream3.write(byArray);
                ZipArchiveOutputStream zipArchiveOutputStream4 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream4);
                zipArchiveOutputStream4.closeArchiveEntry();
                Unit $i$a$-synchronized-KorapXmlTool$parseAndWriteAnnotatedConllu$22 = Unit.INSTANCE;
            }
            int written = this.docsWrittenToZip.incrementAndGet();
            if (!this.quiet) {
                ProgressBar progressBar = this.progressBar;
                ProgressBar progressBar2 = progressBar != null ? progressBar.step() : null;
            }
        }
        catch (Exception e) {
            this.LOGGER.severe("ERROR generating/writing morpho.xml: " + e.getMessage());
            e.printStackTrace();
        }
        if ((object = this.morpho.get(tempDocId)) != null && (object = object.values()) != null) {
            boolean bl10;
            block41: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl10 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MorphoSpan it = (MorphoSpan)element$iv;
                        boolean bl11 = false;
                        if (!(it.getHead() != null && !Intrinsics.areEqual(it.getHead(), "_") && it.getDeprel() != null && !Intrinsics.areEqual(it.getDeprel(), "_"))) continue;
                        bl10 = true;
                        break block41;
                    }
                    bl10 = false;
                }
            }
            bl = bl10;
        } else {
            bl = false;
        }
        if (bl) {
            try {
                StringBuilder dependencyXmlOutput = this.korapXmlDependencyOutput(foundry, tempDocId);
                String string = dependencyXmlOutput.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String fixedDependencyXml = StringsKt.replace$default(string, "docid=\"" + tempDocId + "\"", "docid=\"" + docId + "\"", false, 4, null);
                CharSequence $i$f$any = docId;
                Regex regex = new Regex("[_.]");
                Object object6 = "/";
                String dependencyEntryPath = regex.replace($i$f$any, (String)object6) + "/" + foundry + "/dependency.xml";
                ZipArchiveEntry dependencyZipEntry = new ZipArchiveEntry(dependencyEntryPath);
                dependencyZipEntry.setUnixMode(KorapXmlToolKt.getZIP_ENTRY_UNIX_MODE());
                ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream);
                object6 = zipArchiveOutputStream;
                synchronized (object6) {
                    boolean bl12 = false;
                    ZipArchiveOutputStream zipArchiveOutputStream5 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream5);
                    zipArchiveOutputStream5.putArchiveEntry(dependencyZipEntry);
                    ZipArchiveOutputStream zipArchiveOutputStream6 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream6);
                    byte[] byArray = fixedDependencyXml.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                    zipArchiveOutputStream6.write(byArray);
                    ZipArchiveOutputStream zipArchiveOutputStream7 = this.morphoZipOutputStream;
                    Intrinsics.checkNotNull(zipArchiveOutputStream7);
                    zipArchiveOutputStream7.closeArchiveEntry();
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                this.LOGGER.severe("ERROR generating/writing dependency.xml: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.morpho.remove(tempDocId);
        this.sentences.remove(tempDocId);
    }

    private static final Unit korapxml2conllu$lambda$1(KorapXmlTool this$0, String annotatedConllu, AnnotationWorkerPool.AnnotationTask task) {
        Intrinsics.checkNotNullParameter(annotatedConllu, "annotatedConllu");
        this$0.parseAndWriteAnnotatedConllu(annotatedConllu, task);
        return Unit.INSTANCE;
    }

    private static final Unit korapxml2conllu$lambda$8(KorapXmlTool this$0, Ref.ObjectRef $zips, String zipFilePath) {
        String string = zipFilePath;
        if (string == null) {
            string = "";
        }
        this$0.processZipFileSequentially(string.toString(), this$0.getFoundryFromZipFileNames((String[])$zips.element));
        return Unit.INSTANCE;
    }

    private static final void korapxml2conllu$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processZipsWithQueue$lambda$1$0(AtomicInteger $active, BlockingQueue $queue, KorapXmlTool this$0, String $foundry) {
        $active.incrementAndGet();
        try {
            while (true) {
                String zipPath;
                if ((zipPath = (String)$queue.poll(100L, TimeUnit.MILLISECONDS)) == null) {
                    if (!$queue.isEmpty()) continue;
                    break;
                }
                if (this$0.sequentialInZip) {
                    this$0.processZipFileSequentially(zipPath, $foundry);
                    continue;
                }
                this$0.processZipFile(zipPath, $foundry);
            }
        }
        finally {
            $active.decrementAndGet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processZipFileSequentially$lambda$0$0$0(KorapXmlTool this$0, ZipEntry it) {
        if (!((Collection)this$0.extractMetadataRegex).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) return false;
        return true;
    }

    private static final boolean processZipFileSequentially$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String processZipFileSequentially$lambda$0$0$2(ZipEntry it) {
        return it.getName();
    }

    private static final String processZipFileSequentially$lambda$0$0$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit processZipFileSequentially$lambda$0$0$4(KorapXmlTool this$0, ZipFile $zipFile, String $foundry, ZipEntry zipEntry) {
        Intrinsics.checkNotNull(zipEntry);
        this$0.processZipEntry($zipFile, $foundry, zipEntry, true);
        return Unit.INSTANCE;
    }

    private static final void processZipFileSequentially$lambda$0$0$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processZipFileSequentially$lambda$1$0(KorapXmlTool this$0, ZipEntry it) {
        if (!((Collection)this$0.extractMetadataRegex).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) return false;
        return true;
    }

    private static final boolean processZipFileSequentially$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String processZipFileSequentially$lambda$1$2(ZipEntry it) {
        return it.getName();
    }

    private static final String processZipFileSequentially$lambda$1$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit processZipFileSequentially$lambda$1$4(KorapXmlTool this$0, ZipFile $zipFile, String $foundry, ZipEntry zipEntry) {
        Intrinsics.checkNotNull(zipEntry);
        this$0.processZipEntry($zipFile, $foundry, zipEntry, false);
        return Unit.INSTANCE;
    }

    private static final void processZipFileSequentially$lambda$1$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processZipEntriesWithPool$lambda$3$0(KorapXmlTool this$0, ZipFile $zipFile, String $foundry, ZipEntry $entry, boolean $waitForMorpho, CountDownLatch $latch) {
        try {
            this$0.processZipEntry($zipFile, $foundry, $entry, $waitForMorpho);
        }
        catch (Throwable t) {
            this$0.LOGGER.warning("Failed to process entry " + $entry.getName() + ": " + t.getMessage());
        }
        finally {
            $latch.countDown();
        }
    }

    private static final String conlluOutput$resolveHeadValue(Map<String, Integer> offsetToIndex, String raw) {
        String string;
        if (raw == null || Intrinsics.areEqual(raw, "_")) {
            return "_";
        }
        if (StringsKt.contains$default((CharSequence)raw, "-", false, 2, null)) {
            Integer idx;
            Integer n = idx = offsetToIndex.get(raw);
            string = n != null ? String.valueOf(n) : "0";
        } else {
            string = raw;
        }
        return string;
    }

    private static final void extractSpans$lambda$0(NodeList $spans, KorapXmlTool this$0, ArrayList $list, int idx) {
        Node node = $spans.item(idx);
        if (node instanceof Element) {
            String fromAttr = ((Element)node).getAttribute("from");
            String toAttr = ((Element)node).getAttribute("to");
            Object object = fromAttr;
            if (object == null || object.length() == 0 || (object = (CharSequence)toAttr) == null || object.length() == 0) {
                this$0.LOGGER.warning("Skipping span with empty from/to attribute: from='" + fromAttr + "' to='" + toAttr + "'");
            } else {
                try {
                    int from = Integer.parseInt(fromAttr);
                    int to = Integer.parseInt(toAttr);
                    Boolean bl = $list.add(new Span(from, to));
                }
                catch (NumberFormatException e) {
                    this$0.LOGGER.warning("Skipping span with invalid numeric offsets: from='" + fromAttr + "' to='" + toAttr + "' : " + e.getMessage());
                    object = Unit.INSTANCE;
                }
            }
        }
    }

    private static final boolean extractMorphoSpans$lambda$0(Node node) {
        return node instanceof Element && !Intrinsics.areEqual(((Element)node).getAttribute("type"), "alt");
    }

    private static final boolean extractMorphoSpans$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMorphoSpans$lambda$2(Map $res, Regex $UNKNOWN, Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList features = ((Element)node).getElementsByTagName("f");
        MorphoSpan fs = new MorphoSpan(null, null, null, null, null, null, null, null, 255, null);
        String fromTo = ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to");
        IntStream.range(0, features.getLength()).mapToObj(features::item).forEach(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$2$1(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$2$0(fs, $UNKNOWN, arg_0), arg_0));
        $res.put(fromTo, fs);
        return Unit.INSTANCE;
    }

    private static final Unit extractMorphoSpans$lambda$2$0(MorphoSpan $fs, Regex $UNKNOWN, Node feature) {
        block29: {
            Intrinsics.checkNotNull(feature, "null cannot be cast to non-null type org.w3c.dom.Element");
            String attr = ((Element)feature).getAttribute("name");
            String string = ((Element)feature).getTextContent();
            Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)value).length() == 0) {
                return Unit.INSTANCE;
            }
            String string2 = attr;
            if (string2 == null) break block29;
            int n = -1;
            switch (string2.hashCode()) {
                case 3686108: {
                    if (string2.equals("xpos")) {
                        n = 1;
                    }
                    break;
                }
                case 111188: {
                    if (string2.equals("pos")) {
                        n = 1;
                    }
                    break;
                }
                case 102857384: {
                    if (string2.equals("lemma")) {
                        n = 2;
                    }
                    break;
                }
                case 3596735: {
                    if (string2.equals("upos")) {
                        n = 3;
                    }
                    break;
                }
                case 3063895: {
                    if (string2.equals("ctag")) {
                        n = 1;
                    }
                    break;
                }
                case -1404142937: {
                    if (string2.equals("certainty")) {
                        n = 4;
                    }
                    break;
                }
                case 3575610: {
                    if (string2.equals("type")) {
                        n = 5;
                    }
                    break;
                }
                case 97304961: {
                    if (string2.equals("feats")) {
                        n = 6;
                    }
                    break;
                }
                case 108414: {
                    if (string2.equals("msd")) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    if (!Intrinsics.areEqual($fs.getLemma(), "_")) break;
                    CharSequence charSequence = value;
                    String string3 = "--";
                    $fs.setLemma($UNKNOWN.replace(charSequence, string3));
                    break;
                }
                case 3: {
                    $fs.setUpos(value);
                    break;
                }
                case 1: {
                    if (!Intrinsics.areEqual($fs.getXpos(), "_")) break;
                    CharSequence charSequence = value;
                    String string4 = "--";
                    $fs.setXpos($UNKNOWN.replace(charSequence, string4));
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    $fs.setFeats(value);
                    break;
                }
                case 5: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    String string5 = ((Element)feature).getElementsByTagName("symbol").item(0).getAttributes().getNamedItem("value").getTextContent();
                    Intrinsics.checkNotNullExpressionValue(string5, "getTextContent(...)");
                    $fs.setFeats(((Object)StringsKt.trim((CharSequence)string5)).toString());
                    break;
                }
                case 4: {
                    if (!Intrinsics.areEqual($fs.getMisc(), "_")) break;
                    $fs.setMisc(value);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractMorphoSpans$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void extractMorphoSpans$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean extractDependencySpans$lambda$0(Node node) {
        return node instanceof Element;
    }

    private static final boolean extractDependencySpans$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractDependencySpans$lambda$2(Map $res, Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        Element cfr_ignored_0 = (Element)node;
        String fromTo = ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to");
        NodeList relElements = ((Element)node).getElementsByTagName("rel");
        if (relElements.getLength() > 0) {
            Node node2 = relElements.item(0);
            Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
            Element rel = (Element)node2;
            String deprel = rel.getAttribute("label");
            NodeList innerSpans = rel.getElementsByTagName("span");
            Object head = null;
            if (innerSpans.getLength() > 0) {
                Node node3 = innerSpans.item(0);
                Intrinsics.checkNotNull(node3, "null cannot be cast to non-null type org.w3c.dom.Element");
                Element innerSpan = (Element)node3;
                String headFrom = innerSpan.getAttribute("from");
                String headTo = innerSpan.getAttribute("to");
                head = headFrom + "-" + headTo;
            }
            if (head != null || deprel != null) {
                String string;
                Map map2 = $res;
                Object object = head;
                if (object == null) {
                    object = "_";
                }
                if ((string = deprel) == null) {
                    string = "_";
                }
                MorphoSpan morphoSpan = new MorphoSpan(null, null, null, null, (String)object, string, null, null, 207, null);
                map2.put(fromTo, morphoSpan);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractDependencySpans$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean extractSentenceSpans$lambda$0(Node node) {
        return node instanceof Element && ((Element)node).getElementsByTagName("f").item(0).getTextContent().equals("s");
    }

    private static final boolean extractSentenceSpans$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSentenceSpans$lambda$2(Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        return new Span(Integer.parseInt(((Element)node).getAttribute("from")), Integer.parseInt(((Element)node).getAttribute("to")));
    }

    private static final Span extractSentenceSpans$lambda$3(Function1 $tmp0, Object p0) {
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSentenceSpans$lambda$4(int size) {
        return new Span[size];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean extractMiscSpans$lambda$0(Node node) {
        if (!(node instanceof Element)) return false;
        if (((Element)node).getElementsByTagName("f").getLength() <= 1) return false;
        Node node2 = ((Element)node).getElementsByTagName("f").item(0);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node2).getAttribute("name").equals("name")) return false;
        Node node3 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node3, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node3).getAttribute("name").equals("attr")) return false;
        return true;
    }

    private static final boolean extractMiscSpans$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMiscSpans$lambda$2(Map $miscLocal, KorapXmlTool this$0, Node node) {
        if (node == null) {
            return Unit.INSTANCE;
        }
        String string = ((Element)node).getElementsByTagName("f").item(0).getTextContent();
        Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
        String elementName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String from = ((Element)node).getAttribute("from");
        Node node2 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList attributes = ((Element)node2).getElementsByTagName("f");
        StringBuilder res = new StringBuilder();
        IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).forEach(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$2$1(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$2$0(elementName, this$0, res, arg_0), arg_0));
        if (((CharSequence)res).length() > 0) {
            if ($miscLocal.containsKey(from)) {
                $miscLocal.put(from, "" + $miscLocal.get(from) + res);
            } else {
                $miscLocal.put(from, res.toString());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit extractMiscSpans$lambda$2$0(String $elementName, KorapXmlTool this$0, StringBuilder $res, Node attr) {
        Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type org.w3c.dom.Element");
        String attrName = $elementName + "/" + ((Element)attr).getAttribute("name");
        CharSequence charSequence = attrName;
        if (new Regex(this$0.extractAttributesRegex).matches(charSequence)) {
            $res.append("# " + attrName + " = " + ((Element)attr).getTextContent() + "\n");
        }
        return Unit.INSTANCE;
    }

    private static final void extractMiscSpans$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void extractMiscSpans$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getZipSizes$p(KorapXmlTool $this) {
        return $this.zipSizes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u00002\u00020\u0001Bg\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$MorphoSpan;", "", "lemma", "", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLemma", "()Ljava/lang/String;", "setLemma", "(Ljava/lang/String;)V", "getUpos", "setUpos", "getXpos", "setXpos", "getFeats", "setFeats", "getHead", "setHead", "getDeprel", "setDeprel", "getDeps", "setDeps", "getMisc", "setMisc", "app"})
    public static final class MorphoSpan {
        @Nullable
        private String lemma;
        @Nullable
        private String upos;
        @Nullable
        private String xpos;
        @Nullable
        private String feats;
        @Nullable
        private String head;
        @Nullable
        private String deprel;
        @Nullable
        private String deps;
        @Nullable
        private String misc;

        public MorphoSpan(@Nullable String lemma, @Nullable String upos, @Nullable String xpos, @Nullable String feats, @Nullable String head, @Nullable String deprel, @Nullable String deps, @Nullable String misc) {
            this.lemma = lemma;
            this.upos = upos;
            this.xpos = xpos;
            this.feats = feats;
            this.head = head;
            this.deprel = deprel;
            this.deps = deps;
            this.misc = misc;
        }

        public /* synthetic */ MorphoSpan(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "_";
            }
            if ((n & 2) != 0) {
                string2 = "_";
            }
            if ((n & 4) != 0) {
                string3 = "_";
            }
            if ((n & 8) != 0) {
                string4 = "_";
            }
            if ((n & 0x10) != 0) {
                string5 = "_";
            }
            if ((n & 0x20) != 0) {
                string6 = "_";
            }
            if ((n & 0x40) != 0) {
                string7 = "_";
            }
            if ((n & 0x80) != 0) {
                string8 = "_";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @Nullable
        public final String getLemma() {
            return this.lemma;
        }

        public final void setLemma(@Nullable String string) {
            this.lemma = string;
        }

        @Nullable
        public final String getUpos() {
            return this.upos;
        }

        public final void setUpos(@Nullable String string) {
            this.upos = string;
        }

        @Nullable
        public final String getXpos() {
            return this.xpos;
        }

        public final void setXpos(@Nullable String string) {
            this.xpos = string;
        }

        @Nullable
        public final String getFeats() {
            return this.feats;
        }

        public final void setFeats(@Nullable String string) {
            this.feats = string;
        }

        @Nullable
        public final String getHead() {
            return this.head;
        }

        public final void setHead(@Nullable String string) {
            this.head = string;
        }

        @Nullable
        public final String getDeprel() {
            return this.deprel;
        }

        public final void setDeprel(@Nullable String string) {
            this.deprel = string;
        }

        @Nullable
        public final String getDeps() {
            return this.deps;
        }

        public final void setDeps(@Nullable String string) {
            this.deps = string;
        }

        @Nullable
        public final String getMisc() {
            return this.misc;
        }

        public final void setMisc(@Nullable String string) {
            this.misc = string;
        }

        public MorphoSpan() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$OutputFormatConverter;", "Lpicocli/CommandLine$ITypeConverter;", "Lde/ids_mannheim/korapxmltools/OutputFormat;", "<init>", "()V", "convert", "value", "", "app"})
    public static final class OutputFormatConverter
    implements CommandLine.ITypeConverter<OutputFormat> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public OutputFormat convert(@Nullable String value) {
            String string;
            String string2 = value;
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string4 = string3.toLowerCase(locale);
                v3 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                v3 = string = null;
            }
            if (string == null) throw new IllegalArgumentException("Unknown output format: `" + value + "'. Use one of: " + CollectionsKt.joinToString$default(OutputFormat.getEntries(), ", ", null, null, 0, null, OutputFormatConverter::convert$lambda$0, 30, null));
            int n = -1;
            switch (string.hashCode()) {
                case 120609: {
                    if (string.equals("zip")) {
                        n = 1;
                    }
                    break;
                }
                case 94844546: {
                    if (string.equals("conll")) {
                        n = 2;
                    }
                    break;
                }
                case 102236221: {
                    if (string.equals("korap")) {
                        n = 1;
                    }
                    break;
                }
                case 118807: {
                    if (string.equals("xml")) {
                        n = 1;
                    }
                    break;
                }
                case 109270: {
                    if (string.equals("now")) {
                        n = 3;
                    }
                    break;
                }
                case 77494: {
                    if (string.equals("NOW")) {
                        n = 3;
                    }
                    break;
                }
                case 116027: {
                    if (string.equals("w2v")) {
                        n = 4;
                    }
                    break;
                }
                case -1354786253: {
                    if (string.equals("conllu")) {
                        n = 2;
                    }
                    break;
                }
                case 27374636: {
                    if (string.equals("word2vec")) {
                        n = 4;
                    }
                    break;
                }
                case 587565754: {
                    if (string.equals("korapxml")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    OutputFormat outputFormat = OutputFormat.CONLLU;
                    return outputFormat;
                }
                case 4: {
                    OutputFormat outputFormat = OutputFormat.WORD2VEC;
                    return outputFormat;
                }
                case 1: {
                    OutputFormat outputFormat = OutputFormat.KORAPXML;
                    return outputFormat;
                }
                case 3: {
                    OutputFormat outputFormat = OutputFormat.NOW;
                    return outputFormat;
                }
                default: {
                    throw new IllegalArgumentException("Unknown output format: `" + value + "'. Use one of: " + CollectionsKt.joinToString$default(OutputFormat.getEntries(), ", ", null, null, 0, null, OutputFormatConverter::convert$lambda$0, 30, null));
                }
            }
        }

        private static final CharSequence convert$lambda$0(OutputFormat it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.name();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "", "from", "", "to", "<init>", "(II)V", "getFrom", "()I", "setFrom", "(I)V", "getTo", "setTo", "app"})
    public static final class Span {
        private int from;
        private int to;

        public Span(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputFormat.values().length];
            try {
                nArray[OutputFormat.WORD2VEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputFormat.NOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

