/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lemming.lemma.ranker.RankerCandidate;
import marmot.core.Evaluator;
import marmot.core.Sequence;
import marmot.core.State;
import marmot.core.Tagger;
import marmot.core.Token;
import marmot.core.lattice.Hypothesis;
import marmot.core.lattice.SequenceViterbiLattice;
import marmot.core.lattice.SumLattice;
import marmot.core.lattice.ViterbiLattice;
import marmot.core.lattice.ZeroOrderSumLattice;
import marmot.core.lattice.ZeroOrderViterbiLattice;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphResult;
import marmot.morph.MorphTagger;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.cmd.Trainer;
import marmot.morph.io.SentenceReader;
import marmot.util.Copy;

public class MorphEvaluator
implements Evaluator {
    private Collection<Sequence> sentences_;

    public MorphEvaluator(Collection<Sequence> sentences) {
        this.sentences_ = sentences;
    }

    public static MorphResult eval(Tagger tagger, Sentence sentence) {
        MorphModel model = (MorphModel)tagger.getModel();
        MorphResult result = new MorphResult(tagger);
        for (Token token : sentence) {
            Word word = (Word)token;
            model.addIndexes(word, false);
        }
        ++result.num_sentences;
        long time = System.currentTimeMillis();
        SumLattice sum_lattice = tagger.getSumLattice(false, sentence);
        result.sum_lattice_time += System.currentTimeMillis() - time;
        List<List<State>> candidates = sum_lattice.getCandidates();
        ViterbiLattice lattice = sum_lattice instanceof ZeroOrderSumLattice ? new ZeroOrderViterbiLattice(candidates, model.getOptions().getBeamSize(), model.getMarganlizeLemmas()) : new SequenceViterbiLattice(candidates, model.getBoundaryState(tagger.getNumLevels() - 1), model.getOptions().getBeamSize(), model.getMarganlizeLemmas());
        for (List<State> states : candidates) {
            result.num_states += states.size();
            ++result.candidates_length;
        }
        Hypothesis h = lattice.getViterbiSequence();
        result.time += System.currentTimeMillis() - time;
        List<Integer> candidate_indexes = h.getStates();
        ArrayList<int[]> expected_indexes = new ArrayList<int[]>();
        for (Token token : sentence) {
            expected_indexes.add(token.getTagIndexes());
        }
        int rank = MorphEvaluator.getRankOfSequence(tagger, sentence, lattice, candidates);
        if (rank > 0 && rank - 1 < result.rank.length) {
            int n = rank - 1;
            result.rank[n] = result.rank[n] + 1;
        }
        boolean sentence_error = false;
        for (int index = 0; index < sentence.size(); ++index) {
            Word word = (Word)sentence.get(index);
            int form_index = word.getWordFormIndex();
            boolean is_oov = model.isOOV(form_index);
            State state = candidates.get(index).get(candidate_indexes.get(index)).getZeroOrderState();
            assert (state != null);
            boolean token_error = false;
            State run = state;
            for (int level = tagger.getNumLevels() - 1; level >= 0; --level) {
                boolean is_error;
                assert (run != null);
                int expected_tag = ((int[])expected_indexes.get(index))[level];
                int actual_tag = run.getIndex();
                run = run.getSubLevelState();
                boolean bl = is_error = expected_tag != actual_tag;
                if (is_error) {
                    sentence_error = true;
                    int n = level;
                    result.token_errors[n] = result.token_errors[n] + 1;
                    token_error = true;
                }
                if (!is_oov || !is_error) continue;
                int n = level;
                result.oov_errors[n] = result.oov_errors[n] + 1;
            }
            assert (state != null);
            List<RankerCandidate> lemma_candidates = state.getLemmaCandidates();
            if (lemma_candidates != null) {
                RankerCandidate candidate = RankerCandidate.bestCandidate(lemma_candidates);
                String lemma = word.getLemma().toLowerCase();
                assert (lemma != null);
                String plemma = candidate.getLemma();
                if (!lemma.equals(plemma)) {
                    ++result.lemma_errors;
                    if (is_oov) {
                        ++result.lemma_oov_errors;
                    }
                }
            }
            if (token_error) {
                ++result.morph_errors;
                if (is_oov) {
                    ++result.morph_oov_errors;
                }
            }
            if (is_oov) {
                ++result.num_oovs;
            }
            ++result.num_tokens;
        }
        if (sentence_error) {
            ++result.sentence_errors;
        }
        if (tagger.getGoldIndexes(sentence, candidates) == null) {
            ++result.num_unreachable_sentences;
        }
        return result;
    }

    @Override
    public MorphResult eval(Tagger tagger) {
        MorphResult result = new MorphResult(tagger.getModel(), tagger.getNumLevels());
        for (Sequence sentence : this.sentences_) {
            result.increment(MorphEvaluator.eval(tagger, (Sentence)sentence));
        }
        return result;
    }

    protected static int getRankOfSequence(Tagger tagger, Sentence sentence, ViterbiLattice lattice, List<List<State>> candidates) {
        List<Integer> gold_indexes = tagger.getGoldIndexes(sentence, candidates);
        if (gold_indexes == null) {
            return -1;
        }
        int rank = 0;
        boolean found_hypothesis = false;
        for (Hypothesis h : lattice.getNbestSequences()) {
            List<Integer> indexes = h.getStates();
            if (gold_indexes.equals(indexes)) {
                found_hypothesis = true;
                break;
            }
            ++rank;
        }
        if (!found_hypothesis) {
            return -1;
        }
        return rank;
    }

    public static MorphResult eval(MorphOptions opts, int num_trials, int seed) {
        opts = Copy.clone(opts);
        long wall_time = System.currentTimeMillis();
        MorphResult result = null;
        for (int trial = 0; trial < num_trials; ++trial) {
            opts.setProperty("seed", Integer.toString(seed + trial));
            MorphTagger tagger = Trainer.train(opts);
            LinkedList<Sequence> sentences = new LinkedList<Sequence>();
            for (Sequence sentence : new SentenceReader(opts.getTestFile())) {
                sentences.add(sentence);
            }
            MorphEvaluator e = new MorphEvaluator(sentences);
            MorphResult current_result = e.eval(tagger);
            if (result == null) {
                result = current_result;
                continue;
            }
            result.increment(current_result);
        }
        result.time = (System.currentTimeMillis() - wall_time) / (long)num_trials;
        return result;
    }
}

