/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.trans;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.trans.XPathException;

public class XSLArray
extends XSLSequence {
    private Expression use;

    @Override
    public boolean isInXsltNamespace() {
        return this.getNodeName().hasURI(NamespaceUri.XSLT);
    }

    @Override
    protected void prepareAttributes() {
        block10: for (AttributeInfo att : this.attributes()) {
            String f;
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            switch (f = attName.getDisplayName()) {
                case "select": {
                    this.setSelectExpression(this.makeExpression(value, att));
                    continue block10;
                }
                case "use": {
                    this.use = this.makeExpression(value, att);
                    continue block10;
                }
                case "composite": {
                    this.compileWarning("XSLT 4.0 spec change: replace composite='yes' with use='?value'", "SXWN0001");
                    boolean composite = this.processBooleanAttribute("composite", value);
                    if (!composite) continue block10;
                    this.use = this.makeExpression("?value", att);
                    continue block10;
                }
            }
            this.checkUnknownAttribute(attName);
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.use = this.typeCheck("use", this.use);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression functionCall;
        if (this.isInXsltNamespace()) {
            this.requireXslt40Element();
        } else if (!this.getConfiguration().isLicensedFeature(8)) {
            this.compileError("saxon:array requires a Saxon-PE or -EE license");
        }
        if (this.getSelectExpression() == null) {
            this.setSelectExpression(this.compileSequenceConstructor(exec, decl, false));
        }
        if (this.use == null || this.use instanceof ContextItemExpression) {
            SystemFunction build = ArrayFunctionSet.getInstance(40).makeFunction("build", 1);
            functionCall = build.makeFunctionCall(this.getSelectExpression());
        } else {
            SystemFunction mapEntry = MapFunctionSet.getInstance(40).makeFunction("entry", 2);
            Expression mapEntryCall = mapEntry.makeFunctionCall(new StringLiteral("value"), this.use);
            ForEach bangExpression = new ForEach(this.getSelectExpression(), mapEntryCall);
            SystemFunction arrayOf = ArrayFunctionSet.getInstance(40).makeFunction("of-members", 1);
            functionCall = arrayOf.makeFunctionCall(bangExpression);
        }
        ExpressionTool.copyLocationInfo(this.getSelectExpression(), functionCall);
        return functionCall;
    }
}

