/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.Word;

public class Sentence
extends AbstractList<Token>
implements Sequence {
    private static final long serialVersionUID = 1L;
    private List<Word> tokens_;
    private List<String> comments_;
    private Hashtable<Integer, String> segments_;
    private Hashtable<Integer, String> empty_nodes_;

    public Sentence(List<Word> tokens) {
        this.tokens_ = new ArrayList<Word>(tokens);
    }

    @Override
    public Token get(int index) {
        return this.tokens_.get(index);
    }

    @Override
    public int size() {
        return this.tokens_.size();
    }

    public void setEmptyNodes(Hashtable<Integer, String> e) {
        this.empty_nodes_ = e;
    }

    public Hashtable<Integer, String> getEmptyNodes() {
        return this.empty_nodes_;
    }

    public void setSegments(Hashtable<Integer, String> s) {
        this.segments_ = s;
    }

    public Hashtable<Integer, String> getSegments() {
        return this.segments_;
    }

    public void setComments(List<String> c) {
        this.comments_ = c;
    }

    public List<String> getComments() {
        return this.comments_;
    }

    public void setTags(List<String> tags) {
        assert (tags.size() == this.size());
        for (int index = 0; index < this.size(); ++index) {
            this.tokens_.get(index).setPosTag(tags.get(index));
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Sequence)) {
            return false;
        }
        Sequence other_sentence = (Sequence)other;
        if (other_sentence.size() != this.size()) {
            return false;
        }
        for (int index = 0; index < this.size(); ++index) {
            if (this.tokens_.get(index).equals(other_sentence.get(index))) continue;
            return false;
        }
        return true;
    }

    public Word getWord(int i) {
        return (Word)this.get(i);
    }
}

