/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.cmd;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import lemming.lemma.LemmaCandidateGenerator;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.edit.EditTreeGeneratorTrainer;
import marmot.morph.io.SentenceReader;

public class Stats {
    private static NumberFormat formatter = new DecimalFormat("#0.00");

    public static void main(String[] args) {
        String train_file = args[0];
        String dev_file = args[1];
        int min_count = Integer.parseInt(args[2]);
        List<LemmaInstance> training_instances = LemmaInstance.getInstances(new SentenceReader(train_file), -1);
        List<LemmaInstance> dev_instances = LemmaInstance.getInstances(new SentenceReader(dev_file), -1);
        String tag_independent = Stats.getStats(training_instances, dev_instances, false, min_count);
        String tag_dependent = Stats.getStats(training_instances, dev_instances, true, min_count);
        System.out.format("%s & %s \\\\\n", tag_independent, tag_dependent);
    }

    public static String getStats(List<LemmaInstance> training_instances, List<LemmaInstance> dev_instances, boolean tag_dependent, int min_count) {
        EditTreeGeneratorTrainer trainer = new EditTreeGeneratorTrainer();
        trainer.getOptions().setOption("tag-dependent", tag_dependent);
        trainer.getOptions().setOption("min-count", min_count);
        LemmaCandidateGenerator generator = trainer.train(training_instances, null);
        double num_token_candidates = 0.0;
        double num_type_candidates = 0.0;
        double num_tokens = 0.0;
        double num_types = 0.0;
        double correct_tokens = 0.0;
        double correct_types = 0.0;
        for (LemmaInstance instance : dev_instances) {
            LemmaCandidateSet set = new LemmaCandidateSet();
            generator.addCandidates(instance, set);
            if (set.contains(instance.getLemma())) {
                correct_tokens += instance.getCount();
                correct_types += 1.0;
            }
            num_token_candidates += (double)set.size() * instance.getCount();
            num_type_candidates += (double)set.size();
            num_tokens += instance.getCount();
            num_types += 1.0;
        }
        return String.format("%s & %s\\%% & %s & %s\\%%", Stats.nice(num_token_candidates / num_tokens), Stats.nice(correct_tokens * 100.0 / num_tokens), Stats.nice(num_type_candidates / num_types), Stats.nice(correct_types * 100.0 / num_types));
    }

    private static String nice(double number) {
        return formatter.format(number);
    }
}

