/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001#B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001e\b\u0002\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\u0014\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 J\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "", "command", "", "numWorkers", "", "LOGGER", "Ljava/util/logging/Logger;", "outputHandler", "Lkotlin/Function2;", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool$AnnotationTask;", "", "<init>", "(Ljava/lang/String;ILjava/util/logging/Logger;Lkotlin/jvm/functions/Function2;)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "threads", "", "Ljava/lang/Thread;", "threadCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "threadsLock", "pendingOutputHandlers", "openWorkerPool", "printOutput", "output", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pushToQueue", "text", "docId", "entryPath", "texts", "", "close", "waitForWorkersToFinish", "AnnotationTask", "app"})
@SourceDebugExtension(value={"SMAP\nAnnotationWorkerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationWorkerPool.kt\nde/ids_mannheim/korapxmltools/AnnotationWorkerPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,487:1\n1869#2,2:488\n1869#2,2:490\n1563#2:492\n1634#2,3:493\n1869#2,2:496\n*S KotlinDebug\n*F\n+ 1 AnnotationWorkerPool.kt\nde/ids_mannheim/korapxmltools/AnnotationWorkerPool\n*L\n349#1:488,2\n418#1:490,2\n443#1:492\n443#1:493,3\n275#1:496,2\n*E\n"})
public final class AnnotationWorkerPool {
    @NotNull
    private final String command;
    private final int numWorkers;
    @NotNull
    private final Logger LOGGER;
    @Nullable
    private final Function2<String, AnnotationTask, Unit> outputHandler;
    @NotNull
    private final BlockingQueue<AnnotationTask> queue;
    @NotNull
    private final List<Thread> threads;
    @NotNull
    private final AtomicInteger threadCount;
    @NotNull
    private final Object threadsLock;
    @NotNull
    private final AtomicInteger pendingOutputHandlers;

    public AnnotationWorkerPool(@NotNull String command2, int numWorkers, @NotNull Logger LOGGER, @Nullable Function2<? super String, ? super AnnotationTask, Unit> outputHandler) {
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(LOGGER, "LOGGER");
        this.command = command2;
        this.numWorkers = numWorkers;
        this.LOGGER = LOGGER;
        this.outputHandler = outputHandler;
        this.queue = new LinkedBlockingQueue();
        this.threads = new ArrayList();
        this.threadCount = new AtomicInteger(0);
        this.threadsLock = new Object();
        this.pendingOutputHandlers = new AtomicInteger(0);
        this.openWorkerPool();
        this.LOGGER.info("Annotation worker pool with " + this.numWorkers + " threads opened");
    }

    public /* synthetic */ AnnotationWorkerPool(String string, int n, Logger logger, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function2 = null;
        }
        this(string, n, logger, function2);
    }

    private final void openWorkerPool() {
        int n = this.numWorkers;
        int n2 = 0;
        while (n2 < n) {
            int workerIndex = n2++;
            boolean bl = false;
            new Thread(() -> AnnotationWorkerPool.openWorkerPool$lambda$0$0(this, workerIndex)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object printOutput(@NotNull String output, @NotNull Continuation<? super Unit> $completion) {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue(printStream, "out");
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            boolean bl = false;
            try {
                byte[] byArray = output.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                System.out.write(byArray);
            }
            catch (IOException e) {
                this.LOGGER.severe("Failed to write to stdout: " + e.getMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public final void pushToQueue(@NotNull String text, @Nullable String docId, @Nullable String entryPath) {
        Intrinsics.checkNotNullParameter(text, "text");
        try {
            this.LOGGER.fine("pushToQueue called: text length=" + text.length() + ", docId=" + docId + ", entryPath=" + entryPath);
            this.queue.put(new AnnotationTask(text, docId, entryPath));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.LOGGER.warning("Interrupted while trying to push text to queue.");
        }
    }

    public static /* synthetic */ void pushToQueue$default(AnnotationWorkerPool annotationWorkerPool, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        annotationWorkerPool.pushToQueue(string, string2, string3);
    }

    public final void pushToQueue(@NotNull List<String> texts) {
        Intrinsics.checkNotNullParameter(texts, "texts");
        Iterable $this$forEach$iv = texts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text = (String)element$iv;
            boolean bl = false;
            try {
                this.queue.put(new AnnotationTask(text, null, null));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.LOGGER.warning("Interrupted while trying to push texts to queue. Some texts may not have been added.");
                return;
            }
        }
    }

    public final void close() {
        int currentThreadCount = this.threadCount.get();
        int queueSizeBeforeEOF = this.queue.size();
        this.LOGGER.info("Closing worker pool with " + currentThreadCount + " threads, queue size: " + queueSizeBeforeEOF);
        int n = this.numWorkers;
        for (int i = 0; i < n; ++i) {
            try {
                this.queue.put(new AnnotationTask("#eof", null, null));
                this.LOGGER.info("Sent EOF marker " + (i + 1) + "/" + this.numWorkers + " to queue");
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.LOGGER.warning("Interrupted while sending EOF to workers. Some workers may not shut down cleanly.");
                break;
            }
        }
        this.LOGGER.info("All EOF markers sent, queue size now: " + this.queue.size());
        if (this.threadCount.get() > 0) {
            this.waitForWorkersToFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void waitForWorkersToFinish() {
        Object thread2;
        Object $i$a$-synchronized-AnnotationWorkerPool$waitForWorkersToFinish$22;
        long startTime = System.currentTimeMillis();
        int lastReportedSize = this.queue.size();
        this.LOGGER.info("Waiting for queue to empty (current size: " + this.queue.size() + ")...");
        while (!((Collection)this.queue).isEmpty()) {
            try {
                Thread.sleep(50L);
                int currentSize = this.queue.size();
                long elapsed = (System.currentTimeMillis() - startTime) / (long)1000;
                if (elapsed % (long)5 != 0L || currentSize == lastReportedSize) continue;
                this.LOGGER.info("Queue status: " + currentSize + " items remaining (" + elapsed + "s elapsed)");
                lastReportedSize = currentSize;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.LOGGER.warning("Interrupted while waiting for queue to empty. Proceeding to join threads.");
                break;
            }
        }
        long totalTime = (System.currentTimeMillis() - startTime) / (long)1000;
        this.LOGGER.info("Queue is empty after " + totalTime + "s. Joining worker threads.");
        List threadsToJoin = null;
        Object object = this.threadsLock;
        synchronized (object) {
            boolean $i$a$-synchronized-AnnotationWorkerPool$waitForWorkersToFinish$22 = false;
            threadsToJoin = CollectionsKt.toList((Iterable)this.threads);
            $i$a$-synchronized-AnnotationWorkerPool$waitForWorkersToFinish$22 = Unit.INSTANCE;
        }
        if (threadsToJoin.isEmpty() && this.threadCount.get() == 0) {
            this.LOGGER.info("No threads were active or recorded to join.");
        } else {
            this.LOGGER.info("Attempting to join " + threadsToJoin.size() + " thread(s) from recorded list (current active count: " + this.threadCount.get() + ").");
            Iterable $this$forEach$iv = threadsToJoin;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                thread2 = (Thread)element$iv;
                boolean bl = false;
                try {
                    ((Thread)thread2).join(1800000L);
                    if (!((Thread)thread2).isAlive()) continue;
                    this.LOGGER.warning("Thread " + ((Thread)thread2).threadId() + " did not terminate after 30 minutes. Interrupting.");
                    ((Thread)thread2).interrupt();
                    ((Thread)thread2).join(10000L);
                    if (!((Thread)thread2).isAlive()) continue;
                    this.LOGGER.severe("Thread " + ((Thread)thread2).threadId() + " failed to terminate after interrupt.");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.LOGGER.warning("Interrupted while joining thread " + ((Thread)thread2).threadId() + ". It may not have shut down cleanly.");
                }
            }
        }
        int finalCount = this.threadCount.get();
        if (finalCount == 0) {
            this.LOGGER.info("All worker threads appear to have terminated.");
        } else {
            this.LOGGER.warning(finalCount + " worker thread(s) still marked as active according to counter. This might indicate an issue in thread lifecycle management.");
            $i$a$-synchronized-AnnotationWorkerPool$waitForWorkersToFinish$22 = this.threadsLock;
            synchronized ($i$a$-synchronized-AnnotationWorkerPool$waitForWorkersToFinish$22) {
                boolean bl = false;
                if (!((Collection)this.threads).isEmpty()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    thread2 = this.threads;
                    Logger logger = this.LOGGER;
                    boolean $i$f$map = false;
                    void var14_27 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Thread thread3 = (Thread)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.threadId());
                    }
                    logger.warning("The internal threads list is not empty: " + (List)destination$iv$iv + ". Forcing clear.");
                    this.threads.clear();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        int pendingCount = this.pendingOutputHandlers.get();
        if (pendingCount > 0) {
            this.LOGGER.info("Waiting for " + pendingCount + " pending outputHandler invocation(s) to complete...");
        }
        long startWait = System.currentTimeMillis();
        while (this.pendingOutputHandlers.get() > 0) {
            try {
                Thread.sleep(100L);
                long elapsed = System.currentTimeMillis() - startWait;
                if (elapsed <= 30000L) continue;
                this.LOGGER.severe("Timeout waiting for " + this.pendingOutputHandlers.get() + " pending outputHandler(s) after 30s!");
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.LOGGER.warning("Interrupted while waiting for pending outputHandlers");
                break;
            }
        }
        if (pendingCount > 0) {
            this.LOGGER.info("All outputHandler invocations completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void openWorkerPool$lambda$0$0(AnnotationWorkerPool this$0, int $workerIndex) {
        String[] stringArray;
        Thread self = Thread.currentThread();
        boolean successfullyInitialized = false;
        int workerAttempts = 0;
        int maxRestarts = 50;
        while (workerAttempts < maxRestarts && !Thread.currentThread().isInterrupted()) {
            if (++workerAttempts > 1) {
                this$0.LOGGER.info("Worker " + $workerIndex + ": Restart attempt " + workerAttempts);
            }
            try {
                Process process;
                if (workerAttempts == 1) {
                    stringArray = this$0.threadsLock;
                    synchronized (stringArray) {
                        boolean bl = false;
                        List<Thread> list = this$0.threads;
                        Intrinsics.checkNotNull(self);
                        bl = list.add(self);
                    }
                    this$0.threadCount.incrementAndGet();
                    successfullyInitialized = true;
                    this$0.LOGGER.info("Worker " + $workerIndex + " (thread " + self.threadId() + ") started.");
                }
                if ((process = new ProcessBuilder(stringArray = new String[]{"/bin/sh", "-c", this$0.command}).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start()).getOutputStream() == null) {
                    this$0.LOGGER.severe("Worker " + $workerIndex + " (thread " + self.threadId() + ") failed to open pipe for command '" + this$0.command + "'");
                    return;
                }
                BlockingQueue pendingTasks = new LinkedBlockingQueue();
                OutputStream outputStream = process.getOutputStream();
                Intrinsics.checkNotNullExpressionValue(outputStream, "getOutputStream(...)");
                Closeable bl = outputStream;
                int n = 10000000;
                bl = bl instanceof BufferedOutputStream ? (BufferedOutputStream)bl : new BufferedOutputStream((OutputStream)bl, n);
                Throwable throwable = null;
                try {
                    Object procOutStream = (BufferedOutputStream)bl;
                    boolean bl2 = false;
                    InputStream inputStream = process.getInputStream();
                    Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                    Object object = inputStream;
                    int n2 = 10000000;
                    object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n2);
                    Throwable throwable2 = null;
                    try {
                        Object procInStream = (BufferedInputStream)object;
                        boolean bl3 = false;
                        CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope(Dispatchers.getIO().plus(JobKt.Job$default(null, 1, null)));
                        Ref.BooleanRef inputGotEof = new Ref.BooleanRef();
                        BuildersKt.launch$default(coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((BufferedOutputStream)procOutStream, this$0, $workerIndex, self, (BlockingQueue<AnnotationTask>)pendingTasks, null){
                            int label;
                            final /* synthetic */ BufferedOutputStream $procOutStream;
                            final /* synthetic */ AnnotationWorkerPool this$0;
                            final /* synthetic */ int $workerIndex;
                            final /* synthetic */ Thread $self;
                            final /* synthetic */ BlockingQueue<AnnotationTask> $pendingTasks;
                            {
                                this.$procOutStream = $procOutStream;
                                this.this$0 = $receiver;
                                this.$workerIndex = $workerIndex;
                                this.$self = $self;
                                this.$pendingTasks = $pendingTasks;
                                super(2, $completion);
                            }

                            /*
                             * Exception decompiling
                             */
                            public final Object invokeSuspend(Object $result) {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredWhile.dump(StructuredWhile.java:37)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 3, null);
                        BuildersKt.launch$default(coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((BufferedInputStream)procInStream, (BlockingQueue<AnnotationTask>)pendingTasks, this$0, $workerIndex, self, inputGotEof, process, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            Object L$7;
                            Object L$8;
                            Object L$9;
                            Object L$10;
                            Object L$11;
                            int I$0;
                            int I$1;
                            int label;
                            final /* synthetic */ BufferedInputStream $procInStream;
                            final /* synthetic */ BlockingQueue<AnnotationTask> $pendingTasks;
                            final /* synthetic */ AnnotationWorkerPool this$0;
                            final /* synthetic */ int $workerIndex;
                            final /* synthetic */ Thread $self;
                            final /* synthetic */ Ref.BooleanRef $inputGotEof;
                            final /* synthetic */ Process $process;
                            {
                                this.$procInStream = $procInStream;
                                this.$pendingTasks = $pendingTasks;
                                this.this$0 = $receiver;
                                this.$workerIndex = $workerIndex;
                                this.$self = $self;
                                this.$inputGotEof = $inputGotEof;
                                this.$process = $process;
                                super(2, $completion);
                            }

                            /*
                             * Exception decompiling
                             */
                            public final Object invokeSuspend(Object $result) {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 28[WHILELOOP]
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredWhile.dump(StructuredWhile.java:37)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 3, null);
                        try {
                            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(coroutineScope, null){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                int I$1;
                                int label;
                                final /* synthetic */ CoroutineScope $coroutineScope;
                                {
                                    this.$coroutineScope = $coroutineScope;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    block7: {
                                        block6: {
                                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure($result);
                                                    v0 = (Job)this.$coroutineScope.getCoroutineContext().get(Job.Key);
                                                    if (v0 != null && (v0 = v0.getChildren()) != null) {
                                                        $this$forEach$iv = v0;
                                                        $i$f$forEach = 0;
                                                        var4_5 = $this$forEach$iv.iterator();
lbl10:
                                                        // 3 sources

                                                        while (var4_5.hasNext()) {
                                                            element$iv = var4_5.next();
                                                            job = (Job)element$iv;
                                                            $i$a$-forEach-AnnotationWorkerPool$openWorkerPool$1$1$2$1$3$1 = 0;
                                                            this.L$0 = SpillingKt.nullOutSpilledVariable($this$forEach$iv);
                                                            this.L$1 = var4_5;
                                                            this.L$2 = SpillingKt.nullOutSpilledVariable(element$iv);
                                                            this.L$3 = SpillingKt.nullOutSpilledVariable(job);
                                                            this.I$0 = $i$f$forEach;
                                                            this.I$1 = $i$a$-forEach-AnnotationWorkerPool$openWorkerPool$1$1$2$1$3$1;
                                                            this.label = 1;
                                                            v1 = job.join(this);
                                                            if (v1 != var8_2) continue;
                                                            return var8_2;
                                                        }
                                                        break;
                                                    }
                                                    break block6;
                                                }
                                                case 1: {
                                                    $i$a$-forEach-AnnotationWorkerPool$openWorkerPool$1$1$2$1$3$1 = this.I$1;
                                                    $i$f$forEach = this.I$0;
                                                    job = (Job)this.L$3;
                                                    element$iv = this.L$2;
                                                    var4_5 = (Iterator<T>)this.L$1;
                                                    $this$forEach$iv = (Sequence)this.L$0;
                                                    ResultKt.throwOnFailure($result);
                                                    v1 = $result;
                                                    ** GOTO lbl10
                                                }
                                            }
                                            v2 = Unit.INSTANCE;
                                            break block7;
                                        }
                                        v2 = null;
                                    }
                                    return v2;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            this$0.LOGGER.info("Worker " + $workerIndex + " (thread " + self.threadId() + ") coroutines completed");
                        }
                        catch (InterruptedException e) {
                            this$0.LOGGER.info("Worker " + $workerIndex + " (thread " + self.threadId() + ") interrupted while waiting for coroutines");
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            CoroutineScopeKt.cancel$default(coroutineScope, null, 1, null);
                        }
                        procInStream = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable2 = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable2);
                    }
                    procOutStream = Unit.INSTANCE;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally(bl, throwable);
                }
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    this$0.LOGGER.warning("Worker " + $workerIndex + " (thread " + self.threadId() + ") process exited with code " + exitCode);
                    List remainingTasks = new ArrayList();
                    pendingTasks.drainTo(remainingTasks);
                    if (!((Collection)remainingTasks).isEmpty()) {
                        this$0.LOGGER.warning("Worker " + $workerIndex + ": Returning " + remainingTasks.size() + " unprocessed task(s) to queue after process failure");
                        Iterable $this$forEach$iv = remainingTasks;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            AnnotationTask task = (AnnotationTask)element$iv;
                            boolean bl4 = false;
                            if (Intrinsics.areEqual(task.getText(), "#eof")) continue;
                            try {
                                this$0.queue.put(task);
                            }
                            catch (InterruptedException e) {
                                this$0.LOGGER.severe("Failed to return task to queue: " + e.getMessage());
                            }
                        }
                    }
                    if (this$0.queue.isEmpty()) {
                        this$0.LOGGER.info("Worker " + $workerIndex + ": Queue is empty after crash, exiting");
                        break;
                    }
                    this$0.LOGGER.info("Worker " + $workerIndex + ": Restarting to process remaining " + this$0.queue.size() + " items in queue");
                    continue;
                }
                this$0.LOGGER.info("Worker " + $workerIndex + " (thread " + self.threadId() + ") process finished normally");
                break;
            }
            catch (IOException e) {
                this$0.LOGGER.severe("Worker " + $workerIndex + " (thread " + self.threadId() + ") failed: " + e.getMessage());
                break;
            }
            catch (InterruptedException e) {
                this$0.LOGGER.info("Worker " + $workerIndex + " (thread " + self.threadId() + ") was interrupted during processing");
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                this$0.LOGGER.severe("Unhandled exception in worker thread " + self.threadId() + " (index " + $workerIndex + "): " + e.getMessage());
                e.printStackTrace();
                break;
            }
        }
        if (successfullyInitialized) {
            stringArray = this$0.threadsLock;
            synchronized (stringArray) {
                boolean bl = false;
                boolean bl5 = this$0.threads.remove(self);
            }
            this$0.threadCount.decrementAndGet();
            this$0.LOGGER.info("Worker thread " + self.threadId() + " (index " + $workerIndex + ") cleaned up and exiting. Active threads: " + this$0.threadCount.get());
        } else {
            this$0.LOGGER.warning("Worker thread " + self.threadId() + " (index " + $workerIndex + ") exiting without full initialization/cleanup.");
        }
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(AnnotationWorkerPool $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p(AnnotationWorkerPool $this) {
        return $this.LOGGER;
    }

    public static final /* synthetic */ Function2 access$getOutputHandler$p(AnnotationWorkerPool $this) {
        return $this.outputHandler;
    }

    public static final /* synthetic */ AtomicInteger access$getPendingOutputHandlers$p(AnnotationWorkerPool $this) {
        return $this.pendingOutputHandlers;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool$AnnotationTask;", "", "text", "", "docId", "entryPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getDocId", "getEntryPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "app"})
    public static final class AnnotationTask {
        @NotNull
        private final String text;
        @Nullable
        private final String docId;
        @Nullable
        private final String entryPath;

        public AnnotationTask(@NotNull String text, @Nullable String docId, @Nullable String entryPath) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.text = text;
            this.docId = docId;
            this.entryPath = entryPath;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getDocId() {
            return this.docId;
        }

        @Nullable
        public final String getEntryPath() {
            return this.entryPath;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @Nullable
        public final String component2() {
            return this.docId;
        }

        @Nullable
        public final String component3() {
            return this.entryPath;
        }

        @NotNull
        public final AnnotationTask copy(@NotNull String text, @Nullable String docId, @Nullable String entryPath) {
            Intrinsics.checkNotNullParameter(text, "text");
            return new AnnotationTask(text, docId, entryPath);
        }

        public static /* synthetic */ AnnotationTask copy$default(AnnotationTask annotationTask, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = annotationTask.text;
            }
            if ((n & 2) != 0) {
                string2 = annotationTask.docId;
            }
            if ((n & 4) != 0) {
                string3 = annotationTask.entryPath;
            }
            return annotationTask.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "AnnotationTask(text=" + this.text + ", docId=" + this.docId + ", entryPath=" + this.entryPath + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + (this.docId == null ? 0 : this.docId.hashCode());
            result = result * 31 + (this.entryPath == null ? 0 : this.entryPath.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationTask)) {
                return false;
            }
            AnnotationTask annotationTask = (AnnotationTask)other;
            if (!Intrinsics.areEqual(this.text, annotationTask.text)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.docId, annotationTask.docId)) {
                return false;
            }
            return Intrinsics.areEqual(this.entryPath, annotationTask.entryPath);
        }
    }
}

