/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.io.Serializable;
import marmot.morph.HashDictionary;
import marmot.morph.MorphDictionaryOptions;
import marmot.morph.SuffixDictionary;
import marmot.util.SymbolTable;

public abstract class MorphDictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SymbolTable<String> table_;
    private MorphDictionaryOptions options_;

    public MorphDictionary(SymbolTable<String> table) {
        this.table_ = table;
        if (this.table_ == null) {
            this.table_ = new SymbolTable(true);
        }
    }

    public MorphDictionaryOptions getOptions() {
        return this.options_;
    }

    public int numTags() {
        return this.table_.size();
    }

    public SymbolTable<String> getTable() {
        return this.table_;
    }

    public abstract int[] getIndexes(String var1);

    public static MorphDictionary create(MorphDictionaryOptions options) {
        HashDictionary dict = switch (options.getDictType()) {
            case MorphDictionaryOptions.DictionaryType.hash -> new HashDictionary();
            case MorphDictionaryOptions.DictionaryType.suffix -> new SuffixDictionary();
            default -> throw new UnsupportedOperationException();
        };
        ((MorphDictionary)dict).init(options);
        return dict;
    }

    public static MorphDictionary create(String mdict_file) {
        return MorphDictionary.create(MorphDictionaryOptions.parse(mdict_file));
    }

    public void init(MorphDictionaryOptions options) {
        this.options_ = options;
    }

    public String getName(int i) {
        String symbol = this.getTable().toSymbol(i);
        return symbol;
    }

    public void addWordsFromFile(String morph_dict) {
        throw new RuntimeException("Not Implemented");
    }
}

