/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config.pe;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import com.saxonica.config.ICULibrary;
import com.saxonica.config.pe.ICUNumbererEnUnhyphenated;
import com.saxonica.config.pe.ICUNumberer_de;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.number.AbstractNumberer;

public class ICUNumbererPE
extends AbstractNumberer {
    private static final String spelloutCardinalPattern = "%spellout-cardinal";
    private static final String spelloutOrdinalPattern = "%spellout-ordinal";
    private static final String spelloutNumberingPattern = "%spellout-numbering";
    private static final String numberOrdinalPattern = "%digits-ordinal";
    private String defaultCardinalRule;
    private String defaultOrdinalRule;
    private String defaultNumericOrdinalRule;
    private final Map<String, String> ordinalParamIndex = new ConcurrentHashMap<String, String>();
    private final ArrayList<String> spelloutCardinalRulesets = new ArrayList();
    private final ArrayList<String> spelloutOrdinalRulesets = new ArrayList();
    private final ArrayList<String> spelloutNumberingRulesets = new ArrayList();
    private final ArrayList<String> numberOrdinalRulesets = new ArrayList();
    private Locale locale;
    private Locale defaultedLocale;
    private static final String DAY_FULL = "EEEE";
    private static final String DAY_SHORT = "EEE";
    private static final String DAY_NARROW = "EEEEE";
    private static final String DAY_SHORT2 = "EEEEEE";
    private static final String MONTH_FULL = "MMMM";
    private static final String MONTH_SHORT = "MMM";
    private static final String MONTH_NARROW = "MMMMM";
    private static final String[] preferences = new String[]{"-verbose", "", "-native", "-neuter", "-feminine", "-masculine"};
    private RuleBasedNumberFormat rbnf = null;
    private RuleBasedNumberFormat rbnfNumber = null;
    private final ThreadLocal<HashMap<String, SimpleDateFormat>> simpleDateFormats = new ThreadLocal();
    private static final HashMap<String, String> schemeCodes = new HashMap();

    private synchronized DateFormat getDateFormat(String pattern) {
        SimpleDateFormat s;
        HashMap<String, Object> map = this.simpleDateFormats.get();
        if (map == null) {
            map = new HashMap();
            this.simpleDateFormats.set(map);
        }
        if ((s = map.get(pattern)) == null) {
            s = new SimpleDateFormat(pattern, this.locale);
            map.put(pattern, s);
        }
        return s;
    }

    ICUNumbererPE() {
    }

    public static synchronized ICUNumbererPE getNumberer(Locale locale, String privateUseExtension, Configuration config) {
        boolean sansHyphen;
        ICUNumbererPE n = new ICUNumbererPE();
        String[] extensions = privateUseExtension == null ? new String[]{} : privateUseExtension.split("-");
        ArrayList<String> extensionList = new ArrayList<String>(Arrays.asList(extensions));
        boolean withHyphen = extensionList.contains("hyphen");
        if (withHyphen) {
            extensionList.remove("hyphen");
        }
        if (sansHyphen = extensionList.contains("nohyphen")) {
            extensionList.remove("nohyphen");
        }
        String ext = String.join((CharSequence)"-", extensionList);
        if (locale.getLanguage().equals("en") && !withHyphen) {
            n = new ICUNumbererEnUnhyphenated();
        } else if (locale.getLanguage().equals("de")) {
            n = new ICUNumberer_de();
        }
        n.config(locale, ext, config);
        return n;
    }

    protected synchronized void config(Locale locale, String privateUseExtension, Configuration config) {
        String scheme;
        String n;
        String[] rules;
        this.rbnf = new RuleBasedNumberFormat(locale, 1);
        if (!this.rbnf.getLocale(ULocale.ACTUAL_LOCALE).getLanguage().equals(locale.getLanguage())) {
            this.defaultedLocale = locale = new Locale(config.getDefaultLanguage());
            this.rbnf = new RuleBasedNumberFormat(locale, 1);
        }
        this.rbnfNumber = new RuleBasedNumberFormat(locale, 2);
        this.locale = locale;
        for (String s : rules = this.rbnf.getRuleSetNames()) {
            if (s.startsWith(spelloutCardinalPattern)) {
                this.spelloutCardinalRulesets.add(s);
                this.ordinalParamIndex.put(s, s);
            }
            if (s.startsWith(spelloutOrdinalPattern)) {
                this.spelloutOrdinalRulesets.add(s);
                this.ordinalParamIndex.put(s, s);
            }
            if (!s.startsWith(spelloutNumberingPattern)) continue;
            this.spelloutNumberingRulesets.add(s);
        }
        for (String s : rules = this.rbnfNumber.getRuleSetNames()) {
            if (!s.startsWith(numberOrdinalPattern)) continue;
            this.numberOrdinalRulesets.add(s);
        }
        for (String p : preferences) {
            n = spelloutOrdinalPattern + p;
            if (!this.spelloutOrdinalRulesets.contains(n)) continue;
            this.defaultOrdinalRule = n;
            break;
        }
        if (this.defaultOrdinalRule == null && this.spelloutOrdinalRulesets.size() > 0) {
            this.defaultOrdinalRule = this.spelloutOrdinalRulesets.get(0);
        }
        for (String p : preferences) {
            n = spelloutCardinalPattern + p;
            if (!this.spelloutCardinalRulesets.contains(n)) continue;
            this.defaultCardinalRule = n;
            break;
        }
        if (this.defaultCardinalRule == null && this.spelloutCardinalRulesets.size() > 0) {
            this.defaultCardinalRule = this.spelloutCardinalRulesets.get(0);
        }
        for (String p : preferences) {
            n = numberOrdinalPattern + p;
            if (!this.numberOrdinalRulesets.contains(n)) continue;
            this.defaultNumericOrdinalRule = n;
            break;
        }
        if (this.defaultNumericOrdinalRule == null && this.numberOrdinalRulesets.size() > 0) {
            this.defaultNumericOrdinalRule = this.numberOrdinalRulesets.get(0);
        }
        if (this.defaultOrdinalRule == null) {
            this.defaultOrdinalRule = this.defaultCardinalRule;
        }
        if (!spelloutOrdinalPattern.equals(this.defaultOrdinalRule)) {
            // empty if block
        }
        if (privateUseExtension != null && (scheme = schemeCodes.get(privateUseExtension)) != null) {
            if (this.spelloutCardinalRulesets.contains(scheme) || this.spelloutOrdinalRulesets.contains(scheme) || this.spelloutNumberingRulesets.contains(scheme) || this.numberOrdinalRulesets.contains(scheme)) {
                this.setScheme(scheme);
            } else if (config.isTiming()) {
                config.getLogger().info("No ICU ruleset" + scheme + " for " + locale.getLanguage());
            }
        }
    }

    @Override
    public Locale defaultedLocale() {
        return this.defaultedLocale;
    }

    private void setScheme(String s) {
        this.defaultCardinalRule = s;
        this.defaultOrdinalRule = s;
    }

    public static String[] getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        for (Locale l : RuleBasedCollator.getAvailableLocales()) {
            locales.add(ICULibrary.getLanguageTag(l) + ";" + l.getDisplayName());
        }
        return locales.toArray(new String[0]);
    }

    public static String[] getPreferences() {
        return preferences;
    }

    public static String[] availableSpelloutNumberings(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 1);
        return temp.getRuleSetNames();
    }

    public static String[] availableOrdinalNumberings(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 2);
        return temp.getRuleSetNames();
    }

    public static String realLocale(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 1);
        return temp.getLocale(ULocale.ACTUAL_LOCALE).getLanguage();
    }

    public static String getICUVersion() {
        VersionInfo icu = VersionInfo.ICU_VERSION;
        return icu.getMajor() + "." + icu.getMinor() + "." + icu.getMilli() + "." + icu.getMicro();
    }

    @Override
    public String ordinalSuffix(String ordinalParam, long number) {
        if (this.rbnfNumber != null) {
            String r = this.defaultNumericOrdinalRule != null ? this.rbnfNumber.format(number, this.defaultNumericOrdinalRule) : "";
            return r.replaceAll("^[,\\d]*\\d", "");
        }
        return "UNKNOWN";
    }

    @Override
    public String toWords(String cardinal, long number) {
        if (this.rbnf != null) {
            String s;
            String rule = cardinal.startsWith("%") ? cardinal : this.defaultCardinalRule;
            try {
                s = rule != null ? this.rbnf.format(number, rule) : this.rbnf.format(number);
            }
            catch (IllegalArgumentException e) {
                s = this.rbnf.format(number, this.defaultCardinalRule);
            }
            return this.postProcess(s);
        }
        return null;
    }

    @Override
    public String toWords(String cardinal, long number, int wordCase) {
        return this.postProcess(this.wordCase(this.toWords(cardinal, number), wordCase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        if (this.rbnf != null) {
            String word;
            if (ordinalParam == null) {
                word = this.rbnf.format(number);
            } else {
                String rule = this.ordinalParamIndex.get(ordinalParam);
                if (rule == null) {
                    ICUNumbererPE iCUNumbererPE = this;
                    synchronized (iCUNumbererPE) {
                        if (ordinalParam.startsWith("-") && ordinalParam.length() >= 2) {
                            String suffix = ordinalParam.substring(1);
                            for (String ruleSet : this.spelloutOrdinalRulesets) {
                                String two = this.rbnf.format(2L, ruleSet);
                                if (!two.endsWith(suffix)) continue;
                                rule = ruleSet;
                                this.ordinalParamIndex.put(ordinalParam, rule);
                                break;
                            }
                        } else if (ordinalParam.startsWith("2=") && ordinalParam.length() >= 3) {
                            for (String ruleSet : this.spelloutOrdinalRulesets) {
                                String required = ordinalParam.substring(2);
                                String two = this.rbnf.format(2L, ruleSet);
                                if (!two.equalsIgnoreCase(required)) continue;
                                rule = ruleSet;
                                this.ordinalParamIndex.put(ordinalParam, rule);
                                break;
                            }
                        } else if (ordinalParam.startsWith("%")) {
                            for (String pref : preferences) {
                                if (!this.ordinalParamIndex.containsKey(ordinalParam + pref)) continue;
                                ordinalParam = this.ordinalParamIndex.get(ordinalParam + pref);
                                break;
                            }
                            rule = ordinalParam;
                        }
                    }
                }
                if (rule == null) {
                    rule = this.defaultOrdinalRule;
                }
                try {
                    word = this.rbnf.format(number, rule);
                }
                catch (IllegalArgumentException e) {
                    word = this.rbnf.format(number, this.defaultOrdinalRule);
                }
            }
            return this.postProcessOrdinal(this.postProcess(this.wordCase(word, wordCase)), ordinalParam);
        }
        return null;
    }

    public String postProcess(String result) {
        return result;
    }

    public String postProcessOrdinal(String result, String ordinalParam) {
        return result;
    }

    private String wordCase(String s, int wordCase) {
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        if (wordCase == 2) {
            String lang;
            if (s.length() > 1 && Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
                return s;
            }
            StringBuilder result = new StringBuilder();
            boolean precedingLetter = false;
            for (char c : s.toCharArray()) {
                boolean isLetter = Character.isLetter(c);
                result.append(isLetter ? (precedingLetter ? Character.toLowerCase(c) : Character.toUpperCase(c)) : c);
                precedingLetter = isLetter || c == '\u00ad';
            }
            switch (lang = this.locale.getLanguage()) {
                case "en": {
                    result = new StringBuilder(result.toString().replace("And", "and"));
                    break;
                }
                case "de": {
                    result = new StringBuilder(result.toString().replace("Und", "und"));
                    break;
                }
                case "nl": {
                    result = new StringBuilder(result.toString().replace("\u00cbn", "\u00ebn"));
                    break;
                }
                case "af": {
                    result = new StringBuilder(result.toString().replace("En", "en"));
                    break;
                }
                case "da": 
                case "fo": 
                case "is": 
                case "nb": 
                case "nn": {
                    result = new StringBuilder(result.toString().replace("Og", "og"));
                    break;
                }
                case "ga": {
                    result = new StringBuilder(result.toString().replace("A ", "a "));
                    break;
                }
                case "hr": 
                case "ca": {
                    result = new StringBuilder(result.toString().replace("I", "i"));
                    break;
                }
                case "bg": 
                case "mk": 
                case "sr": {
                    result = new StringBuilder(result.toString().replace("\u0418 ", "\u0438 "));
                    break;
                }
                case "mt": {
                    result = new StringBuilder(result.toString().replace("U", "u"));
                    break;
                }
                case "pt": 
                case "sq": {
                    result = new StringBuilder(result.toString().replace("E", "e"));
                    break;
                }
                case "ro": {
                    result = new StringBuilder(result.toString().replace("\u015ei", "\u015fi"));
                    break;
                }
                case "ee": {
                    result = new StringBuilder(result.toString().replace("V\u0254", "v\u0254"));
                    break;
                }
                case "fi": {
                    result = new StringBuilder(result.toString().replace("At", "at"));
                }
            }
            return result.toString();
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        GregorianCalendar cal = new GregorianCalendar(this.locale);
        cal.set(1900, month - 1, 1);
        Date d = cal.getTime();
        String result = this.getDateFormat(MONTH_FULL).format(d);
        if (result.length() > maxWidth) {
            result = this.getDateFormat(MONTH_SHORT).format(d);
        }
        if (result.length() > maxWidth) {
            result = result.substring(0, maxWidth);
        }
        return this.wordCase(result, 2);
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        GregorianCalendar cal = new GregorianCalendar(this.locale);
        cal.set(1900, 0, day);
        Date d = cal.getTime();
        String result = this.getDateFormat(DAY_FULL).format(d);
        if (result.length() > maxWidth) {
            result = this.getDateFormat(DAY_SHORT).format(d);
        }
        if (result.length() > maxWidth) {
            result = result.substring(0, maxWidth);
        }
        return this.wordCase(result, 2);
    }

    static {
        schemeCodes.put("do", numberOrdinalPattern);
        schemeCodes.put("dof", "%digits-ordinal-feminine");
        schemeCodes.put("dom", "%digits-ordinal-masculine");
        schemeCodes.put("doma", "%digits-ordinal-masculine-adjective");
        schemeCodes.put("don", "%digits-ordinal-neuter");
        schemeCodes.put("dor", "%digits-ordinal-reale");
        schemeCodes.put("sc", spelloutCardinalPattern);
        schemeCodes.put("sca", "%spellout-cardinal-alternate2");
        schemeCodes.put("scf", "%spellout-cardinal-feminine");
        schemeCodes.put("scfbc", "%spellout-cardinal-feminine-before-consonant");
        schemeCodes.put("scfi", "%spellout-cardinal-financial");
        schemeCodes.put("scm", "%spellout-cardinal-masculine");
        schemeCodes.put("scmbc", "%spellout-cardinal-masculine-before-consonant");
        schemeCodes.put("scn", "%spellout-cardinal-native");
        schemeCodes.put("scna", "%spellout-cardinal-native-attributive");
        schemeCodes.put("scne", "%spellout-cardinal-neuter");
        schemeCodes.put("scr", "%spellout-cardinal-reale");
        schemeCodes.put("scs", "%spellout-cardinal-sinokorean");
        schemeCodes.put("scv", "%spellout-cardinal-verbose");
        schemeCodes.put("sn", spelloutNumberingPattern);
        schemeCodes.put("snd", "%spellout-numbering-days");
        schemeCodes.put("snv", "%spellout-numbering-verbose");
        schemeCodes.put("sny", "%spellout-numbering-year");
        schemeCodes.put("so", spelloutOrdinalPattern);
        schemeCodes.put("sof", "%spellout-ordinal-feminine");
        schemeCodes.put("sofp", "%spellout-ordinal-feminine-plural");
        schemeCodes.put("som", "%spellout-ordinal-masculine");
        schemeCodes.put("soma", "%spellout-ordinal-masculine-adjective");
        schemeCodes.put("somp", "%spellout-ordinal-masculine-plural");
        schemeCodes.put("son", "%spellout-ordinal-native");
        schemeCodes.put("sonc", "%spellout-ordinal-native-count");
        schemeCodes.put("sone", "%spellout-ordinal-neuter");
        schemeCodes.put("sor", "%spellout-ordinal-reale");
        schemeCodes.put("sos", "%spellout-ordinal-sinokorean");
        schemeCodes.put("sosc", "%spellout-ordinal-sinokorean-count");
        schemeCodes.put("sov", "%spellout-ordinal-verbose");
    }
}

