/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.Mailer2;
import com.sun.mail.util.MailSSLSocketFactory;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SendMail
extends SystemFunction {
    public static OptionsParameter OPTION_DETAILS;

    @Override
    public int getSpecialProperties(Expression[] arguments) {
        return 0;
    }

    private static GroundedValue checkMailProperty(XPathContext context, MapItem emailConfigMap, String keyStr, String errorMessage, SequenceType expectedType) throws XPathException {
        try {
            GroundedValue sequence = emailConfigMap.get(new StringValue(keyStr));
            GroundedValue groundedValue = sequence.materialize();
            if (!expectedType.matches(groundedValue, context.getConfiguration().getTypeHierarchy())) {
                throw new XPathException("saxon:send-mail error: Invalid type for email configuration option " + keyStr, "SXJM0001", context);
            }
            return groundedValue;
        }
        catch (Exception e) {
            if (errorMessage == null) {
                return null;
            }
            throw new XPathException(errorMessage);
        }
    }

    private static InternetAddress parseInternetAddress(String addrStr, XPathContext context) throws XPathException {
        if (addrStr.contains("<")) {
            String[] splitStr = addrStr.split("<");
            String personalName = splitStr[0].substring(0, splitStr[0].length() - 1);
            String address = splitStr[1].substring(0, splitStr[1].length() - 1);
            try {
                return new InternetAddress(address, personalName);
            }
            catch (UnsupportedEncodingException e) {
                throw new XPathException("saxon:send-mail error:" + e.getMessage(), "SXJM0002", context);
            }
        }
        try {
            return new InternetAddress(addrStr);
        }
        catch (AddressException e) {
            throw new XPathException("saxon:send-mail error:" + e.getMessage(), "SXJM0002", context);
        }
    }

    private static InternetAddress[] createRecipients(Sequence seq, XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter = seq.iterate();
        ArrayList<InternetAddress> recipient = new ArrayList<InternetAddress>();
        while ((item = iter.next()) != null) {
            try {
                recipient.add(SendMail.parseInternetAddress(item.getStringValue(), context));
            }
            catch (Exception e) {
                throw new XPathException("sendMail Error:" + e.getMessage(), "SXJM0002", context);
            }
        }
        return recipient.toArray(new InternetAddress[0]);
    }

    private static BodyPart createAttachment(XPathContext context, Item item) throws XPathException, MessagingException {
        String otherStr;
        if (!(item instanceof MapItem)) {
            throw new XPathException("saxon:send-mail error: Invalid attachment type ", "SXJE0051", context);
        }
        MapItem mapItem = (MapItem)item;
        MimeBodyPart attachment = new MimeBodyPart();
        String setFileName = null;
        if (mapItem.get(StringValue.bmp("setFilename")) != null) {
            setFileName = ((Item)SendMail.checkMailProperty(context, mapItem, "setFilename", null, SequenceType.SINGLE_STRING)).getStringValue();
            attachment.setFileName(setFileName);
        }
        if (mapItem.get(StringValue.bmp("contentFromFile")) != null && (otherStr = SendMail.checkMailProperty(context, mapItem, "contentFromFile", null, SequenceType.SINGLE_STRING).getUnicodeStringValue().toString()) != null) {
            FileDataSource source = new FileDataSource(otherStr);
            attachment.setDataHandler(new DataHandler((DataSource)source));
            if (setFileName == null) {
                attachment.setFileName(source.getName());
            }
            return attachment;
        }
        if (mapItem.get(StringValue.bmp("contentFromURI")) != null && (otherStr = ((Item)SendMail.checkMailProperty(context, mapItem, "contentFromURI", null, SequenceType.SINGLE_STRING)).getUnicodeStringValue().toString()) != null) {
            URL uri;
            try {
                uri = new URL(otherStr);
            }
            catch (MalformedURLException e) {
                throw new XPathException("Error in attachment value cotnentFromURL: " + e.getMessage(), "SXJE0051", context);
            }
            attachment.setDataHandler(new DataHandler(uri));
            return attachment;
        }
        if (mapItem.get(StringValue.bmp("stringContent")) != null) {
            otherStr = ((Item)SendMail.checkMailProperty(context, mapItem, "stringContent", null, SequenceType.SINGLE_STRING)).getUnicodeStringValue().toString();
            if (otherStr != null) {
                attachment.setText(otherStr);
                return attachment;
            }
        } else if (mapItem.get(StringValue.bmp("contentFromString")) != null && (otherStr = ((Item)SendMail.checkMailProperty(context, mapItem, "contentFromString", null, SequenceType.SINGLE_STRING)).getUnicodeStringValue().toString()) != null) {
            attachment.setText(otherStr);
            return attachment;
        }
        throw new XPathException("Invalid name/number of arguments  for attachment map", "SXJE0051", context);
    }

    private String toStringOrNull(Sequence value) {
        try {
            if (value == null) {
                return null;
            }
            Item head = value.head();
            return head == null ? null : head.getStringValue();
        }
        catch (XPathException e) {
            return null;
        }
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        int port;
        String subjecti = arguments[1].head().getStringValue();
        Item contentItem = arguments[2].head();
        MapItem emailConfigMap = (MapItem)arguments[0].head();
        Map<String, GroundedValue> options = OPTION_DETAILS.processSuppliedOptions(emailConfigMap, context);
        String subject = "";
        String server = this.toStringOrNull(options.get("smtp-server"));
        String sender = this.toStringOrNull(options.get("from"));
        String username = this.toStringOrNull(options.get("username"));
        String password = this.toStringOrNull(options.get("password"));
        String realName = this.toStringOrNull(options.get("realName"));
        GroundedValue toEmail = options.get("to").materialize();
        GroundedValue cc = options.get("cc").materialize();
        GroundedValue bcc = options.get("bcc").materialize();
        String portNumber = this.toStringOrNull(options.get("port"));
        try {
            port = portNumber == null ? 25 : Integer.parseInt(portNumber);
        }
        catch (NumberFormatException e) {
            throw new XPathException("saxon:send-mail: Invalid port number " + e.getMessage(), "SXJM0001", context);
        }
        String htmlValue = this.toStringOrNull(options.get("html"));
        boolean htmlOption = "true".equals(htmlValue);
        boolean sslEnabled = options.get("ssl").head().effectiveBooleanValue();
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.smtp.host", server);
        mailProps.setProperty("mail.smtp.port", port + "");
        mailProps.setProperty("mail.smtp.user", username);
        mailProps.setProperty("mail.smtp.auth", "true");
        mailProps.setProperty("mail.debug", "false");
        if (sslEnabled) {
            MailSSLSocketFactory sf = null;
            try {
                sf = new MailSSLSocketFactory();
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            sf.setTrustAllHosts(true);
            mailProps.put("mail.smtp.ssl.trust", server);
            mailProps.put("mail.smtp.ssl.socketFactory", sf);
            mailProps.setProperty("mail.smtp.starttls.enable", "true");
            mailProps.setProperty("mail.smtp.socketFactory.port", port + "");
            mailProps.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            mailProps.setProperty("mail.smtp.socketFactory.fallback", "false");
        }
        for (KeyValuePair pair : emailConfigMap.keyValuePairs()) {
            GroundedValue val;
            Item first;
            if (!pair.key.getStringValue().startsWith("mail.") || (first = (val = pair.value).head()) == null) continue;
            mailProps.setProperty(pair.key.getStringValue(), first.getStringValue());
        }
        Mailer2 mailer = new Mailer2(mailProps, password);
        try {
            mailer.setSender(sender, realName);
        }
        catch (Exception ex) {
            throw new XPathException("saxon:send-mail error in sender details: " + ex.getMessage(), "SXJM0001", context);
        }
        mailer.addRecipients(Message.RecipientType.TO, (Address[])SendMail.createRecipients(toEmail, context));
        if (cc.getLength() > 0) {
            mailer.addRecipients(Message.RecipientType.CC, (Address[])SendMail.createRecipients(cc, context));
        }
        if (bcc.getLength() > 0) {
            mailer.addRecipients(Message.RecipientType.BCC, (Address[])SendMail.createRecipients(bcc, context));
        }
        if (subjecti != null) {
            subject = subjecti;
        }
        if (arguments.length == 4) {
            Item item;
            Sequence attachments = arguments[3];
            SequenceIterator iter = attachments.iterate();
            while ((item = iter.next()) != null) {
                try {
                    mailer.addBodyPart(SendMail.createAttachment(context, item));
                }
                catch (MessagingException e) {
                    throw new XPathException("Error in send-mail attachment(s): " + e.getMessage(), "SXJM0002", context);
                }
            }
        }
        String content = "";
        if (contentItem instanceof StringValue) {
            content = contentItem.getStringValue();
        } else if (contentItem instanceof Item || htmlOption) {
            NodeInfo nodei;
            AxisIterator axisItr = ((NodeInfo)contentItem).iterateAxis(3, NodeKindTest.ELEMENT);
            while ((nodei = axisItr.next()) != null) {
                if (!nodei.getLocalPart().equals("html")) continue;
                htmlOption = true;
            }
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            Properties props = new Properties();
            props.setProperty("method", "html");
            props.setProperty("indent", "yes");
            try {
                QueryResult.serialize((NodeInfo)contentItem, (Result)sr, props);
            }
            catch (XPathException err) {
                throw new XPathException("Serialization failed: " + err.getMessage(), "SXJM0001", context);
            }
            content = sw.toString();
        }
        try {
            mailer.sendMail(subject, content);
        }
        catch (Exception err) {
            throw new XPathException("Send-mail authentication failure: " + err.getMessage(), "SXJM0002", context);
        }
        return BooleanValue.TRUE;
    }

    static {
        OptionsParameter options = new OptionsParameter();
        options.addRequiredOption("smtp-server", SequenceType.SINGLE_STRING);
        options.addRequiredOption("to", SequenceType.STRING_SEQUENCE);
        options.addAllowedOption("cc", SequenceType.STRING_SEQUENCE, EmptyAtomicSequence.getInstance());
        options.addAllowedOption("bcc", SequenceType.STRING_SEQUENCE, EmptyAtomicSequence.getInstance());
        options.addAllowedOption("from", SequenceType.SINGLE_STRING);
        options.addAllowedOption("username", SequenceType.SINGLE_STRING);
        options.addAllowedOption("password", SequenceType.SINGLE_STRING);
        options.addAllowedOption("realname", SequenceType.SINGLE_STRING);
        options.addAllowedOption("html", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        options.addAllowedOption("ssl", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        options.addAllowedOption("port", SequenceType.SINGLE_INTEGER, new Int64Value(25L));
        options.setErrorCodeForAbsentValue("SXJM0001");
        options.setAllowCastFromString(true);
        OPTION_DETAILS = options;
    }
}

