/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.JavaExtensionFunctionFactory;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.expr.JavaExtensionFunctionCall;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;

public class JavaExtensionLibrary
implements FunctionLibrary {
    private final ProfessionalConfiguration config;
    private JavaExtensionFunctionFactory functionFactory;
    private HashMap<String, Class<?>> explicitMappings = new HashMap(10);
    private boolean strictUriFormat = true;
    private static final Class[] NO_PARAMS = new Class[0];

    public JavaExtensionLibrary(ProfessionalConfiguration config) {
        this.config = config;
        this.functionFactory = new JavaExtensionFunctionFactory(config);
    }

    public void setExtensionFunctionFactory(JavaExtensionFunctionFactory factory) {
        this.functionFactory = factory;
    }

    public JavaExtensionFunctionFactory getExtensionFunctionFactory() {
        return this.functionFactory;
    }

    public boolean isStrictJavaUriFormat() {
        return this.strictUriFormat;
    }

    public void setStrictJavaUriFormat(boolean strict) {
        this.strictUriFormat = strict;
    }

    public synchronized void declareJavaClass(String uri, Class theClass) {
        this.explicitMappings.put(uri, theClass);
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        Configuration config = staticContext.getConfiguration();
        int arity = functionName.getArity();
        Object[] params = new SuppliedParameterReference[arity];
        Arrays.fill(params, new SuppliedParameterReference(-1));
        Expression call = this.bind(functionName, (Expression[])params, null, staticContext, new ArrayList<String>());
        if (call instanceof JavaExtensionFunctionCall) {
            Object[] argTypes = new SequenceType[arity];
            Arrays.fill(argTypes, SequenceType.ANY_SEQUENCE);
            SpecificFunctionType ftype = new SpecificFunctionType((SequenceType[])argTypes, SequenceType.ANY_SEQUENCE);
            ((JavaExtensionFunctionCall)call).prepareForDynamicCall(config);
            return new CallableFunction(functionName, (Callable)((Object)call), (FunctionItemType)ftype);
        }
        if (call instanceof UnresolvedExtensionFunctionCall) {
            Object[] argTypes = new SequenceType[arity];
            Arrays.fill(argTypes, SequenceType.ANY_SEQUENCE);
            SpecificFunctionType ftype = new SpecificFunctionType((SequenceType[])argTypes, SequenceType.ANY_SEQUENCE);
            return new CallableFunction(functionName, (Callable)((Object)call), (FunctionItemType)ftype);
        }
        return null;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        Object[] params = new SuppliedParameterReference[functionName.getArity()];
        Arrays.fill(params, new SuppliedParameterReference(-1));
        IndependentContext staticContext = new IndependentContext(this.config);
        Expression call = this.bind(functionName, (Expression[])params, null, staticContext, new ArrayList<String>());
        return call != null;
    }

    @Override
    public Expression bind(SymbolicName.F symbolicName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        Class reqClass;
        String uri;
        boolean debug = this.config.getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS);
        StructuredQName functionName = symbolicName.getComponentName();
        String path = uri = functionName.getNamespaceUri().toString();
        int q = uri.indexOf(63);
        if (q > 0) {
            path = uri.substring(0, q);
        }
        if ((reqClass = this.getExternalJavaClass(path, functionName.getLocalPart(), debug)) == null) {
            if (uri.startsWith("java:")) {
                reasons.add("Cannot load Java class " + path);
            }
            return null;
        }
        if (keywords != null && !keywords.isEmpty()) {
            reasons.add("Calls to external Java functions cannot use keyword arguments");
            return null;
        }
        Logger diag = this.config.getLogger();
        if (debug) {
            diag.info("Looking for method " + functionName.getLocalPart() + " in namespace " + functionName.getNamespaceUri());
            diag.info("Number of actual arguments = " + staticArgs.length);
        }
        if (!this.config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            if (debug) {
                diag.info("Calls to extension functions have been disabled");
            }
            reasons.add("Calls to extension functions have been disabled");
            return null;
        }
        if (!this.config.isLicensedFeature(8)) {
            if (debug) {
                diag.info("Calls to extension functions are not permitted without a Saxon license");
            }
            reasons.add("Calls to extension functions are not permitted without a Saxon license");
            return null;
        }
        String problem = null;
        ArrayList<AccessibleObject> candidateMethods = new ArrayList<AccessibleObject>(10);
        Class<?> resultClass = null;
        if (debug) {
            diag.info("Looking in Java class " + reqClass);
        }
        int numArgs = staticArgs.length;
        String methodName = this.getMethodNameFromLocalName(functionName.getNamespaceUri().toString(), functionName.getLocalPart(), debug);
        if ("new".equals(methodName)) {
            Constructor<?>[] constructors;
            int mod;
            if (debug) {
                diag.info("Looking for a constructor");
            }
            if (Modifier.isAbstract(mod = reqClass.getModifiers())) {
                problem = "Class " + reqClass + " is abstract";
            } else if (Modifier.isInterface(mod)) {
                problem = reqClass + " is an interface";
            } else if (Modifier.isPrivate(mod)) {
                problem = "Class " + reqClass + " is private";
            } else if (Modifier.isProtected(mod)) {
                problem = "Class " + reqClass + " is protected";
            }
            if (problem != null) {
                if (debug) {
                    diag.info("Cannot construct an instance: " + problem);
                }
                reasons.add(problem);
                return null;
            }
            for (Constructor<?> theConstructor : constructors = reqClass.getConstructors()) {
                if (debug) {
                    diag.info("Found a constructor with " + theConstructor.getParameterTypes().length + " arguments");
                }
                if (theConstructor.getParameterTypes().length != numArgs) continue;
                candidateMethods.add(theConstructor);
            }
            if (candidateMethods.isEmpty()) {
                problem = "No constructor with " + numArgs + (numArgs == 1 ? " parameter" : " parameters") + " found in class " + reqClass.getName();
                if (debug) {
                    diag.info(problem);
                }
                reasons.add(problem);
                return null;
            }
        } else {
            Field[] fields;
            int significantArgs;
            boolean isStatic;
            Method[] methods = reqClass.getMethods();
            boolean consistentReturnType = true;
            for (Method theMethod : methods) {
                if (debug) {
                    if (theMethod.getName().equals(methodName)) {
                        diag.info("Trying method " + theMethod.getName() + ": name matches");
                        if (!Modifier.isPublic(theMethod.getModifiers())) {
                            diag.info(" -- but the method is not public");
                        } else if (theMethod.isSynthetic()) {
                            diag.info(" -- but the method is synthetic");
                        }
                    } else {
                        diag.info("Trying method " + theMethod.getName() + ": name does not match");
                    }
                }
                if (!theMethod.getName().equals(methodName) || !Modifier.isPublic(theMethod.getModifiers()) || theMethod.isSynthetic()) continue;
                if (consistentReturnType) {
                    if (resultClass == null) {
                        resultClass = theMethod.getReturnType();
                    } else {
                        consistentReturnType = theMethod.getReturnType() == resultClass;
                    }
                }
                Class<?>[] theParameterTypes = theMethod.getParameterTypes();
                isStatic = Modifier.isStatic(theMethod.getModifiers());
                if (debug) {
                    diag.info("Method is " + (isStatic ? "" : "not ") + "static");
                }
                int n = significantArgs = isStatic ? numArgs : numArgs - 1;
                if (significantArgs < 0) continue;
                if (debug) {
                    if (isStatic) {
                        diag.info("Method has " + theParameterTypes.length + " argument" + (theParameterTypes.length == 1 ? "" : "s") + "; expecting " + significantArgs);
                    } else {
                        diag.info("Method has " + theParameterTypes.length + " argument" + (theParameterTypes.length == 1 ? "" : "s") + "; expecting " + numArgs + " plus one for the target object");
                    }
                }
                if (theParameterTypes.length == significantArgs && (significantArgs == 0 || theParameterTypes[0] != XPathContext.class)) {
                    if (debug) {
                        diag.info("Found a candidate method:");
                        diag.info("    " + theMethod);
                    }
                    candidateMethods.add(theMethod);
                }
                if (theParameterTypes.length != significantArgs + 1 || theParameterTypes[0] != XPathContext.class) continue;
                if (debug) {
                    diag.info("Method is a candidate because first argument is XPathContext");
                }
                candidateMethods.add(theMethod);
            }
            for (Field theField : fields = reqClass.getFields()) {
                if (debug) {
                    if (theField.getName().equals(methodName)) {
                        diag.info("Trying field " + theField.getName() + ": name matches");
                        if (!Modifier.isPublic(theField.getModifiers())) {
                            diag.info(" -- but the field is not public");
                        }
                    } else {
                        diag.info("Trying field " + theField.getName() + ": name does not match");
                    }
                }
                if (!theField.getName().equals(methodName) || !Modifier.isPublic(theField.getModifiers())) continue;
                if (consistentReturnType) {
                    if (resultClass == null) {
                        resultClass = theField.getType();
                    } else {
                        consistentReturnType = theField.getType() == resultClass;
                    }
                }
                isStatic = Modifier.isStatic(theField.getModifiers());
                if (debug) {
                    diag.info("Field is " + (isStatic ? "" : "not ") + "static");
                }
                int n = significantArgs = isStatic ? numArgs : numArgs - 1;
                if (significantArgs != 0) continue;
                if (debug) {
                    diag.info("Found a candidate field:");
                    diag.info("    " + theField);
                }
                candidateMethods.add(theField);
            }
            if (candidateMethods.isEmpty()) {
                problem = "No method or field matching " + methodName + " with " + numArgs + (numArgs == 1 ? " parameter" : " parameters") + " found in class " + reqClass.getName();
                if (debug) {
                    diag.info(problem);
                }
                reasons.add(problem);
                return null;
            }
        }
        if (candidateMethods.size() > 1) {
            if (debug) {
                diag.info("Postponing decision until after type-checking");
            }
            return new UnresolvedExtensionFunctionCall(functionName, reqClass, candidateMethods, staticArgs, this.config, debug);
        }
        return this.functionFactory.makeExtensionFunctionCall(functionName, reqClass, (AccessibleObject)candidateMethods.get(0), staticArgs, this.config);
    }

    private AccessibleObject getBestFit(List<AccessibleObject> candidateMethods, SequenceType[] argTypes, Class theClass, boolean debug) {
        int[] pref_i;
        int i;
        Logger diag = this.config.getLogger();
        int candidates = candidateMethods.size();
        if (candidates == 1) {
            return candidateMethods.get(0);
        }
        if (debug) {
            diag.info("Finding best fit method for arguments");
        }
        boolean[] eliminated = new boolean[candidates];
        Arrays.fill(eliminated, false);
        if (debug) {
            for (i = 0; i < candidates; ++i) {
                pref_i = this.getConversionPreferences(argTypes, candidateMethods.get(i), theClass);
                diag.info("Trying option " + (i + 1) + ": " + candidateMethods.get(i));
                if (pref_i == null) {
                    diag.info("Arguments cannot be converted to required types");
                    continue;
                }
                StringBuilder fsb = new StringBuilder(100);
                fsb.append('[');
                for (int p = 0; p < pref_i.length; ++p) {
                    if (p != 0) {
                        fsb.append(", ");
                    }
                    fsb.append(Integer.toString(pref_i[p]));
                }
                fsb.append("]");
                diag.info("Conversion preferences are " + fsb.toString());
            }
        }
        for (i = 0; i < candidates; ++i) {
            pref_i = this.getConversionPreferences(argTypes, candidateMethods.get(i), theClass);
            if (pref_i == null) {
                eliminated[i] = true;
            }
            if (eliminated[i]) continue;
            for (int j = i + 1; j < candidates; ++j) {
                if (eliminated[j]) continue;
                int[] pref_j = this.getConversionPreferences(argTypes, candidateMethods.get(j), theClass);
                if (pref_j == null) {
                    eliminated[j] = true;
                    continue;
                }
                for (int k = 0; k < pref_j.length; ++k) {
                    if (pref_i[k] > pref_j[k] && !eliminated[i]) {
                        eliminated[i] = true;
                        if (debug) {
                            diag.info("Eliminating option " + i);
                        }
                    }
                    if (pref_i[k] >= pref_j[k] || eliminated[j]) continue;
                    eliminated[j] = true;
                    if (!debug) continue;
                    diag.info("Eliminating option " + j);
                }
            }
        }
        int remaining = 0;
        AccessibleObject theMethod = null;
        for (int r = 0; r < candidates; ++r) {
            if (eliminated[r]) continue;
            theMethod = candidateMethods.get(r);
            ++remaining;
        }
        if (debug) {
            diag.info("Number of candidate methods remaining: " + remaining);
        }
        if (remaining == 0) {
            if (debug) {
                diag.info("There are " + candidates + " candidate Java methods matching the function name, but none is a unique best match");
            }
            return null;
        }
        if (remaining > 1) {
            if (debug) {
                diag.info("There are several Java methods that match the function name equally well");
            }
            int countStatic = 0;
            for (int r = 0; r < candidates; ++r) {
                if (eliminated[r] || !(candidateMethods.get(r) instanceof Method) || !Modifier.isStatic(((Method)candidateMethods.get(r)).getModifiers())) continue;
                theMethod = candidateMethods.get(r);
                ++countStatic;
            }
            if (countStatic == 1) {
                if (debug) {
                    diag.info("Choosing the static method in preference");
                }
            } else {
                return null;
            }
        }
        return theMethod;
    }

    private int[] getConversionPreferences(SequenceType[] argTypes, AccessibleObject method, Class theClass) {
        boolean isStatic;
        Class<?>[] params;
        int firstArg;
        if (method instanceof Constructor) {
            firstArg = 0;
            params = ((Constructor)method).getParameterTypes();
        } else if (method instanceof Method) {
            isStatic = Modifier.isStatic(((Method)method).getModifiers());
            firstArg = isStatic ? 0 : 1;
            params = ((Method)method).getParameterTypes();
        } else if (method instanceof Field) {
            isStatic = Modifier.isStatic(((Field)method).getModifiers());
            firstArg = isStatic ? 0 : 1;
            params = NO_PARAMS;
        } else {
            throw new AssertionError((Object)("property " + method + " was neither constructor, method, nor field"));
        }
        int noOfArgs = argTypes.length;
        int[] preferences = new int[noOfArgs];
        int firstParam = 0;
        if (params.length > 0 && params[0] == XPathContext.class) {
            firstParam = 1;
        }
        for (int i = firstArg; i < noOfArgs; ++i) {
            preferences[i] = this.getConversionPreference(argTypes[i], params[i + firstParam - firstArg]);
            if (preferences[i] != -1) continue;
            return null;
        }
        if (firstArg == 1) {
            preferences[0] = this.getConversionPreference(argTypes[0], theClass);
            if (preferences[0] == -1) {
                return null;
            }
        }
        return preferences;
    }

    private int getConversionPreference(SequenceType argType, Class<?> required) {
        ItemType itemType = argType.getPrimaryType();
        int cardinality = argType.getCardinality();
        if (required == Object.class) {
            return 100;
        }
        if (required.isAssignableFrom(SequenceIterator.class)) {
            return 26;
        }
        if (required.isAssignableFrom(Sequence.class)) {
            return 25;
        }
        if (required.isAssignableFrom(GroundedValue.class)) {
            return 24;
        }
        if (required.isAssignableFrom(Item.class)) {
            return 23;
        }
        if (required.isAssignableFrom(NodeInfo.class)) {
            return 22;
        }
        if (required.isAssignableFrom(TreeInfo.class)) {
            return 21;
        }
        if (required.isAssignableFrom(AtomicValue.class)) {
            return 20;
        }
        if (Cardinality.allowsMany(cardinality)) {
            if (CollectionFn.class.isAssignableFrom(required)) {
                return 30;
            }
            if (required.isArray()) {
                Class<?> arrayMember = required.getComponentType();
                return this.atomicConversionPreference(itemType.getPrimitiveType(), arrayMember);
            }
            return 80;
        }
        if (Type.isNodeType(itemType)) {
            return 80;
        }
        if (itemType instanceof JavaExternalObjectType) {
            Class<?> ext = ((JavaExternalObjectType)itemType).getJavaClass();
            if (required.isAssignableFrom(ext)) {
                return 10;
            }
            return -1;
        }
        int primitiveType = itemType.getPrimitiveType();
        return this.atomicConversionPreference(primitiveType, required);
    }

    protected int atomicConversionPreference(int primitiveType, Class<?> required) {
        if (required == Object.class) {
            return 100;
        }
        switch (primitiveType) {
            case 513: {
                if (required.isAssignableFrom(StringValue.class)) {
                    return 50;
                }
                if (required == String.class) {
                    return 51;
                }
                if (required == CharSequence.class) {
                    return 52;
                }
                return -1;
            }
            case 517: {
                if (required.isAssignableFrom(DoubleValue.class)) {
                    return 50;
                }
                if (required == Double.TYPE) {
                    return 50;
                }
                if (required == Double.class) {
                    return 51;
                }
                return -1;
            }
            case 516: {
                if (required.isAssignableFrom(FloatValue.class)) {
                    return 50;
                }
                if (required == Float.TYPE) {
                    return 50;
                }
                if (required == Float.class) {
                    return 51;
                }
                if (required == Double.TYPE) {
                    return 52;
                }
                if (required == Double.class) {
                    return 53;
                }
                return -1;
            }
            case 515: {
                if (required.isAssignableFrom(BigDecimalValue.class)) {
                    return 50;
                }
                if (required == BigDecimal.class) {
                    return 50;
                }
                if (required == Double.TYPE) {
                    return 51;
                }
                if (required == Double.class) {
                    return 52;
                }
                if (required == Float.TYPE) {
                    return 53;
                }
                if (required == Float.class) {
                    return 54;
                }
                return -1;
            }
            case 533: {
                if (required.isAssignableFrom(Int64Value.class)) {
                    return 50;
                }
                if (required == BigInteger.class) {
                    return 51;
                }
                if (required == BigDecimal.class) {
                    return 52;
                }
                if (required == Long.TYPE) {
                    return 53;
                }
                if (required == Long.class) {
                    return 54;
                }
                if (required == Integer.TYPE) {
                    return 55;
                }
                if (required == Integer.class) {
                    return 56;
                }
                if (required == Short.TYPE) {
                    return 57;
                }
                if (required == Short.class) {
                    return 58;
                }
                if (required == Byte.TYPE) {
                    return 59;
                }
                if (required == Byte.class) {
                    return 60;
                }
                if (required == Double.TYPE) {
                    return 61;
                }
                if (required == Double.class) {
                    return 62;
                }
                if (required == Float.TYPE) {
                    return 63;
                }
                if (required == Float.class) {
                    return 64;
                }
                return -1;
            }
            case 514: {
                if (required.isAssignableFrom(BooleanValue.class)) {
                    return 50;
                }
                if (required == Boolean.TYPE) {
                    return 51;
                }
                if (required == Boolean.class) {
                    return 52;
                }
                return -1;
            }
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                if (required.isAssignableFrom(DateValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(LocalDate.class)) {
                    return 51;
                }
                if (required.isAssignableFrom(OffsetDateTime.class)) {
                    return 52;
                }
                if (required.isAssignableFrom(LocalDateTime.class)) {
                    return 53;
                }
                if (required.isAssignableFrom(ZonedDateTime.class)) {
                    return 54;
                }
                if (required.isAssignableFrom(Instant.class)) {
                    return 55;
                }
                if (required.isAssignableFrom(Date.class)) {
                    return 56;
                }
                return -1;
            }
            case 519: {
                if (required.isAssignableFrom(DateTimeValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(OffsetDateTime.class)) {
                    return 51;
                }
                if (required.isAssignableFrom(LocalDateTime.class)) {
                    return 52;
                }
                if (required.isAssignableFrom(ZonedDateTime.class)) {
                    return 53;
                }
                if (required.isAssignableFrom(Instant.class)) {
                    return 54;
                }
                if (required.isAssignableFrom(Date.class)) {
                    return 55;
                }
                return -1;
            }
            case 520: {
                if (required.isAssignableFrom(TimeValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(OffsetDateTime.class)) {
                    return 51;
                }
                if (required.isAssignableFrom(ZonedDateTime.class)) {
                    return 52;
                }
                if (required.isAssignableFrom(Instant.class)) {
                    return 53;
                }
                if (required.isAssignableFrom(Date.class)) {
                    return 54;
                }
                return -1;
            }
            case 518: 
            case 633: 
            case 634: {
                if (required.isAssignableFrom(DurationValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 529: {
                if (required.isAssignableFrom(AnyURIValue.class)) {
                    return 50;
                }
                if (required == URI.class) {
                    return 51;
                }
                if (required == URL.class) {
                    return 52;
                }
                if (required == String.class) {
                    return 53;
                }
                if (required == CharSequence.class) {
                    return 53;
                }
                return -1;
            }
            case 530: {
                if (required.isAssignableFrom(QualifiedNameValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(QName.class)) {
                    return 51;
                }
                return -1;
            }
            case 528: {
                if (required.isAssignableFrom(Base64BinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 527: {
                if (required.isAssignableFrom(HexBinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 631: {
                return 50;
            }
        }
        if (required.isAssignableFrom(AtomicValue.class)) {
            return 50;
        }
        if (required == String.class) {
            return 99;
        }
        return -1;
    }

    protected Class getExternalJavaClass(String uri, String localName, boolean debug) {
        Object c = this.explicitMappings.get(uri);
        if (c != null) {
            return c;
        }
        try {
            if (uri.startsWith("java:")) {
                String path = uri.substring(5);
                int q = path.indexOf(63);
                if (q > 0) {
                    path = path.substring(0, q);
                }
                c = this.config.getClass(path, debug);
            } else if (uri.equals("http://saxon.sf.net/java-type")) {
                int lastDot = localName.lastIndexOf(".");
                if (lastDot < 1) {
                    return null;
                }
                String typename = localName.substring(0, lastDot);
                String className = JavaExternalObjectType.localNameToClassName(typename);
                c = this.config.getClass(className, debug);
            } else if (this.strictUriFormat) {
                c = null;
            } else {
                int slash = uri.lastIndexOf(47);
                c = slash < 0 ? this.config.getClass(uri, debug) : (slash == uri.length() - 1 ? null : this.config.getClass(uri.substring(slash + 1), debug));
                if (c != null) {
                    this.declareJavaClass(uri, (Class)c);
                }
            }
            return c;
        }
        catch (XPathException err) {
            return null;
        }
    }

    protected String getMethodNameFromLocalName(String uri, String localName, boolean debug) {
        if (uri.equals("http://saxon.sf.net/java-type")) {
            int lastDot = localName.lastIndexOf(46);
            return localName.substring(lastDot + 1);
        }
        return JavaExtensionFunctionCall.toCamelCase(localName, debug, this.config.getLogger());
    }

    @Override
    public FunctionLibrary copy() {
        JavaExtensionLibrary jel = new JavaExtensionLibrary(this.config);
        jel.explicitMappings = new HashMap(this.explicitMappings);
        return jel;
    }

    public class UnresolvedExtensionFunctionCall
    extends FunctionCall
    implements Callable {
        private final StructuredQName name;
        private final transient List<AccessibleObject> candidateMethods;
        private final Class theClass;
        private final boolean debug;
        private final BuiltInFunctionSet.Entry details = new BuiltInFunctionSet.Entry();

        public UnresolvedExtensionFunctionCall(StructuredQName functionName, Class theClass, List<AccessibleObject> candidateMethods, Expression[] staticArgs, Configuration config, boolean debug) {
            this.details.name = functionName;
            this.details.maxArity = staticArgs.length;
            this.details.paramTypes = new SequenceType[staticArgs.length];
            this.details.itemType = AnyItemType.getInstance();
            this.details.cardinality = 57344;
            this.details.usage = new OperandUsage[staticArgs.length];
            this.details.resultIfEmpty = SequenceTool.makeSequenceArray(staticArgs.length);
            this.setArguments(staticArgs);
            this.name = functionName;
            this.theClass = theClass;
            this.candidateMethods = candidateMethods;
            this.debug = debug;
        }

        @Override
        public StructuredQName getFunctionName() {
            return this.name;
        }

        @Override
        public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
            this.typeCheckChildren(visitor, contextInfo);
            SequenceType[] argTypes = new SequenceType[this.getArity()];
            for (int i = 0; i < this.getArity(); ++i) {
                Expression arg = this.getArg(i);
                ItemType itemType = arg.getItemType();
                int card = arg.getCardinality();
                if (itemType == ErrorType.getInstance() && arg instanceof VariableReference) {
                    SequenceType requiredType = ((VariableReference)arg).getBinding().getRequiredType();
                    itemType = requiredType.getPrimaryType();
                    card = requiredType.getCardinality();
                }
                this.details.arg(i, itemType, 57344, null);
                argTypes[i] = SequenceType.makeSequenceType(itemType, card);
            }
            AccessibleObject method = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, argTypes, this.theClass, this.debug);
            this.typeCheckChildren(visitor, contextInfo);
            if (method == null) {
                for (int i = 0; i < this.getArity(); ++i) {
                    Expression arg = this.getArg(i);
                    ItemType itemType = arg.getItemType();
                    argTypes[i] = SequenceType.makeSequenceType(itemType, arg.getCardinality());
                }
                method = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, argTypes, this.theClass, this.debug);
            }
            if (method == null) {
                throw new XPathException("There is more than one method matching the function call " + this.getFunctionName().getEQName() + "#" + this.getArity() + ", and there is insufficient type information to determine which one should be used", "XPST0017").withLocation(this.getLocation()).asStaticError();
            }
            Expression call = JavaExtensionLibrary.this.functionFactory.makeExtensionFunctionCall(this.getFunctionName(), this.theClass, method, this.getArguments(), JavaExtensionLibrary.this.config);
            ExpressionTool.copyLocationInfo(this, call);
            return call.typeCheck(visitor, contextInfo);
        }

        public Expression resolve(SequenceType[] argTypes) throws XPathException {
            AccessibleObject method = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, argTypes, this.theClass, this.debug);
            if (method == null) {
                throw new XPathException("There is more than one method matching the function call " + this.getFunctionName().getEQName() + "#" + this.getArity() + ", and there is insufficient type information to determine which one should be used", "XPST0017").withLocation(this.getLocation()).asStaticError();
            }
            Expression call = JavaExtensionLibrary.this.functionFactory.makeExtensionFunctionCall(this.getFunctionName(), this.theClass, method, this.getArguments(), JavaExtensionLibrary.this.config);
            ExpressionTool.copyLocationInfo(this, call);
            return call;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Expression[] args = new Literal[arguments.length];
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            SequenceType[] argTypes = new SequenceType[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                GroundedValue val = arguments[i].materialize();
                ItemType itemType = SequenceTool.getItemType(val, th);
                int cardinality = SequenceTool.getCardinality(val);
                argTypes[i] = SequenceType.makeSequenceType(itemType, cardinality);
                args[i] = Literal.makeLiteral(val);
            }
            AccessibleObject method = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, argTypes, this.theClass, false);
            if (method == null) {
                XPathException err = new XPathException("There is more than one method matching the dynamic function call " + this.getFunctionName().getEQName() + "#" + this.getArity() + ", and there is insufficient type information to determine which one should be used", "XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            Expression call = JavaExtensionLibrary.this.functionFactory.makeExtensionFunctionCall(this.getFunctionName(), this.theClass, method, args, JavaExtensionLibrary.this.config);
            if (call instanceof JavaExtensionFunctionCall) {
                ((JavaExtensionFunctionCall)call).prepareForDynamicCall(context.getConfiguration());
            }
            try {
                return SequenceTool.toGroundedValue(call.iterate(context));
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }

        @Override
        public FunctionItem getTargetFunction(XPathContext context) {
            Object[] argTypes = new SequenceType[this.getArity()];
            Arrays.fill(argTypes, SequenceType.ANY_SEQUENCE);
            SpecificFunctionType ftype = new SpecificFunctionType((SequenceType[])argTypes, SequenceType.ANY_SEQUENCE);
            SymbolicName.F sName = new SymbolicName.F(this.getFunctionName(), this.getArity());
            return new CallableFunction(sName, (Callable)this, (FunctionItemType)ftype);
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        protected int computeCardinality() {
            return 57344;
        }

        @Override
        public Expression copy(RebindingMap rebindings) {
            return this;
        }

        @Override
        public Elaborator getElaborator() {
            throw new UnsupportedOperationException();
        }
    }
}

