/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class AncestorCharacteristic
extends Characteristic {
    private final Pattern pattern;
    private final boolean isParent;

    public AncestorCharacteristic(Pattern pattern, boolean isParent) {
        this.pattern = pattern;
        this.isParent = isParent;
    }

    @Override
    public BooleanValue evaluate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (!(item instanceof NodeInfo)) {
            return BooleanValue.FALSE;
        }
        if (this.isParent) {
            return BooleanValue.get(this.pattern.matchesItem(((NodeInfo)item).getParent(), context));
        }
        for (NodeInfo a = (NodeInfo)item; a != null; a = a.getParent()) {
            if (!this.pattern.matchesItem(a, context)) continue;
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ (this.isParent ? 8484 : 7373);
    }

    public boolean equals(Object obj) {
        return obj instanceof AncestorCharacteristic && this.pattern.isEqual(((AncestorCharacteristic)obj).pattern) && this.isParent == ((AncestorCharacteristic)obj).isParent;
    }

    public String toString() {
        return this.pattern + (this.isParent ? "/" : "//");
    }
}

