/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class NewMapStreamer
extends StreamingAdjunct
implements FeedMaker {
    private Inversion[] actionInversions;

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression block = exp.getArg(0);
        if (!(block instanceof Block)) {
            return super.computeStreamability(contextInfo, reasons);
        }
        Operand[] children = ((Block)block).getOperanda();
        if (children.length == 0) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        Sweep sweep = Sweep.MOTIONLESS;
        for (Operand o : children) {
            Expression e = o.getChildExpression();
            if (!e.isCallOn(MapFunctionSet.MapEntry.class)) {
                return super.computeStreamability(contextInfo, reasons);
            }
            PostureAndSweep operandPS = Streamability.getStreamability(e, contextInfo, reasons);
            if (operandPS.getPosture() == Posture.ROAMING || operandPS.getSweep() == Sweep.FREE_RANGING) {
                Streamability.setPostureAndSweep(block, PostureAndSweep.ROAMING_AND_FREE_RANGING);
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            sweep = Streamability.wider(sweep, operandPS.getSweep());
        }
        PostureAndSweep resultPS = new PostureAndSweep(Posture.GROUNDED, sweep);
        Streamability.setPostureAndSweep(block, resultPS);
        return resultPS;
    }

    private Operand[] getChildren() {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression arg = exp.getArg(0);
        return ((Block)arg).getOperanda();
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression block = exp.getArg(0);
        if (!(block instanceof Block)) {
            return super.getWatchMaker(forGrouping);
        }
        Operand[] actions = this.getChildren();
        if (this.actionInversions == null) {
            this.actionInversions = new Inversion[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Expression action = actions[i].getChildExpression();
                this.actionInversions[i] = Streamability.getSweep(action) == Sweep.CONSUMING ? Inversion.invertExpression(action, forGrouping) : null;
            }
        }
        return (watchManager, out, context) -> new Trigger(AnchorPattern.getInstance(), new NewMapForkingFeed(this.getExpression(), this, out, context, watchManager), context);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new NewMapSimpleFeed(this.getExpression(), out, context);
    }

    private static class NewMapSimpleFeed
    extends ItemFeed {
        HashTrieMap resultMap;

        NewMapSimpleFeed(Expression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.resultMap = new HashTrieMap();
        }

        @Override
        public void append(Item item) throws XPathException {
            if (item instanceof MapItem) {
                for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                    boolean existing = this.resultMap.initialPut(pair.key, pair.value);
                    if (!existing) continue;
                    XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                    this.dynamicError(err);
                }
            } else {
                XPathException err = new XPathException("Argument to map constructor contains an item that is not a map", "XPTY0004");
                err.setIsTypeError(true);
                this.dynamicError(err);
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Outputter out = this.getNextOutputter();
                out.append(this.resultMap);
                out.close();
            }
            this.resultMap = null;
        }
    }

    private static class SingleProngFeed
    extends ItemFeed {
        private final NewMapForkingFeed forkingFeed;

        public SingleProngFeed(Expression expression, ItemFeed out, XPathContext context, NewMapForkingFeed forkingFeed) {
            super(expression, out, context);
            this.forkingFeed = forkingFeed;
        }

        @Override
        public void open(Terminator terminator) {
        }

        @Override
        public void append(Item item) throws XPathException {
            for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                if (this.forkingFeed.containsKey(pair.key)) {
                    XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                    this.dynamicError(err);
                    continue;
                }
                this.forkingFeed.addEntry(pair.key, pair.value);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void setHasFailed() {
            this.forkingFeed.setHasFailed();
        }
    }

    private static class NewMapForkingFeed
    extends ItemFeed {
        private final NewMapStreamer streamer;
        private final WatchManager watchManager;
        private MapItem resultMap;

        NewMapForkingFeed(Expression exp, NewMapStreamer streamer, ItemFeed result, XPathContext context, WatchManager watchManager) {
            super(exp, result, context);
            this.streamer = streamer;
            this.watchManager = watchManager;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.resultMap = new HashTrieMap();
            Operand[] actions = this.streamer.getChildren();
            for (int i = 0; i < actions.length; ++i) {
                Expression action = actions[i].getChildExpression();
                if (Streamability.getSweep(action) == Sweep.CONSUMING) {
                    SingleProngFeed feed = new SingleProngFeed(this.getExpression(), this.getResultFeed(), this.getContext(), this);
                    this.watchManager.addWatch(this.streamer.actionInversions[i].getWatch(this.watchManager, feed, this.getContext()), true);
                    continue;
                }
                MapItem sm = (MapItem)action.evaluateItem(this.getContext());
                for (KeyValuePair pair : sm.keyValuePairs()) {
                    if (this.resultMap.get(pair.key) != null) {
                        XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                        this.dynamicError(err);
                        continue;
                    }
                    this.resultMap = this.resultMap.addEntry(pair.key, pair.value);
                }
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }

        @Override
        public void append(Item item) throws XPathException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Outputter out = this.getNextOutputter();
                out.append(this.resultMap);
                out.close();
            }
            this.resultMap = null;
        }

        public boolean containsKey(AtomicValue key) {
            return this.resultMap.get(key) != null;
        }

        public void addEntry(AtomicValue key, GroundedValue value) {
            this.resultMap = this.resultMap.addEntry(key, value);
        }
    }
}

