/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.BooleanValue;

public abstract class BooleanElaborator
extends Elaborator {
    @Override
    public PullEvaluator elaborateForPull() {
        BooleanEvaluator b = this.elaborateForBoolean();
        return context -> SingletonIterator.makeIterator(BooleanValue.get(b.eval(context)));
    }

    @Override
    public PushEvaluator elaborateForPush() {
        BooleanEvaluator b = this.elaborateForBoolean();
        return (out, context) -> {
            out.append(BooleanValue.get(b.eval(context)));
            return null;
        };
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        BooleanEvaluator b = this.elaborateForBoolean();
        return context -> BooleanValue.get(b.eval(context));
    }

    @Override
    public abstract BooleanEvaluator elaborateForBoolean();

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        BooleanEvaluator b = this.elaborateForBoolean();
        return context -> b.eval(context) ? StringConstants.TRUE : StringConstants.FALSE;
    }
}

