/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public abstract class ToItemCompiler
extends ExpressionCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileToItem(compiler, expression);
        Generator ga = compiler.getCurrentGenerator();
        ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        ToItemCompiler.visitAnnotation(compiler, "ToItemCompiler-Boolean");
        this.compileToItem(compiler, expression);
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int itemVar = methodInfo.allocateLocal(Item.class);
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ga.storeLocal(itemVar);
        LabelInfo lab = methodInfo.newLabel("lab");
        LabelInfo end = methodInfo.newLabel("endToitem");
        if (Cardinality.allowsZero(expression.getCardinality())) {
            ga.loadLocal(itemVar);
            ga.ifNonNull(lab.label());
            ga.push(0);
            ga.goTo(end);
            methodInfo.placeLabel(lab);
        }
        if (th.relationship(expression.getItemType(), BuiltInAtomicType.BOOLEAN) != 4) {
            ga.loadLocal(itemVar);
            ga.instanceOf(Type.getType(BooleanValue.class));
            LabelInfo notBoolean = methodInfo.newLabel("notBoolean");
            ga.ifZCmp(153, notBoolean.label());
            ga.loadLocal(itemVar);
            ga.checkClass(BooleanValue.class);
            ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(notBoolean);
        }
        if (th.relationship(expression.getItemType(), NumericType.getInstance()) != 4) {
            ga.loadLocal(itemVar);
            ga.instanceOf(Type.getType(NumericValue.class));
            LabelInfo notNumeric = methodInfo.newLabel("notNumeric");
            ga.ifFalse(notNumeric);
            ga.loadLocal(itemVar);
            ga.checkClass(AtomicValue.class);
            ga.invokeInstanceMethod(AtomicValue.class, "effectiveBooleanValue", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(notNumeric);
        }
        if (th.relationship(expression.getItemType(), BuiltInAtomicType.STRING) != 4 || th.relationship(expression.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4 || th.relationship(expression.getItemType(), BuiltInAtomicType.ANY_URI) != 4) {
            ga.loadLocal(itemVar);
            ga.instanceOf(Type.getType(StringValue.class));
            LabelInfo notString = methodInfo.newLabel("notString");
            ga.ifZCmp(153, notString.label());
            ga.loadLocal(itemVar);
            ga.checkClass(StringValue.class);
            ga.invokeInstanceMethod(StringValue.class, "isZeroLength", new Class[0]);
            ga.not();
            ga.goTo(end);
            methodInfo.placeLabel(notString);
        }
        if (th.relationship(expression.getItemType(), AnyNodeTest.getInstance()) != 4) {
            ga.loadLocal(itemVar);
            ga.instanceOf(Type.getType(NodeInfo.class));
            LabelInfo notNode = methodInfo.newLabel("notNode");
            ga.ifZCmp(153, notNode.label());
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(notNode);
        }
        compiler.generateDynamicError("Effective boolean value is not defined for an item other than a boolean, number, string, or URI", "FORG0006", expression.getLocation(), false);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(itemVar);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        ToItemCompiler.visitAnnotation(compiler, "ToItemCompilerPush");
        compiler.generateGetReceiver();
        this.compileToItem(compiler, expression);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class);
    }

    protected void returnZeroLengthStringIfNull(Expression arg, Generator ga, GeneratedMethodInfo methodInfo, LabelInfo returnLabel, int extraPops) {
        if (Cardinality.allowsZero(arg.getCardinality())) {
            LabelInfo stringArgNonNull = methodInfo.newLabel("stringArgNonNull");
            ga.dup();
            ga.ifNonNull(stringArgNonNull.label());
            for (int i = 0; i < extraPops + 1; ++i) {
                ga.pop();
            }
            ga.push("");
            ga.goTo(returnLabel);
            methodInfo.placeLabel(stringArgNonNull);
        }
    }
}

