/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import java.util.Stack;

public abstract class OnEmpty {
    public static final OnEmpty RETURN_EMPTY_STRING = new ReturnEmptyString();
    public static final OnEmpty RETURN_NULL = new ReturnNull();

    public abstract void generate(Generator var1);

    public static class ReturnEmptyString
    extends OnEmpty {
        @Override
        public void generate(Generator ga) {
            ga.push("");
        }
    }

    public static class ReturnNull
    extends OnEmpty {
        @Override
        public void generate(Generator ga) {
            ga.pushNull();
        }
    }

    public static class UnwindAndJump
    extends OnEmpty {
        LabelInfo label;
        Stack<Class> theUnwindStack;

        public UnwindAndJump(Stack<Class> unwindStack, LabelInfo label) {
            this.label = label;
            this.theUnwindStack = unwindStack;
        }

        public UnwindAndJump(LabelInfo label) {
            this.label = label;
            this.theUnwindStack = null;
        }

        @Override
        public void generate(Generator ga) {
            Stack<Class> u = this.theUnwindStack;
            if (u != null) {
                for (int i = u.size() - 1; i >= 0; --i) {
                    Class c = (Class)u.get(i);
                    if (c == Double.TYPE || c == Long.TYPE) {
                        ga.pop2();
                        continue;
                    }
                    ga.pop();
                }
            }
            ga.goTo(this.label);
        }

        public LabelInfo getLabel() {
            return this.label;
        }

        public Stack<Class> getUnwindStack() {
            if (this.theUnwindStack == null) {
                this.theUnwindStack = new Stack();
            }
            return this.theUnwindStack;
        }
    }
}

