/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.s9api;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.s9api.SchemaValidatorImpl;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class SchemaManagerImpl
extends SchemaManager {
    private Processor processor;
    private ErrorListener errorListener;

    public SchemaManagerImpl(Processor processor) {
        this.processor = processor;
        this.errorListener = null;
    }

    @Override
    public void setXsdVersion(String version) {
        if (!version.equals("1.0") && !version.equals("1.1")) {
            throw new IllegalArgumentException("XsdVersion");
        }
        this.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", version);
    }

    @Override
    public String getXsdVersion() {
        return this.processor.getUnderlyingConfiguration().getXsdVersion() == 10 ? "1.0" : "1.1";
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        ((EnterpriseConfiguration)this.processor.getUnderlyingConfiguration()).setSchemaURIResolver(resolver);
    }

    @Override
    public SchemaURIResolver getSchemaURIResolver() {
        return ((EnterpriseConfiguration)this.processor.getUnderlyingConfiguration()).getSchemaURIResolver();
    }

    @Override
    public void load(Source source) throws SaxonApiException {
        try {
            this.processor.getUnderlyingConfiguration().addSchemaSource(source, this.errorListener);
        }
        catch (SchemaException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public void importComponents(Source source) throws SaxonApiException {
        try {
            this.processor.getUnderlyingConfiguration().importComponents(source);
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    @Override
    public void exportComponents(Destination destination) throws SaxonApiException {
        try {
            Configuration config = this.processor.getUnderlyingConfiguration();
            Receiver out = destination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
            config.exportComponents(out);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public SchemaValidator newSchemaValidator() {
        return new SchemaValidatorImpl(this.processor);
    }
}

