/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.DeleteAction;
import com.saxonica.ee.update.PendingUpdateListImpl;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class DeleteExpression
extends BasicUpdatingExpression {
    private Operand operand;

    public DeleteExpression(Expression target) {
        this.operand = new Operand(this, target, OperandRole.INSPECT);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.operand);
    }

    public Expression getTargetExp() {
        return this.operand.getChildExpression();
    }

    public void setTargetExp(Expression targetExp) {
        this.operand.setChildExpression(targetExp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        RoleDiagnostic role0 = new RoleDiagnostic(10, "delete", 0);
        role0.setErrorCode("XUTY0007");
        this.setTargetExp(visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getTargetExp(), SequenceType.NODE_SEQUENCE, role0, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        DeleteExpression d2 = new DeleteExpression(this.getTargetExp().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, d2);
        return d2;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("delete", this);
        this.getTargetExp().export(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        NodeInfo node;
        SequenceIterator<?> iter = this.getTargetExp().iterate(context);
        while ((node = (NodeInfo)iter.next()) != null) {
            if (!(node instanceof MutableNodeInfo)) {
                XPathException err = new XPathException("Node to be deleted is not an updateable node", "SXUP0081");
                err.setLocation(this.getLocation());
                throw err;
            }
            if (node.getParent() == null) continue;
            try {
                DeleteAction action = new DeleteAction(node);
                action.setOriginator(this);
                ((PendingUpdateListImpl)pul).add(action);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                e.maybeSetContext(context);
                throw e;
            }
        }
    }

    @Override
    public String getExpressionName() {
        return "delete";
    }
}

