/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;

public class XSDList
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition;
    private boolean foundItemType = false;

    @Override
    public void prepareAttributes() throws SchemaException {
        this.typeDefinition = this.getContainingSimpleType();
        this.typeDefinition.setDerivationMethodName("list");
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "itemType"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String itemTypeName = atts.getValue("", "itemType");
        if (itemTypeName != null) {
            int itemTypeFingerprint;
            this.foundItemType = true;
            try {
                itemTypeFingerprint = this.getFingerprint(itemTypeName, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            if (itemTypeFingerprint == 634 || itemTypeFingerprint == 633) {
                this.warning("Type " + itemTypeName + " is recognized by Saxon but is not interoperable");
            } else if (itemTypeFingerprint == 573 || itemTypeFingerprint == 631 || itemTypeFingerprint == 630) {
                this.error("Type " + itemTypeName + " cannot be used as an item type");
            }
            TypeReference typeRef = new TypeReference(itemTypeFingerprint, (EnterpriseConfiguration)this.getConfiguration(), this);
            this.typeDefinition.setItemTypeReference(typeRef);
        }
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        boolean foundAnnotation = false;
        boolean foundSimpleType = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        block4: while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    if (foundSimpleType) {
                        this.mustBeFirstElement("annotation");
                    }
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block4;
                }
                case 621: {
                    if (this.foundItemType) {
                        this.mutuallyExclusiveElementAndAttribute("simpleType", "itemType");
                    }
                    if (foundSimpleType) {
                        this.duplicateElement("simpleType");
                    }
                    foundSimpleType = true;
                    continue block4;
                }
            }
            this.illegalElement(child);
        }
        if (!this.foundItemType && !foundSimpleType) {
            String err = "A <list> element must either have an @itemType attribute or a <simpleType> child";
            this.error(err);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            if (child.getFingerprint() != 621) continue;
            SimpleTypeDefinition itemType = ((XSDSimpleType)child).getSimpleTypeDefinition();
            TypeReference typeRef = new TypeReference(itemType.getFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), (XSDSimpleType)child);
            typeRef.setTarget(itemType);
            this.typeDefinition.setItemTypeReference(typeRef);
        }
    }
}

