/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.validate.Checker;
import com.saxonica.ee.validate.SelectorWatch;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class FieldChecker
extends Checker {
    private SelectorWatch parentWatch;
    private NamespaceResolver namespaceResolver;
    private AtomicSequence[] currentRow;
    private int column;
    private boolean matchElements;
    private boolean active = false;
    private boolean nillableElement = false;
    private NodeName elementName;
    private SchemaType elementType;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private Location textLocationId = null;
    int depth = 0;

    public FieldChecker(SelectorWatch parentWatch, Pattern selection, AtomicSequence[] currentRow, int column) {
        this.parentWatch = parentWatch;
        this.currentRow = currentRow;
        this.column = column;
        this.matchElements = selection.getUType().overlaps(UType.ELEMENT);
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.nillableElement = false;
        if (this.matchElements) {
            if (this.depth > 0) {
                ValidationFailure ve = new ValidationFailure("An element participating as a field in a constraint cannot have child elements");
                ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                throw ve.makeException();
            }
            this.elementType = typeCode;
            this.elementName = nameCode;
            this.active = true;
            this.buffer.setLength(0);
        }
        ++this.depth;
    }

    public void notifySelectedAttribute(FleetingNode attribute, Location locationId) throws XPathException {
        Configuration config = this.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        SimpleType type = (SimpleType)attribute.getSchemaType();
        String value = attribute.getStringValue();
        if (!type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            AtomicSequence val;
            try {
                if (type.isNamespaceSensitive()) {
                    val = type.getTypedValue(value, this.namespaceResolver, rules);
                } else if (type.isAtomicType()) {
                    EnumerationFacetSet en;
                    AtomicType prim = ((AtomicType)type).getPrimitiveItemType();
                    StringConverter converter = prim.getStringConverter(this.getConfiguration().getConversionRules());
                    val = converter.convertString(value).asAtomic();
                    if (type instanceof UserAtomicType && (en = (EnumerationFacetSet)((UserAtomicType)type).getFacet(EnumerationFacetSet.class)) != null) {
                        val = en.getSharedInstance(val);
                    }
                } else {
                    val = type.getTypedValue(value, this.namespaceResolver, rules);
                }
            }
            catch (XPathException e) {
                throw new ValidationException(e);
            }
            this.parentWatch.addFieldValue(this.currentRow, this.column, val, false, locationId);
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            this.buffer.append(chars);
        }
        this.nillableElement = (properties & 0x200) != 0;
        this.textLocationId = locationId;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            AtomicSequence val;
            SchemaType eltype = this.elementType;
            if (eltype == null || eltype instanceof AnySimpleType) {
                val = new UntypedAtomicValue(this.buffer.toString());
            } else {
                SchemaType contentType = eltype;
                if (eltype instanceof ComplexType) {
                    if (((ComplexType)eltype).isSimpleContent()) {
                        contentType = ((ComplexType)eltype).getSimpleContentType();
                    } else {
                        ValidationFailure err = new ValidationFailure("The value of a field participating in an identity constraint must have a simple type, or a complex type with simple content. Element " + this.elementName.getDisplayName() + " has type " + eltype.getDescription());
                        err.setConstraintReference(1, "cvc-identity-constraint", "3");
                        throw err.makeException();
                    }
                }
                assert (contentType != null);
                if (contentType.getFingerprint() == 513) {
                    val = StringValue.makeStringValue(this.buffer.toString());
                } else if (((SimpleType)contentType).isNamespaceSensitive()) {
                    val = ((SimpleType)contentType).getTypedValue(this.buffer, this.namespaceResolver, this.getConfiguration().getConversionRules());
                } else if (contentType.isAtomicType()) {
                    EnumerationFacetSet en;
                    AtomicType prim = ((AtomicType)contentType).getPrimitiveItemType();
                    StringConverter converter = prim.getStringConverter(this.getConfiguration().getConversionRules());
                    val = converter.convertString(this.buffer).asAtomic();
                    if (contentType instanceof UserAtomicType && (en = (EnumerationFacetSet)((UserAtomicType)contentType).getFacet(EnumerationFacetSet.class)) != null) {
                        val = en.getSharedInstance(val);
                    }
                } else {
                    val = ((SimpleType)contentType).getTypedValue(this.buffer, this.namespaceResolver, this.getConfiguration().getConversionRules());
                }
            }
            this.parentWatch.addFieldValue(this.currentRow, this.column, val, this.nillableElement, this.textLocationId);
        }
        --this.depth;
    }

    @Override
    public void close() {
        this.active = false;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }
}

