/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.option.dom4j.DOM4JDocumentWrapper;
import net.sf.saxon.option.dom4j.DOM4JWriter;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class DOM4JObjectModel
extends TreeModel
implements ExternalObjectModel {
    private static DOM4JObjectModel THE_INSTANCE = new DOM4JObjectModel();

    public static DOM4JObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getDocumentClassName() {
        return "org.dom4j.Document";
    }

    @Override
    public String getIdentifyingURI() {
        return "http://www.dom4j.org/jaxp/xpath/dom4j";
    }

    @Override
    public String getName() {
        return "DOM4J";
    }

    @Override
    public Builder makeBuilder(PipelineConfiguration pipe) {
        return new DOM4JWriter(pipe);
    }

    @Override
    public PJConverter getPJConverter(Class<?> targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(Sequence<?> value, Class<?> targetClass, XPathContext context) throws XPathException {
                    return DOM4JObjectModel.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass, Configuration config) {
        if (this.isRecognizedNodeClass(sourceClass)) {
            return new JPConverter(){

                @Override
                public Sequence<?> convert(Object object, XPathContext context) throws XPathException {
                    return DOM4JObjectModel.this.convertObjectToXPathValue((Node)object, context.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    private static boolean isRecognizedNode(Object object) {
        return object instanceof Document || object instanceof Element || object instanceof Attribute || object instanceof Text || object instanceof CDATA || object instanceof Comment || object instanceof ProcessingInstruction || object instanceof Namespace;
    }

    private boolean isRecognizedNodeClass(Class nodeClass) {
        return Document.class.isAssignableFrom(nodeClass) || Element.class.isAssignableFrom(nodeClass) || Attribute.class.isAssignableFrom(nodeClass) || Text.class.isAssignableFrom(nodeClass) || CDATA.class.isAssignableFrom(nodeClass) || Comment.class.isAssignableFrom(nodeClass) || ProcessingInstruction.class.isAssignableFrom(nodeClass) || Namespace.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver) throws XPathException {
        return false;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    private Sequence<?> convertObjectToXPathValue(Node object, Configuration config) throws XPathException {
        if (DOM4JObjectModel.isRecognizedNode(object)) {
            if (object instanceof Document) {
                return this.wrapDocument(object, "", config).getRootNode();
            }
            Document root = this.getDocumentRoot(object);
            TreeInfo docInfo = this.wrapDocument(root, "", config);
            return this.wrapNode(docInfo, object);
        }
        return null;
    }

    private Object convertXPathValueToObject(Sequence<?> value, Class<?> targetClass) {
        Object u;
        if (value instanceof VirtualNode && targetClass.isAssignableFrom((u = ((VirtualNode)value).getRealNode()).getClass())) {
            return u;
        }
        return null;
    }

    public TreeInfo wrapDocument(Object node, String baseURI, Configuration config) {
        Document documentNode = this.getDocumentRoot(node);
        return new DOM4JDocumentWrapper(documentNode, baseURI, config);
    }

    public NodeInfo wrapNode(TreeInfo document, Node node) {
        return ((DOM4JDocumentWrapper)document).wrap(node);
    }

    private Document getDocumentRoot(Object node) {
        while (!(node instanceof Document)) {
            if (node instanceof Element) {
                if (((Element)node).isRootElement()) {
                    return ((Element)node).getDocument();
                }
                node = ((Element)node).getParent();
                continue;
            }
            if (node instanceof Text) {
                node = ((Text)node).getParent();
                continue;
            }
            if (node instanceof Comment) {
                node = ((Comment)node).getParent();
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                node = ((ProcessingInstruction)node).getParent();
                continue;
            }
            if (node instanceof Attribute) {
                node = ((Attribute)node).getParent();
                continue;
            }
            if (node instanceof Namespace) {
                throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
            }
            throw new IllegalStateException("Unknown DOM4J node type " + node.getClass());
        }
        return (Document)node;
    }
}

