/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.om.SequenceIterator;

public class SquareArrayConstructorCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        OperandArray operanda = ((SquareArrayConstructor)expression).getOperanda();
        SquareArrayConstructorCompiler.visitAnnotation(compiler, "ArrayBlockCompiler");
        if (operanda.getNumberOfOperands() == 0) {
            SquareArrayConstructorCompiler.allocateStatic(compiler, SimpleArrayItem.EMPTY_ARRAY);
        } else {
            SquareArrayConstructorCompiler.visitLineNumber(compiler, ga, expression);
            int listVar = methodInfo.allocateLocal(ArrayList.class);
            ga.newInstance(SimpleArrayItem.class);
            ga.dup();
            ga.newInstance(ArrayList.class);
            ga.dup();
            ga.invokeConstructor(ArrayList.class, new Class[0]);
            ga.storeLocal(listVar);
            for (Operand o : expression.operands()) {
                Expression child = o.getChildExpression();
                ga.loadLocal(listVar);
                if (child instanceof Literal) {
                    SquareArrayConstructorCompiler.allocateStatic(compiler, ((Literal)child).getValue());
                } else if (child.getCardinality() == 16384) {
                    compiler.compileToItem(child);
                } else {
                    compiler.compileToIterator(child);
                    ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
                }
                ga.invokeInstanceMethod(List.class, "add", Object.class);
                ga.pop();
            }
            ga.loadLocal(listVar);
            ga.invokeConstructor(SimpleArrayItem.class, List.class);
        }
    }
}

