/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public abstract class ElementCreatorCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        int properties;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        this.identifyExpression(compiler, expression, "push");
        ElementCreatorCompiler.visitAnnotation(compiler, "ElementCreator-push");
        ElementCreatorCompiler.visitLineNumber(compiler, ga, expression);
        ElementCreator elementCreator = (ElementCreator)expression;
        Enum typeCode = elementCreator.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
        int resetReceiver = 0;
        int nodeNameVar = -1;
        if (!elementCreator.isPreservingTypes()) {
            ++resetReceiver;
            if (elementCreator.getValidationAction() == 4) {
                ElementCreatorCompiler.addTypeStripper(compiler);
            } else {
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
                compiler.generateGetReceiver();
                ga.newInstance(ParseOptions.class);
                ga.dup();
                ElementCreatorCompiler.allocateStatic(compiler, elementCreator.getValidationOptions());
                ga.invokeConstructor(ParseOptions.class, ParseOptions.class);
                ga.dup();
                this.pushNodeName(compiler, elementCreator);
                nodeNameVar = methodInfo.allocateLocal(NodeName.class);
                ga.dup();
                ga.storeLocal(nodeNameVar);
                ga.invokeInstanceMethod(NodeName.class, "getStructuredQName", new Class[0]);
                ga.invokeInstanceMethod(ParseOptions.class, "setTopLevelElement", StructuredQName.class);
                ElementCreatorCompiler.allocateStatic(compiler, expression.getLocation());
                ga.invokeInstanceMethod(Configuration.class, "getElementValidator", Receiver.class, ParseOptions.class, Location.class);
                int validatorVar = methodInfo.allocateLocal(Receiver.class);
                ga.storeLocal(validatorVar);
                ga.loadLocal(validatorVar);
                compiler.generateGetReceiver();
                LabelInfo sameReceiver = methodInfo.newLabel("sameReceiver");
                LabelInfo doneReceiver = methodInfo.newLabel("doneReceiver");
                ga.ifSameObject(sameReceiver);
                ga.newInstance(Type.getType(TreeReceiver.class));
                ga.dup();
                ga.loadLocal(validatorVar);
                ga.invokeConstructor(TreeReceiver.class, Receiver.class);
                ga.goTo(doneReceiver);
                methodInfo.placeLabel(sameReceiver);
                compiler.generateGetReceiver();
                methodInfo.placeLabel(doneReceiver);
                compiler.pushNewReceiverInfo(ga);
                methodInfo.releaseLocal(validatorVar);
            }
        }
        LabelInfo nonNullSystemId = methodInfo.newLabel("nonNullSystemId");
        if (elementCreator.getStaticBaseURIString() != null) {
            compiler.generateGetReceiver();
            ga.showObject(compiler, "Receiver: ");
            ga.invokeInstanceMethod(Receiver.class, "getSystemId", new Class[0]);
            ga.ifNonNull(nonNullSystemId.label());
            ElementCreatorCompiler.visitAnnotation(compiler, "ElementCreator-setting system ID to " + elementCreator.getStaticBaseURIString());
            compiler.generateGetReceiver();
            ga.push(elementCreator.getStaticBaseURIString());
            ga.invokeInstanceMethod(Receiver.class, "setSystemId", String.class);
            methodInfo.placeLabel(nonNullSystemId);
        }
        Expression content = elementCreator.getContentExpression();
        Location locationId = expression.getLocation();
        int n = properties = elementCreator.isInheritNamespacesToChildren() ? 0 : 128;
        if (!elementCreator.isInheritNamespacesFromParent()) {
            properties |= 0x10000;
        }
        compiler.generateGetReceiver();
        if (nodeNameVar == -1) {
            this.pushNodeName(compiler, expression);
        } else {
            ga.loadLocal(nodeNameVar);
        }
        ElementCreatorCompiler.allocateStatic(compiler, typeCode);
        ElementCreatorCompiler.allocateStatic(compiler, locationId);
        ga.push(properties);
        ga.invokeInstanceMethod(Receiver.class, "startElement", NodeName.class, SchemaType.class, Location.class, Integer.TYPE);
        this.outputNamespaceNodes(compiler, expression);
        if (!Literal.isEmptySequence(content)) {
            compiler.compileToPush(content);
        }
        compiler.generateGetReceiver();
        ga.invokeInstanceMethod(Receiver.class, "endElement", new Class[0]);
        for (int i = 0; i < resetReceiver; ++i) {
            compiler.popReceiverInfo();
        }
        methodInfo.releaseLocal(nodeNameVar);
    }

    protected void outputNamespaceNodes(CompilerService compiler, Expression expression) {
    }

    protected abstract void pushNodeName(CompilerService var1, Expression var2) throws CannotCompileException;

    protected static void addTypeStripper(CompilerService compiler) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo noStripNeeded = methodInfo.newLabel("noStripNeeded");
        LabelInfo returnReceiver = methodInfo.newLabel("returnReceiver");
        compiler.generateGetReceiver();
        ga.invokeInstanceMethod(Receiver.class, "usesTypeAnnotations", new Class[0]);
        ga.ifFalse(noStripNeeded);
        ga.newInstance(TreeReceiver.class);
        ga.dup();
        ga.newInstance(SkipValidator.class);
        ga.dup();
        compiler.generateGetReceiver();
        ga.invokeConstructor(SkipValidator.class, Receiver.class);
        ga.invokeConstructor(TreeReceiver.class, Receiver.class);
        ga.goTo(returnReceiver);
        methodInfo.placeLabel(noStripNeeded);
        compiler.generateGetReceiver();
        methodInfo.placeLabel(returnReceiver);
        compiler.pushNewReceiverInfo(ga);
    }

    public abstract void identifyExpression(CompilerService var1, Expression var2, String var3);
}

