/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.ee.bytecode.util.ByteCodeTrace;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.NamedLabel;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.GeneratorAdapter;
import com.saxonica.objectweb.asm.commons.Method;
import java.lang.reflect.Modifier;

public class Generator
extends GeneratorAdapter {
    private static String[] exceptionList = new String[]{"net/sf/saxon/trans/XPathException"};
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public Generator(int access, Method method, boolean throwsXPathException, ClassVisitor cv) {
        super(262144, cv.visitMethod(access, method.getName(), method.getDescriptor(), null, (String[])(throwsXPathException ? exceptionList : null)), access, method.getName(), method.getDescriptor());
    }

    public void ifInstance(Class theClass, LabelInfo label) {
        this.instanceOf(Type.getType(theClass));
        this.ifZCmp(154, label.label());
    }

    public void ifNotInstance(Class theClass, LabelInfo label) {
        this.instanceOf(Type.getType(theClass));
        this.ifZCmp(153, label.label());
    }

    public void goTo(LabelInfo labelInfo) {
        this.goTo(labelInfo.label());
    }

    public void pushNull() {
        this.push((String)null);
    }

    public void ifTrue(LabelInfo label) {
        this.ifZCmp(154, label.label());
    }

    public void ifFalse(LabelInfo label) {
        this.ifZCmp(153, label.label());
    }

    public void ifSameObject(LabelInfo label) {
        this.mv.visitJumpInsn(165, label.label());
    }

    public void ifNotSameObject(LabelInfo label) {
        this.mv.visitJumpInsn(166, label.label());
    }

    public void checkClass(Class theClass) {
        if (theClass.isPrimitive()) {
            throw new AssertionError((Object)"Cannot do checkClass against a primitive type");
        }
        this.checkCast(Type.getType(theClass));
    }

    public void addComment(CompilerService compiler, String message) {
        if (compiler.isDebugByteCode()) {
            NamedLabel label = new NamedLabel();
            label.setName("%" + message);
            super.visitLabel(label);
        }
    }

    public void showMessage(CompilerService compiler, String message) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.push(message);
            this.invokeStaticMethod(ByteCodeTrace.class, "showMessage", String.class);
        }
    }

    public void showObject(CompilerService compiler, String label) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.dup();
            ga.push(label);
            ga.swap();
            ga.dup();
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            LabelInfo nullLab = methodInfo.newLabel("nullCheck");
            LabelInfo exitLab = methodInfo.newLabel("exitShowObject");
            ga.ifNull(nullLab.label());
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            this.invokeStaticMethod(ByteCodeTrace.class, "showObjectVariable", String.class, String.class);
            ga.goTo(exitLab);
            methodInfo.placeLabel(nullLab);
            ga.pop();
            ga.push("null");
            this.invokeStaticMethod(ByteCodeTrace.class, "showObjectVariable", String.class, String.class);
            methodInfo.placeLabel(exitLab);
        }
    }

    public void showObjectVariable(CompilerService compiler, String name, int slot) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.push(name);
            ga.loadArgOrLocal(slot);
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            this.invokeStaticMethod(ByteCodeTrace.class, "showObjectVariable", String.class, String.class);
        }
    }

    public void showLongVariable(CompilerService compiler, String name, int slot) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.push(name);
            ga.loadLocal(slot);
            this.invokeStaticMethod(ByteCodeTrace.class, "showLongVariable", String.class, Long.TYPE);
        }
    }

    public void showIntVariable(CompilerService compiler, String name, int slot) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.push(name);
            ga.loadLocal(slot);
            this.invokeStaticMethod(ByteCodeTrace.class, "showIntVariable", String.class, Integer.TYPE);
        }
    }

    public void getStaticField(Class theClass, String fieldName, Class fieldClass) {
        this.getStatic(Type.getType(theClass), fieldName, Type.getType(fieldClass));
    }

    public void invokeStaticMethod(Class<?> theClass, String methodName, Class ... argTypes) {
        try {
            java.lang.reflect.Method rMethod = theClass.getMethod(methodName, argTypes);
            if (!Modifier.isStatic(rMethod.getModifiers() & 8)) {
                throw new NoSuchMethodException();
            }
            this.invokeStatic(Type.getType(theClass), Method.getMethod(rMethod));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Generating call on non-existent method " + methodName + " in class " + theClass.getName()));
        }
    }

    public void invokeInstanceMethod(Class<?> theClass, String methodName, Class ... argTypes) {
        if (theClass.isPrimitive()) {
            throw new AssertionError((Object)"Cannot invoke instance methods on a primitive type");
        }
        try {
            java.lang.reflect.Method method = theClass.getMethod(methodName, argTypes);
            if (Modifier.isStatic(method.getModifiers() & 8)) {
                throw new NoSuchMethodException("Method " + methodName + " is static");
            }
            if (theClass.isInterface()) {
                this.invokeInterface(Type.getType(theClass), Method.getMethod(method));
            } else {
                this.invokeVirtual(Type.getType(theClass), Method.getMethod(method));
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void getInstanceField(Class theClass, String fieldName) {
        try {
            this.getField(Type.getType(theClass), fieldName, Type.getType(theClass.getField(fieldName).getType()));
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void invokeDefaultConstructor(Class<?> theClass) {
        this.newInstance(Type.getType(theClass));
        this.dup();
        try {
            this.invokeConstructor(Type.getType(theClass), Method.getMethod(theClass.getConstructor(EMPTY_CLASS_ARRAY)));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void newInstance(Class theClass) {
        if (theClass.isPrimitive()) {
            throw new AssertionError((Object)"Cannot instantiate a primitive type");
        }
        this.newInstance(Type.getType(theClass));
    }

    public void invokeConstructor(Class<?> theClass, Class<?> ... argTypes) {
        if (theClass.isPrimitive()) {
            throw new AssertionError((Object)"Cannot instantiate a primitive type");
        }
        try {
            this.invokeConstructor(Type.getType(theClass), Method.getMethod(theClass.getConstructor(argTypes)));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int newLocal(Class<?> theClass) {
        return this.newLocal(Type.getType(theClass));
    }

    @Override
    public void loadLocal(int local) {
        this.checkLocal(local);
        super.loadLocal(local);
    }

    public void loadArgOrLocal(int slot) {
        if (slot < this.firstLocal) {
            this.loadArg(slot);
        } else {
            this.loadLocal(slot);
        }
    }

    @Override
    public void storeLocal(int local) {
        this.checkLocal(local);
        super.storeLocal(local);
    }

    public void storeArgOrLocal(int slot) {
        if (slot < this.firstLocal) {
            this.storeArg(slot);
        } else {
            this.storeLocal(slot);
        }
    }

    @Override
    public Type getLocalType(int local) {
        this.checkLocal(local);
        return super.getLocalType(local);
    }

    private void checkLocal(int local) {
        if (local < this.firstLocal) {
            throw new IllegalArgumentException("local (" + local + ") is < firstLocal (" + this.firstLocal + ")");
        }
    }

    public void visitTryCatchBlock(LabelInfo start, LabelInfo end, LabelInfo handler, String type) {
        start.isUsed = true;
        end.isUsed = true;
        handler.isUsed = true;
        this.visitTryCatchBlock(start.label(), end.label(), handler.label(), type);
    }

    public void concatenateStrings(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.swap();
                this.newInstance(StringBuilder.class);
                this.dupX2();
                this.swap();
                this.invokeConstructor(StringBuilder.class, String.class);
                this.invokeInstanceMethod(StringBuilder.class, "append", String.class);
                this.invokeInstanceMethod(Object.class, "toString", new Class[0]);
                break;
            }
            case 3: {
                this.dupX2();
                this.pop();
                this.swap();
                this.newInstance(StringBuilder.class);
                this.dup();
                this.invokeConstructor(StringBuilder.class, new Class[0]);
                this.swap();
                this.invokeInstanceMethod(StringBuilder.class, "append", String.class);
                this.swap();
                this.invokeInstanceMethod(StringBuilder.class, "append", String.class);
                this.swap();
                this.invokeInstanceMethod(StringBuilder.class, "append", String.class);
                this.invokeInstanceMethod(Object.class, "toString", new Class[0]);
                break;
            }
            default: {
                this.newInstance(StringBuilder.class);
                this.dupX1();
                this.swap();
                this.invokeConstructor(StringBuilder.class, String.class);
                for (int i = 1; i < n; ++i) {
                    this.swap();
                    this.push(0);
                    this.swap();
                    this.invokeInstanceMethod(StringBuilder.class, "insert", Integer.TYPE, String.class);
                }
                this.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            }
        }
    }
}

