/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import javax.xml.validation.TypeInfoProvider;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.w3c.dom.TypeInfo;

public class TypedContentHandler
extends ContentHandlerProxy {
    private SchemaType pendingElementTypeCode = null;

    public TypeInfoProvider getTypeInfoProvider() {
        return new TypeInfoProviderImpl();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.pendingElementTypeCode = typeCode;
        super.startElement(nameCode, typeCode, location, properties);
    }

    public class TypeInfoProviderImpl
    extends TypeInfoProvider {
        @Override
        public TypeInfo getElementTypeInfo() {
            if (TypedContentHandler.this.pendingElementTypeCode == null) {
                return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), AnyType.getInstance());
            }
            return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), TypedContentHandler.this.pendingElementTypeCode);
        }

        @Override
        public TypeInfo getAttributeTypeInfo(int index) {
            if (index < 0 || index > TypedContentHandler.this.pendingAttributes.getLength()) {
                throw new IndexOutOfBoundsException("" + index);
            }
            SimpleType type = TypedContentHandler.this.pendingAttributes.getTypeAnnotation(index);
            return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), type);
        }

        @Override
        public boolean isIdAttribute(int index) {
            try {
                SimpleType type = TypedContentHandler.this.pendingAttributes.getTypeAnnotation(index);
                return type.isIdType();
            }
            catch (MissingComponentException e) {
                return false;
            }
        }

        @Override
        public boolean isSpecified(int index) {
            return (TypedContentHandler.this.pendingAttributes.getProperties(index) & 8) == 0;
        }
    }
}

