/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class IXSLFunctionSet
extends BuiltInFunctionSet {
    private static IXSLFunctionSet THE_INSTANCE = new IXSLFunctionSet();
    public static ScriptEngine engine = null;

    public static IXSLFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private IXSLFunctionSet() {
        this.init();
    }

    private void init() {
        this.register("page", 0, Stub.class, NodeKindTest.DOCUMENT, 24576, 0, 8704);
        this.register("source", 0, Source.class, AnyItemType.getInstance(), 24576, 0, 512);
        this.register("window", 0, Stub.class, AnyItemType.getInstance(), 24576, 0, 512);
        this.register("query-params", 0, Stub.class, MapType.ANY_MAP_TYPE, 16384, 0, 8704);
        this.register("event", 0, Stub.class, AnyItemType.getInstance(), 24576, 0, 8704);
        this.register("location", 0, Stub.class, AnyItemType.getInstance(), 24576, 0, 8704);
        this.register("style", 1, Stub.class, AnyItemType.getInstance(), 24576, 0, 8704).arg(0, AnyItemType.getInstance(), 24576, null);
        this.register("get", 2, Stub.class, AnyItemType.getInstance(), 57344, 0, 8704).arg(0, AnyItemType.getInstance(), 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        this.register("call", 3, Call.class, AnyItemType.getInstance(), 24576, 0, 8704).arg(0, AnyItemType.getInstance(), 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, ArrayItemType.getInstance(), 16384, null);
        this.register("eval", 1, Eval.class, AnyItemType.getInstance(), 57344, 0, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null);
        this.register("apply", 2, Stub.class, AnyItemType.getInstance(), 24576, 0, 8704).arg(0, AnyItemType.getInstance(), 16384, null).arg(1, ArrayItemType.getInstance(), 16384, null);
        this.register("schedule-action", 3, Stub.class, AnyItemType.getInstance(), 57344, 0, 8704).arg(0, BuiltInAtomicType.INTEGER, 16384, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, AnyItemType.getInstance(), 57344, null);
        this.register("schedule-action", 4, Stub.class, AnyItemType.getInstance(), 57344, 0, 8704).arg(0, BuiltInAtomicType.INTEGER, 16384, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, AnyItemType.getInstance(), 57344, null).arg(3, MapType.ANY_MAP_TYPE, 24576, null);
        this.register("set-attribute", 2, Stub.class, AnyItemType.getInstance(), 57344, 0, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        this.register("remove-attribute", 2, Stub.class, AnyItemType.getInstance(), 24576, 0, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        this.register("set-property", 3, Stub.class, AnyItemType.getInstance(), 24576, 0, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 24576, null).arg(2, AnyItemType.getInstance(), 16384, null);
        this.register("set-style", 3, Stub.class, AnyItemType.getInstance(), 24576, 0, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, AnyItemType.getInstance(), 16384, null);
    }

    @Override
    public String getNamespace() {
        return "http://saxonica.com/ns/interactiveXSLT";
    }

    @Override
    public String getConventionalPrefix() {
        return "ixsl";
    }

    public static ScriptEngine obtainEngine() throws XPathException {
        ScriptEngine engine;
        if (IXSLFunctionSet.engine == null && (engine = new ScriptEngineManager().getEngineByName("nashorn")) == null) {
            throw new XPathException("Javascript extensions not available (needs Java 8)");
        }
        return IXSLFunctionSet.engine;
    }

    private static Sequence<?> convertFromJavaScript(Object result) throws XPathException {
        if (result instanceof String) {
            return new StringValue((String)result);
        }
        if (result instanceof Double) {
            return new DoubleValue((Double)result);
        }
        if (result instanceof Boolean) {
            return BooleanValue.get((Boolean)result);
        }
        if (result instanceof Collection) {
            ArrayList items = new ArrayList();
            for (Object val : (Collection)result) {
                SequenceIterator<?> converted = IXSLFunctionSet.convertFromJavaScript(val).iterate();
                converted.forEachOrFail(items::add);
            }
            return new SequenceExtent(items);
        }
        return EmptySequence.getInstance();
    }

    private static Object convertToJavaScript(Sequence<?> supplied) throws XPathException {
        if (supplied instanceof NumericValue) {
            return ((NumericValue)supplied).getDoubleValue();
        }
        if (supplied instanceof BooleanValue) {
            return ((BooleanValue)supplied).getBooleanValue();
        }
        if (supplied instanceof AtomicValue) {
            return ((AtomicValue)supplied).getStringValue();
        }
        ArrayList list = new ArrayList();
        SequenceIterator<?> iter = supplied.iterate();
        iter.forEachOrFail(next -> list.add(IXSLFunctionSet.convertToJavaScript(next)));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            return list;
        }
        return list.get(0);
    }

    public static class Eval
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
            ScriptEngine engine = IXSLFunctionSet.obtainEngine();
            try {
                engine.eval(arguments[0].head().getStringValue());
            }
            catch (ScriptException e) {
                throw new XPathException("Failure in ixsl:eval(): ", e);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class Call
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
            ScriptEngine engine = IXSLFunctionSet.obtainEngine();
            Object target = IXSLFunctionSet.convertToJavaScript(arguments[0]);
            String method = IXSLFunctionSet.convertToJavaScript(arguments[1]).toString();
            Object[] args = new Object[arguments.length - 2];
            for (int i = 2; i < arguments.length; ++i) {
                args[i - 2] = IXSLFunctionSet.convertToJavaScript(arguments[i]);
            }
            try {
                Object result = ((Invocable)((Object)engine)).invokeMethod(target, method, args);
                return IXSLFunctionSet.convertFromJavaScript(result);
            }
            catch (ScriptException e) {
                throw new XPathException("Failure in ixsl:call(): ", e);
            }
            catch (NoSuchMethodException e) {
                throw new XPathException("Failure in ixsl:call(): method " + method + " is not defined", e);
            }
        }
    }

    public static class ScheduleActionFn
    extends SystemFunction {
        Location location;

        @Override
        public Expression makeFunctionCall(Expression ... arguments) {
            Expression[] copiedArgs = Arrays.copyOf(arguments, arguments.length);
            copiedArgs[2] = Literal.makeLiteral(new ObjectValue<Expression>(arguments[2]));
            ExpressionTool.copyLocationInfo(arguments[2], copiedArgs[2]);
            this.location = arguments[0].getLocation();
            return super.makeFunctionCall(copiedArgs);
        }

        @Override
        public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
            IntegerValue wait = (IntegerValue)arguments[0].head();
            StringValue documents = (StringValue)arguments[1].head();
            ObjectValue wrappedActionObject = (ObjectValue)arguments[2].head();
            Expression action = (Expression)wrappedActionObject.getObject();
            if (documents != null) {
                Whitespace.Tokenizer tokenIter = new Whitespace.Tokenizer(documents.getStringValueCS());
                String baseURI = this.getRetainedStaticContext().getStaticBaseUriString();
                PackageData pd = this.getRetainedStaticContext().getPackageData();
                ParseOptions options = context.getConfiguration().getParseOptions();
                SequenceIterator<NodeInfo> mapped = context.getConfiguration().getMultithreadedItemMappingIterator(tokenIter, token -> DocumentFn.makeDoc(token.getStringValue(), baseURI, pd, options, context, this.location, false));
                mapped.materialize();
                return new LazySequence(action.iterate(context));
            }
            return EmptySequence.getInstance();
        }
    }

    public static class Source
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item<?> source = context.getController().getGlobalContextItem();
            return new ZeroOrOne(source);
        }
    }

    public static class Stub
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext context, Sequence[] args) throws XPathException {
            throw new XPathException("ixsl:" + this.getDetails().name.getLocalPart() + " is available only in Saxon-JS");
        }
    }
}

