/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.optim.GeneralComparisonEE;
import com.saxonica.ee.optim.IndexedFilterExpression;
import com.saxonica.ee.optim.SwitchExpression;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.trans.PackageLoaderPE;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class PackageLoaderEE
extends PackageLoaderPE {
    public PackageLoaderEE(EnterpriseConfiguration config) {
        super(config);
    }

    @Override
    protected UserFunction makeFunction(String flags) {
        if (flags.matches(".*[AIFSDC].*")) {
            return new StreamableUserFunction();
        }
        return super.makeFunction(flags);
    }

    static {
        eMap.put("gcEE", (loader, element) -> {
            String opAtt = element.getAttributeValue("", "op");
            int op = PackageLoaderEE.getOperator(opAtt);
            Expression lhs = loader.getFirstChildExpression(element);
            Expression rhs = loader.getSecondChildExpression(element);
            String compAtt = element.getAttributeValue("", "comp");
            AtomicComparer comp = loader.makeAtomicComparer(compAtt, element);
            GeneralComparisonEE gc = new GeneralComparisonEE(lhs, op, rhs);
            gc.setAtomicComparer(comp);
            return gc;
        });
        eMap.put("indexedFilter", (loader, element) -> {
            Expression lhs = loader.getFirstChildExpression(element);
            Expression rhs = loader.getSecondChildExpression(element);
            String useAtt = element.getAttributeValue("", "use");
            return new IndexedFilterExpression((VariableReference)lhs, (ComparisonExpression)((Object)rhs), "left".equals(useAtt));
        });
        eMap.put("indexedFilter2", (loader, element) -> {
            Expression base = loader.getExpressionWithRole(element, "base");
            Expression use = loader.getExpressionWithRole(element, "use");
            Expression search = loader.getExpressionWithRole(element, "search");
            String compAtt = element.getAttributeValue("", "comp");
            AtomicComparer comp = loader.makeAtomicComparer(compAtt, element);
            String flags = element.getAttributeValue("", "flags");
            boolean convertUntyped = flags != null && flags.contains("u");
            return new IndexedFilterExpression(base, use, search, comp, convertUntyped);
        });
        eMap.put("indexedLookup", (loader, element) -> {
            throw new XPathException("indexedLookup expression is no longer supported: please recompile stylesheet");
        });
        eMap.put("stream", (loader, element) -> {
            loader.needsEELicense("streaming");
            int valSpecified = loader.getIntegerAttribute(element, "validation");
            int validation = valSpecified == Integer.MIN_VALUE ? 4 : valSpecified;
            SchemaType schemaType = null;
            StructuredQName typeAtt = loader.getQNameAttribute(element, "schemaType");
            if (typeAtt != null) {
                schemaType = loader.getConfiguration().getSchemaType(typeAtt);
                validation = 8;
            }
            ParseOptions options = new ParseOptions(loader.getConfiguration().getParseOptions());
            options.setSchemaValidationMode(validation);
            options.setTopLevelType(schemaType);
            String flags = element.getAttributeValue("", "flags");
            if (flags != null && flags.contains("s")) {
                loader.addCompletionAction(() -> options.setSpaceStrippingRule(loader.getPackage().getSpaceStrippingRule()));
            }
            Expression body = loader.getExpressionWithRole(element, "body");
            Expression href = loader.getExpressionWithRole(element, "href");
            StreamInstr inst = new StreamInstr(href, body, options);
            String accumulatorNames = element.getAttributeValue("", "accum");
            PackageLoaderEE.processAccumulatorList(loader, inst, accumulatorNames);
            Block block = new Block(new Expression[]{inst});
            loader.addCompletionAction(() -> {
                Expression e2 = inst.prepareForStreaming(loader.getPackStack().peek());
                Expression parent = block.getParentExpression();
                if (parent != null) {
                    Operand op = ExpressionTool.findOperand(parent, block);
                    if (op != null) {
                        op.setChildExpression(e2);
                    }
                } else if (e2 != inst) {
                    block.getOperanda()[0].setChildExpression(e2);
                }
            });
            return block;
        });
        eMap.put("switch", (loader, element) -> {
            SwitchExpression.SwitchCaseInfo info = new SwitchExpression.SwitchCaseInfo();
            info.collation = loader.getConfiguration().getCollation(element.getAttributeValue("", "coll"));
            info.commonlhs = loader.getExpressionWithRole(element, "value");
            info.defaultAction = loader.getExpressionWithRole(element, "default");
            AxisIterator cases = element.iterateAxis((byte)3, new NameTest(1, "http://ns.saxonica.com/xslt/export", "case", loader.getConfiguration().getNamePool()));
            cases.forEachOrFail(aCase -> {
                Expression val = loader.getFirstChildExpression((NodeInfo)aCase);
                AtomicValue av = (AtomicValue)((Literal)val).getValue();
                info.values.add(av);
                info.actions.add(loader.getSecondChildExpression((NodeInfo)aCase));
            });
            info.makeIndex();
            return new SwitchExpression(info);
        });
    }
}

