/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.validate.ContentValidator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class LaxValidator
extends ContentValidator {
    public LaxValidator(Receiver next) {
        super(next);
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType typeCode, Location location, int properties) throws XPathException {
        int fp = nodeName.obtainFingerprint(this.getNamePool());
        ElementDecl decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
        this.makeChildValidator(decl, nodeName.getStructuredQName(), location, 2);
        this.checkNoChildrenWhenNil(location);
        typeCode = this.childValidator.getAnnotation();
        super.startElement(nodeName, typeCode, location, properties);
    }

    @Override
    public ContentValidator getChildValidator() {
        return this.childValidator;
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        int fingerprint = attName.obtainFingerprint(this.getNamePool());
        if (fingerprint == 642) {
            if (this.getNillability() == ContentValidator.Nillability.DISALLOWED) {
                String message = "The element is not nillable, so xsi:nil must not be present";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "3.1");
                ve.setSchemaType(this.getSchemaType());
                this.reportValidationError(ve, true, locationId);
            }
            String b = Whitespace.trim(value);
            if (this.getNillability() != ContentValidator.Nillability.IGNORED && (b.equals("true") || b.equals("1"))) {
                this.nil = true;
            }
        }
        SimpleType annotation = BuiltInAtomicType.UNTYPED_ATOMIC;
        AttributeDecl decl = (AttributeDecl)this.getConfiguration().getAttributeDeclaration(attName.getStructuredQName());
        if (decl != null) {
            SimpleType type = decl.getSimpleType();
            ValidationFailure err = type.validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules());
            if (err != null) {
                err.setConstraintReference(1, "cvc-complex-type", "3");
                err.setSchemaType(type);
                this.reportValidationError(err, false, locationId);
            } else {
                if (type instanceof UserAtomicType) {
                    value = ((UserAtomicType)type).getSharedInstance(value.toString());
                }
                annotation = type;
                ValueConstraint constraint = decl.getFixedValueConstraint();
                if (constraint != null && !constraint.testFixedValue(this.getConfiguration(), value, type, this.getNamespaceResolver())) {
                    AtomicSequence fixed = decl.getFixedValue();
                    String message = "The actual value " + Err.wrap(value, 4) + " of attribute " + Err.wrap(attName.getDisplayName(), 2) + " does not match the required fixed value " + (fixed instanceof AtomicValue ? Err.wrap(fixed.getStringValue(), 4) : "");
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-au", "0");
                    ve.setSchemaType(type);
                    this.reportValidationError(ve, false, locationId);
                }
            }
        }
        super.attribute(attName, annotation, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        super.characters(chars, locationId, properties);
    }
}

