/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.TypeHierarchy;

public class AscentFunctionCallAdjunct
extends StreamingAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        UserFunction target = exp.getFunction();
        OperandArray operanda = exp.getOperanda();
        operanda.getOperand(0).setUsage(OperandUsage.TRANSMISSION);
        for (int i = 1; i < operanda.getNumberOfOperands(); ++i) {
            operanda.getOperand(i).setUsage(Operand.typeDeterminedUsage(target.getArgumentType(i).getPrimaryType()));
        }
        PostureAndSweep ps0 = Streamability.generalStreamabilityRules(exp, operanda, contextInfo, reasons);
        if (ps0.getSweep() != Sweep.MOTIONLESS) {
            reasons.add("The sweep of the function is not motionless");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.getPosture() == Posture.ROAMING) {
            reasons.add("The posture of the function is roaming");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.getPosture() == Posture.GROUNDED) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (th.relationship(target.getResultType().getPrimaryType(), AnyNodeTest.getInstance()) != 4) {
            return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
        }
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }
}

