/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.SelectorWatch;
import java.util.Map;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationFailure;

public class RefSelectorWatch
extends SelectorWatch {
    Location lastLocation = null;

    public RefSelectorWatch(ConstraintChecker checker, KeyRef constraint) {
        super(checker, constraint);
    }

    public void notifyActualKey(AtomicSequence[] keyValue, Location locationId) throws XPathException {
        this.checkRow(keyValue, true, locationId);
        this.lastLocation = locationId.saveLocation();
    }

    @Override
    public void close() throws XPathException {
        int errorCount = 0;
        for (Map.Entry e : this.table.entrySet()) {
            int count;
            SelectorWatch.ValueEntry entry = (SelectorWatch.ValueEntry)e.getKey();
            int info = (Integer)e.getValue();
            if ((info & 1) == 0 || (count = info >> 16 & 0xFFFF) == 1) continue;
            String card = count == 0 ? "No" : "More than one";
            ValidationFailure ve = new ValidationFailure(card + " referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + ": " + entry);
            ve.setConstraintReference(1, "cvc-identity-constraint", "4.3");
            int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            this.reportValidationError(ve, this.lastLocation);
            if (errorCount++ <= 100) continue;
            break;
        }
    }
}

