/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer;

import experimental.analyzer.AnalyzerTag;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import marmot.morph.Word;

public class AnalyzerReading
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String lemma_;
    private AnalyzerTag tag_;
    private int count_;

    public AnalyzerReading(AnalyzerTag tag, String lemma) {
        this.tag_ = tag;
        this.lemma_ = lemma;
    }

    public AnalyzerReading(Word word) {
        this(new AnalyzerTag(word.getPosTag(), word.getMorphTag()), word.getLemma());
    }

    public String toString() {
        if (this.lemma_ == null) {
            return this.tag_.toString();
        }
        return String.format("%s %s", this.tag_, this.lemma_);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.lemma_ == null ? 0 : this.lemma_.hashCode());
        result2 = 31 * result2 + (this.tag_ == null ? 0 : this.tag_.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzerReading other = (AnalyzerReading)obj;
        if (this.lemma_ == null ? other.lemma_ != null : !this.lemma_.equals(other.lemma_)) {
            return false;
        }
        return !(this.tag_ == null ? other.tag_ != null : !this.tag_.equals(other.tag_));
    }

    public static Collection<AnalyzerTag> toTags(Collection<AnalyzerReading> readings) {
        HashSet<AnalyzerTag> tags = new HashSet<AnalyzerTag>();
        for (AnalyzerReading reading : readings) {
            tags.add(reading.getTag());
        }
        return new LinkedList<AnalyzerTag>(tags);
    }

    public AnalyzerTag getTag() {
        return this.tag_;
    }

    public void setCount(int count2) {
        this.count_ = count2;
    }

    public int getCount() {
        return this.count_;
    }
}

