/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.util.ByteCodeTrace;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.ClassReader;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.util.CheckClassAdapter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public abstract class ExpressionCompiler {
    public abstract void compileToItem(CompilerService var1, Expression var2) throws CannotCompileException;

    public abstract void compileToIterator(CompilerService var1, Expression var2) throws CannotCompileException;

    public abstract void compileToBoolean(CompilerService var1, Expression var2) throws CannotCompileException;

    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        this.compileToItem(compiler, expression);
        if (Item.class.isAssignableFrom(requiredClass)) {
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNullECItem");
                ga.dup();
                ga.ifNonNull(notNull.label());
                OnEmpty.UnwindAndJump longJump = (OnEmpty.UnwindAndJump)onEmpty;
                longJump.getUnwindStack().push(requiredClass);
                longJump.generate(ga);
                methodInfo.placeLabel(notNull);
                longJump.getUnwindStack().pop();
            }
            ga.checkClass(requiredClass);
        } else if (requiredClass == Double.TYPE) {
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNullECDbl");
                ga.dup();
                ga.ifNonNull(notNull.label());
                OnEmpty.UnwindAndJump longJump = (OnEmpty.UnwindAndJump)onEmpty;
                longJump.getUnwindStack().push(DoubleValue.class);
                longJump.generate(ga);
                methodInfo.placeLabel(notNull);
                longJump.getUnwindStack().pop();
            }
            ga.checkClass(DoubleValue.class);
            ga.invokeInstanceMethod(DoubleValue.class, "getDoubleValue", new Class[0]);
        } else if (requiredClass == Float.TYPE) {
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNullECFlt");
                ga.dup();
                ga.ifNonNull(notNull.label());
                OnEmpty.UnwindAndJump longJump = (OnEmpty.UnwindAndJump)onEmpty;
                longJump.getUnwindStack().push(FloatValue.class);
                longJump.generate(ga);
                methodInfo.placeLabel(notNull);
                longJump.getUnwindStack().pop();
            }
            ga.checkClass(FloatValue.class);
            ga.invokeInstanceMethod(FloatValue.class, "getFloatValue", new Class[0]);
        } else if (requiredClass == Integer.TYPE || requiredClass == Long.TYPE) {
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNullECFlt");
                ga.dup();
                ga.ifNonNull(notNull.label());
                OnEmpty.UnwindAndJump longJump = (OnEmpty.UnwindAndJump)onEmpty;
                longJump.getUnwindStack().push(Int64Value.class);
                longJump.generate(ga);
                methodInfo.placeLabel(notNull);
                longJump.getUnwindStack().pop();
            }
            ga.checkClass(IntegerValue.class);
            ga.invokeInstanceMethod(IntegerValue.class, "longValue", new Class[0]);
            if (requiredClass == Integer.TYPE) {
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            }
        } else if (requiredClass == CharSequence.class || requiredClass == String.class) {
            LabelInfo exit = null;
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("ECstrNotNull");
                ga.dup();
                ga.ifNonNull(notNull.label());
                exit = methodInfo.newLabel("itemToStringExit");
                ExpressionCompiler.handleEmptyStringResult(onEmpty, ga, methodInfo, exit);
                methodInfo.placeLabel(notNull);
            }
            ga.checkClass(StringValue.class);
            if (requiredClass == CharSequence.class) {
                ga.invokeInstanceMethod(StringValue.class, "getStringValueCS", new Class[0]);
            } else {
                ga.invokeInstanceMethod(StringValue.class, "getStringValueCS", new Class[0]);
                ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            }
            if (exit != null) {
                methodInfo.placeLabel(exit);
            }
        } else {
            throw new CannotCompileException("compilePrimitive requiredClass = " + requiredClass, false);
        }
    }

    public static void handleEmptyStringResult(OnEmpty onEmpty, Generator ga, GeneratedMethodInfo methodInfo, LabelInfo exit) {
        if (onEmpty instanceof OnEmpty.ReturnEmptyString) {
            ga.pop();
            ga.push("");
            ga.goTo(exit);
        } else if (onEmpty instanceof OnEmpty.ReturnNull) {
            ga.pop();
            ga.pushNull();
            ga.goTo(exit);
        } else if (onEmpty instanceof OnEmpty.UnwindAndJump) {
            OnEmpty.UnwindAndJump longJump = (OnEmpty.UnwindAndJump)onEmpty;
            longJump.getUnwindStack().push(StringValue.class);
            longJump.generate(ga);
            longJump.getUnwindStack().pop();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public abstract void compileToPush(CompilerService var1, Expression var2) throws CannotCompileException;

    protected final void compileItemFromInt(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ExpressionCompiler.visitAnnotation(compiler, "compileItemFromInt");
        OnEmpty.UnwindAndJump onEmpty = null;
        LabelInfo returnNull = methodInfo.newLabel("returnNull");
        if (Cardinality.allowsZero(expression.getCardinality())) {
            onEmpty = new OnEmpty.UnwindAndJump(returnNull);
        }
        this.compileToPrimitive(compiler, expression, Long.TYPE, onEmpty);
        ga.newInstance(Type.getType(Int64Value.class));
        ga.dupX2();
        ga.dupX2();
        ga.pop();
        ga.invokeConstructor(Int64Value.class, Long.TYPE);
        if (onEmpty != null) {
            LabelInfo exit = methodInfo.newLabel("exitItemFromInt");
            ga.goTo(exit);
            methodInfo.placeLabel(returnNull);
            ga.pushNull();
            methodInfo.placeLabel(exit);
        }
    }

    public static void visitAnnotation(CompilerService compiler, String message) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.addComment(compiler, message);
            ga.push(message);
            ga.invokeStaticMethod(ByteCodeTrace.class, "showMessage", String.class);
        }
    }

    public static void printStackTop(CompilerService compiler) {
        if (compiler.isDebugByteCode()) {
            Generator ga = compiler.getCurrentGenerator();
            ga.dup();
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            ga.push("STACK top:");
            ga.swap();
            ga.invokeInstanceMethod(String.class, "concat", String.class);
            ga.invokeStaticMethod(ByteCodeTrace.class, "showMessage", String.class);
        }
    }

    public static void allocateStatic(CompilerService compiler, Object value) {
        if (value == null) {
            compiler.getCurrentGenerator().pushNull();
        } else {
            CompilerService.StaticVariableInfo varInfo = compiler.allocateStaticVariableInfo(value);
            compiler.getCurrentGenerator().getStatic(Type.getType(compiler.getCurrentClass().getTypeDescriptor()), varInfo.name, Type.getType(varInfo.classVar));
        }
    }

    public static void verify(ClassWriter cw, String objectName, boolean debug) {
        if (debug) {
            StringWriter sw = new StringWriter();
            CheckClassAdapter.verify(new ClassReader(cw.toByteArray()), false, new PrintWriter(sw));
            if (sw.toString().length() != 0) {
                System.err.println("Verify Output for " + objectName + ":");
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter("ByteCodeOutput.txt"));
                    out.write(sw.toString());
                    out.close();
                }
                catch (IOException e) {
                    System.out.println("Exception ");
                }
                System.err.println(sw);
                throw new IllegalStateException("Bytecode failed verification");
            }
        }
    }

    public static void visitLineNumber(CompilerService compiler, Generator ga, Expression expr) {
        int line = expr.getLocation().getLineNumber();
        if (line != compiler.mostRecentLineNumber) {
            ga.visitLineNumber(line, ga.newLabel());
            compiler.mostRecentLineNumber = line;
        }
    }

    public void generateMethod(CompilerService compiler, Expression expression, ClassVisitor cv) {
    }
}

