/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SingletonAtomizerCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression arg = ((SingletonAtomizer)expression).getBaseExpression();
        if (!Cardinality.allowsMany(arg.getCardinality())) {
            this.compileSingletonInputToItem(compiler, expression);
        } else {
            Generator ga = compiler.getCurrentGenerator();
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            SingletonAtomizerCompiler.visitAnnotation(compiler, "SingletonAtomizerCompiler");
            RoleDiagnostic role = ((SingletonAtomizer)expression).getRole();
            Configuration config = compiler.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            ItemType baseType = arg.getItemType();
            boolean allowEmpty = ((SingletonAtomizer)expression).isAllowEmpty();
            boolean maybeNode = th.relationship(baseType, AnyNodeTest.getInstance()) != 4;
            boolean maybeAtomic = th.relationship(baseType, BuiltInAtomicType.ANY_ATOMIC) != 4;
            boolean maybeFunction = th.relationship(baseType, AnyFunctionType.getInstance()) != 4;
            boolean maybeExternal = th.relationship(baseType, config.getJavaExternalObjectType(Object.class)) != 4;
            boolean alwaysNode = th.isSubType(baseType, AnyNodeTest.getInstance());
            boolean alwaysAtomic = th.isSubType(baseType, BuiltInAtomicType.ANY_ATOMIC);
            boolean alwaysFunction = th.isSubType(baseType, AnyFunctionType.getInstance());
            boolean alwaysExternal = th.isSubType(baseType, config.getJavaExternalObjectType(Object.class));
            compiler.compileToIterator(arg);
            SingletonAtomizerCompiler.visitLineNumber(compiler, ga, expression);
            int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
            ga.storeLocal(iterVar);
            int countVar = ga.newLocal(Type.INT_TYPE);
            ga.push(0);
            ga.storeLocal(countVar);
            int resultVar = methodInfo.allocateLocal(Item.class);
            ga.pushNull();
            ga.storeLocal(resultVar);
            LabelInfo done = methodInfo.newLabel("doneAtomizer");
            LabelInfo isEmpty = methodInfo.newLabel("isEmpty");
            LabelInfo moreThanOne = methodInfo.newLabel("moreThanOne");
            LabelInfo loop = methodInfo.placeNewLabel("loop");
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            int itemVar = methodInfo.allocateLocal(Item.class);
            ga.storeLocal(itemVar);
            ga.loadLocal(itemVar);
            ga.ifNull(isEmpty.label());
            if (maybeAtomic) {
                SingletonAtomizerCompiler.visitAnnotation(compiler, " SingletonAtomizerCompiler-atomic");
                LabelInfo notAtomicLab = methodInfo.newLabel("notAtomicLab");
                if (!alwaysAtomic) {
                    ga.loadLocal(itemVar);
                    ga.ifNotInstance(AtomicValue.class, notAtomicLab);
                }
                ga.iinc(countVar, 1);
                ga.loadLocal(countVar);
                ga.push(1);
                ga.ifICmp(157, moreThanOne.label());
                ga.loadLocal(itemVar);
                ga.storeLocal(resultVar);
                ga.goTo(loop);
                methodInfo.placeLabel(notAtomicLab);
            }
            if (maybeExternal) {
                SingletonAtomizerCompiler.visitAnnotation(compiler, " SingletonAtomizerCompiler-external");
                LabelInfo notExternalLab = methodInfo.newLabel("notExternalLab");
                if (!alwaysExternal) {
                    ga.loadLocal(itemVar);
                    ga.ifNotInstance(ObjectValue.class, notExternalLab);
                }
                ga.iinc(countVar, 1);
                ga.loadLocal(countVar);
                ga.push(1);
                ga.ifICmp(157, moreThanOne.label());
                ga.loadLocal(itemVar);
                ga.invokeInstanceMethod(Item.class, "getStringValue", new Class[0]);
                ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
                ga.storeLocal(resultVar);
                ga.goTo(loop);
                methodInfo.placeLabel(notExternalLab);
            }
            if (maybeFunction) {
                SingletonAtomizerCompiler.visitAnnotation(compiler, " SingletonAtomizerCompiler-Function");
                LabelInfo notFnItemLab = methodInfo.newLabel("notFnItemLab");
                if (!alwaysFunction) {
                    ga.loadLocal(itemVar);
                    ga.ifNotInstance(Function.class, notFnItemLab);
                }
                compiler.generateDynamicError("A function item cannot appear as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
                methodInfo.placeLabel(notFnItemLab);
            }
            if (maybeNode) {
                SingletonAtomizerCompiler.visitAnnotation(compiler, " SingletonAtomizerCompiler-Node");
                if (!alwaysNode) {
                    ga.loadLocal(itemVar);
                    ga.ifNotInstance(NodeInfo.class, loop);
                }
                ga.loadLocal(itemVar);
                ga.checkClass(NodeInfo.class);
                ga.invokeInstanceMethod(NodeInfo.class, "atomize", new Class[0]);
                int valueVar = methodInfo.allocateLocal(AtomicSequence.class);
                ga.storeLocal(valueVar);
                ga.loadLocal(valueVar);
                ga.invokeInstanceMethod(AtomicSequence.class, "getLength", new Class[0]);
                ga.loadLocal(countVar);
                ga.math(96, Type.getType(Integer.TYPE));
                ga.storeLocal(countVar);
                ga.loadLocal(countVar);
                ga.push(1);
                ga.ifICmp(157, moreThanOne.label());
                ga.loadLocal(valueVar);
                ga.invokeInstanceMethod(Sequence.class, "head", new Class[0]);
                ga.storeLocal(resultVar);
                ga.goTo(loop);
                methodInfo.releaseLocal(valueVar);
            }
            methodInfo.placeLabel(moreThanOne);
            compiler.generateDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            methodInfo.placeLabel(isEmpty);
            methodInfo.placeLabel(done);
            if (!allowEmpty) {
                LabelInfo notEmpty = methodInfo.newLabel("notEmpty");
                ga.loadLocal(countVar);
                ga.ifZCmp(154, notEmpty.label());
                compiler.generateDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
                methodInfo.placeLabel(notEmpty);
            }
            ga.loadLocal(resultVar);
            methodInfo.releaseLocal(iterVar);
            methodInfo.releaseLocal(resultVar);
            methodInfo.releaseLocal(itemVar);
        }
    }

    private void compileSingletonInputToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression arg = ((SingletonAtomizer)expression).getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SingletonAtomizerCompiler.visitAnnotation(compiler, "SingletonAtomizerCompilerS-fromSingleton");
        RoleDiagnostic role = ((SingletonAtomizer)expression).getRole();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType baseType = arg.getItemType();
        boolean allowEmpty = ((SingletonAtomizer)expression).isAllowEmpty();
        boolean maybeNode = th.relationship(baseType, AnyNodeTest.getInstance()) != 4;
        boolean maybeTypedNode = maybeNode && expression.getPackageData().isSchemaAware();
        boolean maybeArray = th.relationship(baseType, ArrayItemType.getInstance()) != 4;
        LabelInfo done = methodInfo.newLabel("doneAtomizer");
        LabelInfo isEmpty = methodInfo.newLabel("isEmpty");
        compiler.compileToItem(arg);
        ga.dup();
        ga.ifNull(isEmpty.label());
        ga.invokeInstanceMethod(Item.class, "atomize", new Class[0]);
        if (maybeTypedNode || maybeArray) {
            ga.dup();
            ga.invokeInstanceMethod(AtomicSequence.class, "getLength", new Class[0]);
            if (!allowEmpty) {
                LabelInfo notEmpty = methodInfo.newLabel("notEmpty");
                ga.dup();
                ga.ifZCmp(154, notEmpty.label());
                ga.pop();
                ga.pop();
                ga.pushNull();
                ga.goTo(isEmpty);
                methodInfo.placeLabel(notEmpty);
            }
            ga.push(1);
            LabelInfo isSingleton = methodInfo.newLabel("isSingleton");
            ga.ifICmp(158, isSingleton.label());
            compiler.generateDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            methodInfo.placeLabel(isSingleton);
        }
        ga.invokeInstanceMethod(AtomicSequence.class, "head", new Class[0]);
        ga.goTo(done);
        methodInfo.placeLabel(isEmpty);
        if (!allowEmpty) {
            compiler.generateDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
        }
        methodInfo.placeLabel(done);
    }
}

