/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class AccumulatorRegistryEE
extends AccumulatorRegistry {
    public static Map<Accumulator, AccumulatorWatch> registerSelectedAccumulators(WatchManager watchManager, Set<? extends Accumulator> accumulators) throws XPathException {
        HashMap<Accumulator, AccumulatorWatch> watchMap = new HashMap<Accumulator, AccumulatorWatch>();
        for (Accumulator accumulator : accumulators) {
            AccumulatorWatch watch = new AccumulatorWatch(accumulator);
            watch.setWatchManager(watchManager);
            watchManager.addWatch(watch, true);
            watchMap.put(accumulator, watch);
        }
        return watchMap;
    }

    @Override
    public Sequence<?> getStreamingAccumulatorValue(NodeInfo node, Accumulator accumulator, AccumulatorFn.Phase phase) throws XPathException {
        if (node instanceof FleetingNode) {
            AccumulatorWatch accumulatorWatch;
            if (!accumulator.isDeclaredStreamable()) {
                throw new XPathException("Cannot get accumulator value for a streamed node unless the accumulator is declared streamable", "XTDE3362");
            }
            FleetingDocumentNode root = (FleetingDocumentNode)node.getRoot();
            Map<Accumulator, AccumulatorWatch> watchMap = root.getAccumulatorWatchMap();
            AccumulatorWatch accumulatorWatch2 = accumulatorWatch = watchMap == null ? null : watchMap.get(accumulator);
            if (accumulatorWatch == null) {
                throw new XPathException("The accumulator " + accumulator.getAccumulatorName().getDisplayName() + " is not in use for the current streamed document (check @use-accumulators)", "XTDE3362");
            }
            if (phase == AccumulatorFn.Phase.BEFORE) {
                if (accumulatorWatch.getCurrentPredescentNode() == node) {
                    throw new XPathException("Evaluation of accumulator " + accumulator.getAccumulatorName().getDisplayName() + " requires access to its own value", "XTDE3400");
                }
                return accumulatorWatch.getPreDescentValue((FleetingNode)node);
            }
            if (!accumulatorWatch.isDonePostDescent()) {
                throw new XPathException("Cannot call accumulator-after except during the post-descent phase of a streaming template", "XTDE3420");
            }
            return accumulatorWatch.getPostDescentValue();
        }
        return null;
    }
}

