/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFree;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class MinimaxStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : this.getDefaultFeedMaker(arg);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new MinimaxFeed(this.getExpression(), out, context);
    }

    private static class MinimaxFeed
    extends ItemFeed {
        private AtomicValue min;
        private AtomicComparer atomicComparer;
        private boolean foundDouble;
        private boolean foundFloat;
        private boolean foundNaN;
        private AtomicType lowestCommonSuperType;
        private boolean ignoreNaN;

        public MinimaxFeed(Expression expr, Feed result, XPathContext context) {
            super(expr, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            SystemFunction fn = call.getTargetFunction();
            this.ignoreNaN = fn instanceof Minimax && ((Minimax)call.getTargetFunction()).isIgnoreNaN();
            this.min = null;
            this.foundDouble = false;
            this.foundFloat = false;
            this.foundNaN = false;
            this.lowestCommonSuperType = null;
            this.getResult().open(terminator);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                AtomicValue value = (AtomicValue)item;
                TypeHierarchy th = this.getContext().getConfiguration().getTypeHierarchy();
                if (value instanceof UntypedAtomicValue) {
                    try {
                        StringToDouble converter = this.getContext().getConfiguration().getConversionRules().getStringToDoubleConverter();
                        value = new DoubleValue(converter.stringToNumber(value.getStringValueCS()));
                        this.foundDouble = true;
                    }
                    catch (NumberFormatException e) {
                        XPathException de = new XPathException("Failure converting " + Err.wrap(value.getStringValueCS()) + " to a number");
                        de.setErrorCode("FORG0001");
                        de.setXPathContext(this.getContext());
                        this.dynamicError(de);
                        return;
                    }
                } else if (value instanceof DoubleValue) {
                    this.foundDouble = true;
                } else if (value instanceof FloatValue) {
                    this.foundFloat = true;
                }
                if (value.isNaN()) {
                    if (this.ignoreNaN) {
                        return;
                    }
                    this.foundNaN = true;
                } else if (!value.getPrimitiveType().isOrdered(false)) {
                    XPathException de = new XPathException("Type " + value.getPrimitiveType() + " is not an ordered type");
                    de.setErrorCode("FORG0006");
                    de.setIsTypeError(true);
                    de.setXPathContext(this.getContext());
                    this.dynamicError(de);
                    return;
                }
                if (this.min == null) {
                    this.min = value;
                    this.lowestCommonSuperType = value.getItemType();
                } else {
                    if (this.atomicComparer == null) {
                        SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
                        SystemFunction targetFunction = call.getTargetFunction();
                        boolean isMax = false;
                        if (targetFunction instanceof Minimax) {
                            this.atomicComparer = ((Minimax)targetFunction).getAtomicComparer(this.getContext());
                            isMax = targetFunction instanceof Minimax.Max;
                        } else {
                            assert (targetFunction instanceof CollatingFunctionFree);
                            Expression collationArg = call.getArg(call.getArity() - 1);
                            String collationName = collationArg.evaluateAsString(this.getContext()).toString();
                            StringCollator collator = this.getContext().getConfiguration().getCollation(collationName);
                            if (collator == null) {
                                this.dynamicError(new XPathException("Unknown collation " + collationName, "FOCH0002"));
                            }
                            this.atomicComparer = new GenericAtomicComparer(collator, this.getContext());
                            isMax = targetFunction.getFunctionName().getLocalPart().equals("max");
                        }
                        if (isMax) {
                            this.atomicComparer = new DescendingComparer(this.atomicComparer);
                        }
                    }
                    this.lowestCommonSuperType = (AtomicType)Type.getCommonSuperType(this.lowestCommonSuperType, value.getItemType(), th);
                    try {
                        if (this.atomicComparer.compareAtomicValues(value, this.min) < 0) {
                            this.min = value;
                        }
                    }
                    catch (XPathException err) {
                        this.dynamicError(err);
                    }
                    catch (ClassCastException err) {
                        XPathException de = new XPathException("Cannot compare " + this.min.getItemType() + " with " + value.getItemType());
                        de.setErrorCode("FORG0006");
                        de.setIsTypeError(true);
                        de.setXPathContext(this.getContext());
                        this.dynamicError(de);
                    }
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                if (this.min != null) {
                    if (this.foundNaN) {
                        this.min = FloatValue.NaN;
                    }
                    ConversionRules rules = this.getContext().getConfiguration().getConversionRules();
                    if (this.foundDouble) {
                        if (!(this.min instanceof DoubleValue)) {
                            this.min = Converter.convert(this.min, BuiltInAtomicType.DOUBLE, rules);
                        }
                    } else if (this.foundFloat && !(this.min instanceof FloatValue)) {
                        this.min = Converter.convert(this.min, BuiltInAtomicType.FLOAT, rules);
                    }
                    if (this.lowestCommonSuperType != NumericType.getInstance()) {
                        this.min = Converter.convert(this.min, this.lowestCommonSuperType, rules);
                    }
                    this.getResult().processItem(this.min);
                }
                this.getResult().close();
            }
        }
    }
}

