/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.trans.XPathException;

public class DecomposingFeed
implements Feed {
    private Receiver receiver;
    private Stack<Boolean> nodeKindStack = new Stack();

    public DecomposingFeed(Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.receiver.getPipelineConfiguration();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(SequenceReceiver out) {
        this.receiver = out;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        boolean isDocNode = node instanceof FleetingDocumentNode;
        this.nodeKindStack.push(isDocNode);
        if (isDocNode) {
            this.receiver.startDocument(0);
        } else {
            NamespaceBinding[] namespaces;
            FleetingElementNode element = (FleetingElementNode)node;
            this.receiver.startElement(NameOfNode.makeName(element), node.getSchemaType(), locationId, 0);
            AttributeCollection atts = element.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.receiver.attribute(atts.getNodeName(i), atts.getTypeAnnotation(i), atts.getValue(i), locationId, 0);
            }
            for (NamespaceBinding nb : namespaces = element.getDeclaredNamespaces(null)) {
                this.receiver.namespace(nb, 0);
            }
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        boolean isDocNode = this.nodeKindStack.pop();
        if (isDocNode) {
            this.receiver.endDocument();
        } else {
            this.receiver.endElement();
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.receiver.append(item);
    }

    @Override
    public void close() throws XPathException {
    }
}

