/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class OuterNewlineInserter
extends ProxyReceiver {
    private int level = 0;
    private boolean beforeFirstElement = true;

    public OuterNewlineInserter(XMLEmitter next) {
        super(next);
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType type, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(nameCode, type, location, properties);
        ++this.level;
        this.beforeFirstElement = false;
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.level == 0 && !this.beforeFirstElement) {
            this.characters("\n", locationId, 0);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        if (this.level == 0 && this.beforeFirstElement) {
            this.characters("\n", locationId, 0);
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0 && !this.beforeFirstElement) {
            this.characters("\n", locationId, 0);
        }
        this.nextReceiver.comment(chars, locationId, properties);
        if (this.level == 0 && this.beforeFirstElement) {
            this.characters("\n", locationId, 0);
        }
    }
}

